/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.tools.launcher.gui;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class StatusPanel
extends JPanel {
    static final String RUNNING_STATUS = "RUNNING";
    static final String COMPLETE_STATUS = "COMPLETE";
    static final String FAILED_STATUS = "FAILED";
    private String status;
    private ButtonGroup leds;
    private JRadioButton runningLed;
    private JRadioButton completeLed;
    private JRadioButton failedLed;
    private Icon ledOff = new ImageIcon(this.getClass().getResource("images/disabled.png"));
    private Icon runningIcon = new ImageIcon(this.getClass().getResource("images/running.png"));
    private Icon completeIcon = new ImageIcon(this.getClass().getResource("images/complete.png"));
    private Icon failedIcon = new ImageIcon(this.getClass().getResource("images/failed.png"));
    private Font ledFont = new Font("Monospaced", 1, 10);
    private Map<String, JRadioButton> ledMap = new HashMap<String, JRadioButton>();

    public StatusPanel() {
        this.initialize();
    }

    private void initialize() {
        this.leds = new ButtonGroup();
        Border line = BorderFactory.createEtchedBorder();
        JPanel ledPanel = new JPanel();
        ledPanel.setLayout(new BoxLayout(ledPanel, 0));
        ledPanel.setAlignmentY(0.5f);
        this.runningLed = new JRadioButton("Running", this.runningIcon);
        this.runningLed.setFont(this.ledFont);
        this.runningLed.setAlignmentX(0.0f);
        this.runningLed.setDisabledSelectedIcon(this.runningIcon);
        this.runningLed.setDisabledIcon(this.ledOff);
        this.runningLed.setEnabled(false);
        this.leds.add(this.runningLed);
        this.ledMap.put(RUNNING_STATUS, this.runningLed);
        ledPanel.add(this.runningLed);
        this.completeLed = new JRadioButton("Complete", this.completeIcon);
        this.completeLed.setFont(this.ledFont);
        this.completeLed.setAlignmentX(0.0f);
        this.completeLed.setDisabledSelectedIcon(this.completeIcon);
        this.completeLed.setDisabledIcon(this.ledOff);
        this.completeLed.setEnabled(false);
        this.leds.add(this.completeLed);
        this.ledMap.put(COMPLETE_STATUS, this.completeLed);
        ledPanel.add(this.completeLed);
        this.failedLed = new JRadioButton("Failed", this.failedIcon);
        this.failedLed.setFont(this.ledFont);
        this.failedLed.setAlignmentX(0.0f);
        this.failedLed.setDisabledSelectedIcon(this.failedIcon);
        this.failedLed.setDisabledIcon(this.ledOff);
        this.failedLed.setEnabled(false);
        this.leds.add(this.failedLed);
        this.ledMap.put(FAILED_STATUS, this.failedLed);
        ledPanel.add(this.failedLed);
        this.setLayout(new BoxLayout(this, 0));
        this.add(ledPanel);
    }

    void setStatus(String status) {
        JRadioButton led = this.ledMap.get(status);
        if (led != null) {
            this.status = status;
            led.setSelected(true);
        }
    }

    String getStatus() {
        return this.status;
    }

    void reset() {
        for (JRadioButton led : this.ledMap.values()) {
            led.setSelected(false);
        }
    }
}

