/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.tools.launcher.gui;

import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.tools.launcher.gui.LauncherGUI;
import com.tilab.wade.utils.GUIDGenerator;
import jade.gui.ClassSelectionDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public class WorkflowPanel
extends JPanel {
    private JLabel workflowLabel;
    private JComboBox workflowComboBox;
    private JComboBox performerComboBox;
    private JLabel agentLabel;
    private JLabel sessionIdLabel;
    private JTextField sessionIdTextField;
    private JButton workflowButton;
    private JButton sessionIdButton;
    private JLabel transactionalLabel;
    private JCheckBox transactionalCheckBox;
    private JLabel verbosityLevelLabel;
    private JComboBox verbosityLevelBox;
    private LauncherGUI launcherGUI;
    private List workflowList;
    private ClassSelectionDialog csd;
    private static final String WORKFLOW = "WORKFLOW";
    private static final String ACTIVITY = "ACTIVITY";
    private static final String APPLICATION = "APPLICATION";

    public WorkflowPanel(LauncherGUI launcherGUI) {
        this.launcherGUI = launcherGUI;
        this.initialize();
    }

    private void initialize() {
        this.agentLabel = new JLabel("Performet agent:", 11);
        this.add(this.agentLabel);
        this.performerComboBox = new JComboBox();
        this.performerComboBox.setEditable(true);
        this.agentLabel.setLabelFor(this.performerComboBox);
        this.performerComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String performerName = (String)WorkflowPanel.this.performerComboBox.getSelectedItem();
                if (performerName != null && !"".equals(performerName)) {
                    WorkflowPanel.this.launcherGUI.refreshActionsStatus();
                }
            }
        });
        this.add(this.performerComboBox);
        this.add(new JLabel());
        this.workflowLabel = new JLabel("Workflow:", 11);
        this.add(this.workflowLabel);
        this.workflowComboBox = new JComboBox();
        this.workflowComboBox.setEditable(true);
        this.workflowLabel.setLabelFor(this.workflowComboBox);
        this.workflowComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String workflowName;
                if ("comboBoxChanged".equals(e.getActionCommand()) && (workflowName = (String)WorkflowPanel.this.workflowComboBox.getSelectedItem()) != null && !"".equals(workflowName)) {
                    WorkflowPanel.this.launcherGUI.handleSelectedWorkflow(workflowName);
                    WorkflowPanel.this.launcherGUI.refreshActionsStatus();
                }
            }
        });
        this.add(this.workflowComboBox);
        this.workflowButton = new JButton("...");
        this.workflowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WorkflowPanel.this.csd == null) {
                    WorkflowPanel.this.csd = new ClassSelectionDialog((Dialog)new JDialog(), "Select Worfkflow", WorkflowBehaviour.class.getName());
                }
                if (WorkflowPanel.this.csd.doShow((Collection)WorkflowPanel.this.launcherGUI.getWadeWorkflows()) == 1) {
                    String workflowClassName = WorkflowPanel.this.csd.getSelectedClassname();
                    WorkflowPanel.this.workflowComboBox.addItem(workflowClassName);
                    WorkflowPanel.this.workflowComboBox.setSelectedItem(workflowClassName);
                    WorkflowPanel.this.launcherGUI.refreshActionsStatus();
                }
            }
        });
        this.add(this.workflowButton);
        this.sessionIdLabel = new JLabel("Session ID:", 11);
        this.add(this.sessionIdLabel);
        this.sessionIdTextField = new JTextField();
        this.sessionIdLabel.setLabelFor(this.sessionIdTextField);
        this.add(this.sessionIdTextField);
        this.sessionIdButton = new JButton("Generate");
        this.sessionIdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkflowPanel.this.sessionIdTextField.setText(GUIDGenerator.getGUID());
            }
        });
        this.add(this.sessionIdButton);
        this.verbosityLevelLabel = new JLabel("Verbosity Level:", 11);
        this.add(this.verbosityLevelLabel);
        this.verbosityLevelBox = new JComboBox();
        this.verbosityLevelBox.addItem(WORKFLOW);
        this.verbosityLevelBox.addItem(ACTIVITY);
        this.verbosityLevelBox.addItem(APPLICATION);
        this.verbosityLevelLabel.setLabelFor(this.verbosityLevelBox);
        this.add(this.verbosityLevelBox);
        this.add(new JLabel());
        this.transactionalLabel = new JLabel("Transactional:", 11);
        this.add(this.transactionalLabel);
        this.transactionalCheckBox = new JCheckBox();
        this.transactionalCheckBox.setEnabled(true);
        this.transactionalCheckBox.setSelected(false);
        this.transactionalLabel.setLabelFor(this.transactionalCheckBox);
        this.add(this.transactionalCheckBox);
        this.add(new JLabel());
        this.setLayout(new SpringLayout());
        WorkflowPanel.makeCompactGrid(this, 5, 3, 6, 6, 6, 6);
        this.setPreferredSize(new Dimension(500, 160));
    }

    private static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, WorkflowPanel.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = WorkflowPanel.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, WorkflowPanel.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = WorkflowPanel.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    void addWorkflow(String workflowName) {
        this.workflowComboBox.addItem(workflowName);
    }

    void removePerformer(String performerName) {
        this.performerComboBox.removeItem(performerName);
    }

    void addPerformer(String performerName) {
        this.performerComboBox.addItem(performerName);
    }

    void setWadeWorkflowList(List workflowList) {
        this.workflowList = workflowList;
    }

    String getSessionId() {
        return this.sessionIdTextField.getText();
    }

    String getPerformerName() {
        return (String)this.performerComboBox.getSelectedItem();
    }

    String getWorkflowName() {
        return (String)this.workflowComboBox.getSelectedItem();
    }

    boolean isTransactional() {
        return this.transactionalCheckBox.isSelected();
    }

    void setFieldsEnabled(boolean enabled) {
        this.workflowComboBox.setEnabled(enabled);
        this.performerComboBox.setEnabled(enabled);
        this.sessionIdTextField.setEnabled(enabled);
        this.workflowButton.setEnabled(enabled);
        this.sessionIdButton.setEnabled(enabled);
        this.transactionalCheckBox.setEnabled(enabled);
        this.verbosityLevelBox.setEnabled(enabled);
    }

    void reset() {
        this.workflowComboBox.setSelectedItem(null);
        this.performerComboBox.setSelectedItem(null);
        this.sessionIdTextField.setText(null);
        this.transactionalCheckBox.setSelected(false);
        this.verbosityLevelBox.setSelectedItem(WORKFLOW);
    }

    int getFlowLevel() {
        if (this.verbosityLevelBox.getSelectedItem().equals(WORKFLOW)) {
            return 3;
        }
        if (this.verbosityLevelBox.getSelectedItem().equals(ACTIVITY)) {
            return 4;
        }
        return 5;
    }
}

