/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.tools.management;

import com.tilab.wade.cfa.ontology.ConfigurationOntology;
import com.tilab.wade.tools.management.gui.ManagementGUI;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.util.Logger;

public class ManagementAgent
extends Agent {
    private ManagementGUI mngGUI;
    private Logger myLogger;

    protected void setup() {
        this.myLogger = Logger.getMyLogger((String)this.getName());
        this.getContentManager().registerLanguage((Codec)new SLCodec());
        this.getContentManager().registerOntology(ConfigurationOntology.getInstance());
        AID cfa = null;
        DFAgentDescription cfaTemplate = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType("Configuration Agent");
        cfaTemplate.addServices(sd);
        try {
            DFAgentDescription[] dfds = DFService.searchUntilFound((Agent)this, (AID)this.getDefaultDF(), (DFAgentDescription)cfaTemplate, null, (long)60000L);
            if (dfds.length > 0) {
                cfa = dfds[0].getName();
            }
            DFAgentDescription caTemplate = new DFAgentDescription();
            sd = new ServiceDescription();
            sd.setType("Control Agent");
            caTemplate.addServices(sd);
            this.mngGUI = new ManagementGUI(this, cfa, caTemplate);
            this.mngGUI.pack();
            this.mngGUI.setVisible(true);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Cannot retrieve Configuration Agent", (Throwable)e);
            this.doDelete();
        }
    }

    protected void takeDown() {
        if (this.mngGUI != null) {
            this.mngGUI.dispose();
        }
    }
}

