/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.tools.management.gui;

import com.tilab.wade.ca.JarDeployer;
import com.tilab.wade.cfa.ontology.ConfigurationOntology;
import com.tilab.wade.cfa.ontology.ExportConfiguration;
import com.tilab.wade.cfa.ontology.GetConfigurations;
import com.tilab.wade.cfa.ontology.ImportConfiguration;
import com.tilab.wade.cfa.ontology.SaveConfiguration;
import com.tilab.wade.cfa.ontology.ShutdownPlatform;
import com.tilab.wade.cfa.ontology.StartupPlatform;
import com.tilab.wade.commons.AgentType;
import com.tilab.wade.commons.TypeManager;
import com.tilab.wade.tools.management.gui.DeployAction;
import com.tilab.wade.tools.management.gui.ExportConfigurationAction;
import com.tilab.wade.tools.management.gui.ImportConfigurationAction;
import com.tilab.wade.tools.management.gui.LauncherAction;
import com.tilab.wade.tools.management.gui.SaveConfigurationAction;
import com.tilab.wade.tools.management.gui.ShutdownAction;
import com.tilab.wade.tools.management.gui.StartupAction;
import com.tilab.wade.tools.management.gui.StatusPanel;
import com.tilab.wade.tools.management.gui.StatusUpdater;
import com.tilab.wade.utils.DFUtils;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.ArrayList;
import jade.wrapper.AgentController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;

public class ManagementGUI
extends JFrame {
    static final long CFA_TIMEOUT = 30000L;
    private int cnt = 0;
    private StartupAction startupAction;
    private ShutdownAction shutdownAction;
    private SaveConfigurationAction saveConfigurationAction;
    private ImportConfigurationAction importConfigurationAction;
    private ExportConfigurationAction exportConfigurationAction;
    private DeployAction deployAction;
    private LauncherAction launcherAction;
    private JTextArea logArea;
    private StatusPanel statusPanel;
    JFileChooser xmlChooser;
    JFileChooser jarChooser;
    private Agent myAgent;
    private AID cfa;
    private DFAgentDescription caTemplate;
    private static Color DEFAULT_COLOR = new Color(251, 249, 249);
    private int launcherCounter = 0;

    public ManagementGUI(Agent a, AID cfa, DFAgentDescription caTemplate) {
        this.setPreferredSize(new Dimension(550, 450));
        this.setTitle("WADE");
        this.setBackground(DEFAULT_COLOR);
        this.myAgent = a;
        this.cfa = cfa;
        this.caTemplate = caTemplate;
        this.xmlChooser = new JFileChooser();
        this.xmlChooser.addChoosableFileFilter(new ExtensionFilter(".xml"));
        this.jarChooser = new JFileChooser();
        this.jarChooser.addChoosableFileFilter(new ExtensionFilter(".jar"));
        URL url = ManagementGUI.class.getClassLoader().getResource("com/tilab/wade/tools/management/gui/images/startup.png");
        ImageIcon icon = new ImageIcon(url);
        this.startupAction = new StartupAction(this, icon);
        url = ManagementGUI.class.getClassLoader().getResource("com/tilab/wade/tools/management/gui/images/shutdown.png");
        icon = new ImageIcon(url);
        this.shutdownAction = new ShutdownAction(this, icon);
        url = ManagementGUI.class.getClassLoader().getResource("com/tilab/wade/tools/management/gui/images/save.png");
        icon = new ImageIcon(url);
        this.saveConfigurationAction = new SaveConfigurationAction(this, icon);
        url = ManagementGUI.class.getClassLoader().getResource("com/tilab/wade/tools/management/gui/images/import.png");
        icon = new ImageIcon(url);
        this.importConfigurationAction = new ImportConfigurationAction(this, icon);
        url = ManagementGUI.class.getClassLoader().getResource("com/tilab/wade/tools/management/gui/images/export.png");
        icon = new ImageIcon(url);
        this.exportConfigurationAction = new ExportConfigurationAction(this, icon);
        url = ManagementGUI.class.getClassLoader().getResource("com/tilab/wade/tools/management/gui/images/deploy.png");
        icon = new ImageIcon(url);
        this.deployAction = new DeployAction(this, icon);
        url = ManagementGUI.class.getClassLoader().getResource("com/tilab/wade/tools/management/gui/images/launcher.png");
        icon = new ImageIcon(url);
        this.launcherAction = new LauncherAction(this, icon);
        JMenuBar jmb = new JMenuBar();
        JMenu menu = null;
        JMenuItem item = null;
        menu = new JMenu("Platform");
        item = menu.add(this.startupAction);
        item = menu.add(this.shutdownAction);
        jmb.add(menu);
        menu = new JMenu("Configurations");
        item = menu.add(this.saveConfigurationAction);
        item = menu.add(this.importConfigurationAction);
        item = menu.add(this.exportConfigurationAction);
        jmb.add(menu);
        menu = new JMenu("Code");
        item = menu.add(this.deployAction);
        item = menu.add(this.launcherAction);
        jmb.add(menu);
        jmb.setBackground(DEFAULT_COLOR);
        this.setJMenuBar(jmb);
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBorder(null);
        bar.setBackground(DEFAULT_COLOR);
        bar.setBorderPainted(false);
        this.enrichButton(bar.add(this.startupAction), "Startup platform");
        this.enrichButton(bar.add(this.shutdownAction), "Shutdown platform");
        bar.addSeparator();
        this.enrichButton(bar.add(this.saveConfigurationAction), "Save running configuration");
        this.enrichButton(bar.add(this.importConfigurationAction), "Import a given configuration");
        this.enrichButton(bar.add(this.exportConfigurationAction), "Export the target configuration");
        bar.addSeparator();
        this.enrichButton(bar.add(this.deployAction), "Deploy a jar file");
        this.enrichButton(bar.add(this.launcherAction), "Workflow launcher");
        this.getContentPane().setBackground(DEFAULT_COLOR);
        this.getContentPane().add((Component)bar, "North");
        this.logArea = new JTextArea();
        this.logArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.logArea);
        this.getContentPane().add((Component)sp, "Center");
        this.statusPanel = new StatusPanel();
        this.getContentPane().add((Component)this.statusPanel, "West");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ManagementGUI.this.handleExit();
            }
        });
        this.myAgent.addBehaviour((Behaviour)new StatusUpdater(this));
    }

    public void handleExit() {
        int answer = JOptionPane.showConfirmDialog(this, "Are you sure to exit?");
        if (answer == 0) {
            this.myAgent.doDelete();
        }
    }

    private void enrichButton(JButton button, String toolTipText) {
        button.setToolTipText(toolTipText);
        button.setBorderPainted(false);
        button.getAction().setEnabled(false);
        button.setBackground(DEFAULT_COLOR);
    }

    public void handleStartup() {
        try {
            ACLMessage request = this.createCfaRequest((AgentAction)new StartupPlatform());
            this.myAgent.send(request);
            MessageTemplate mt = MessageTemplate.MatchConversationId((String)request.getConversationId());
            ACLMessage reply = this.myAgent.blockingReceive(mt, 30000L);
            if (reply != null) {
                if (reply.getPerformative() == 1) {
                    this.setStatus("starting-status");
                } else if (reply.getSender().equals((Object)this.myAgent.getAMS())) {
                    this.log("Error performing Startup-platform operation [Configuration agent " + this.cfa.getName() + " does not exist]");
                } else {
                    this.log("Error performing Startup-platform operation [" + ACLMessage.getPerformative((int)reply.getPerformative()) + " reply received; content = " + reply.getContent() + "]");
                }
            } else {
                this.log("Error performing Startup-platform operation [Timeout expired]");
            }
        }
        catch (Exception e) {
            this.handleException("Startup-platform", e);
        }
    }

    public void handleShutdown() {
        try {
            ShutdownPlatform sp = new ShutdownPlatform();
            int res = JOptionPane.showConfirmDialog(this, "Soft Shutdown?");
            if (res == 2) {
                return;
            }
            if (res == 1) {
                sp.setHardTermination(true);
            }
            ACLMessage request = this.createCfaRequest((AgentAction)sp);
            this.myAgent.send(request);
            MessageTemplate mt = MessageTemplate.MatchConversationId((String)request.getConversationId());
            ACLMessage reply = this.myAgent.blockingReceive(mt, 30000L);
            if (reply != null) {
                if (reply.getPerformative() == 1) {
                    this.setStatus("shutdown-in_progress-status");
                } else if (reply.getSender().equals((Object)this.myAgent.getAMS())) {
                    this.log("Error performing Shutdown-platform operation [Configuration agent " + this.cfa.getName() + " does not exist]");
                } else {
                    this.log("Error performing Shutdown-platform operation [" + ACLMessage.getPerformative((int)reply.getPerformative()) + " reply received; content = " + reply.getContent() + "]");
                }
            } else {
                this.log("Error performing Shutdown-platform operation [Timeout expired]");
            }
        }
        catch (Exception e) {
            this.handleException("Shutdown-platform", e);
        }
    }

    public void handleSaveConfiguration() {
        try {
            ACLMessage request = this.createCfaRequest((AgentAction)new SaveConfiguration());
            ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request, (long)30000L);
            if (reply != null) {
                this.log("Configuration successfully saved");
            } else {
                this.log("Error performing Save-configuration operation [Timeout expired]");
            }
        }
        catch (Exception e) {
            this.handleException("Save configuration", e);
        }
    }

    public void handleImportConfiguration() {
        try {
            String name = this.selectConfiguration();
            if (name != null) {
                ImportConfiguration ic = new ImportConfiguration();
                ic.setName(name);
                ACLMessage message = this.createCfaRequest((AgentAction)ic);
                ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)message, (long)30000L);
                if (reply != null) {
                    this.log("Configuration " + name + " successfully imported");
                } else {
                    this.log("Error performing Import-configuration operation [Timeout expired]");
                }
            }
        }
        catch (Exception e) {
            this.handleException("Import-configuration", e);
        }
    }

    private String selectConfiguration() throws Exception {
        String configurationName = null;
        GetConfigurations gc = new GetConfigurations();
        ACLMessage message = this.createCfaRequest((AgentAction)gc);
        ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)message, (long)30000L);
        if (reply != null) {
            if (reply.getPerformative() == 7) {
                Result result = (Result)this.myAgent.getContentManager().extractContent(reply);
                Collection configurations = (Collection)result.getValue();
                Object[] confs = configurations.toArray(new String[0]);
                if (confs.length != 0) {
                    Object selectedValue = JOptionPane.showInputDialog(this, "", "Select configuration name", 1, null, confs, confs[0]);
                    configurationName = (String)selectedValue;
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, not found configuration", "", 2);
                }
            } else {
                this.log("Received failure response performing get configuration operation");
            }
        } else {
            this.log("Error performing get configuration operation [Timeout expired]");
        }
        return configurationName;
    }

    public void handleExportConfiguration(String configurationName, String configurationDesc, boolean override) {
        try {
            ExportConfiguration ec = new ExportConfiguration();
            ec.setName(configurationName);
            ec.setDescription(configurationDesc);
            ec.setOverride(override);
            ACLMessage request = this.createCfaRequest((AgentAction)ec);
            ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request, (long)30000L);
            if (reply != null) {
                this.log("Configuration successfully exported");
            } else {
                this.log("Error performing Export-configuration operation [Timeout expired]");
            }
        }
        catch (Exception e) {
            this.handleException("Export configuration", e);
        }
    }

    public void handleDeploy() throws Exception {
        block2: {
            int returnVal = this.jarChooser.showOpenDialog(this);
            if (returnVal != 0) break block2;
            final String jarFilePathName = this.jarChooser.getSelectedFile().getAbsolutePath();
            this.jarChooser.setCurrentDirectory(this.jarChooser.getSelectedFile());
            DFAgentDescription[] descs = DFUtils.searchAllByType((Agent)this.myAgent, (AgentType)TypeManager.getInstance().getType("Control Agent"), null);
            if (descs == null || descs.length == 0) {
                this.handleException("Not found Control Agents");
            } else {
                AID[] aids = DFUtils.getAIDs((DFAgentDescription[])descs);
                java.util.ArrayList<AID> l = new java.util.ArrayList<AID>(Arrays.asList(aids));
                ArrayList cas = new ArrayList(l);
                this.myAgent.addBehaviour((Behaviour)new JarDeployer(jarFilePathName, (jade.util.leap.Collection)cas){

                    public int onEnd() {
                        if (this.getUnSuccessfulControllers().size() == 0) {
                            ManagementGUI.this.log(jarFilePathName + " is been deployed corretly");
                        } else {
                            ManagementGUI.this.log(jarFilePathName + " isn't been deployed!");
                        }
                        return super.onEnd();
                    }
                });
            }
        }
    }

    public void handleMdb() {
        try {
            String name = this.myAgent.getLocalName() + "-MDBAdmin";
            AgentController ac = this.myAgent.getContainerController().createNewAgent(name, "com.tilab.wade.mdb.ProvisioningAgent", null);
            ac.start();
        }
        catch (Exception e) {
            this.handleException("Open MDB Administration", e);
        }
    }

    public void handleTracer() {
        try {
            String name = this.myAgent.getLocalName() + "-Tracer";
            AgentController ac = this.myAgent.getContainerController().createNewAgent(name, "com.tilab.wade.dispatcher.WorkflowDispatcherAgent", (Object[])new String[]{"com.tilab.wade.debugger.controller.tracer.WfController"});
            ac.start();
        }
        catch (Exception e) {
            this.handleException("Start Tracer", e);
        }
    }

    public void handleLauncher() {
        try {
            String name = this.myAgent.getLocalName() + "-Launcher" + this.launcherCounter++;
            AgentController ac = this.myAgent.getContainerController().createNewAgent(name, "com.tilab.wade.tools.launcher.LauncherAgent", null);
            ac.start();
        }
        catch (Exception e) {
            this.handleException("Start Launcher", e);
        }
    }

    synchronized void setStatus(String s) {
        if (!s.equals(this.statusPanel.getStatus())) {
            this.log("Platform status: " + s);
        }
        this.statusPanel.setStatus(s);
        this.enableAction();
    }

    synchronized void enableAction() {
        String s = this.statusPanel.getStatus();
        this.startupAction.setEnabled("down-status".equals(s));
        this.shutdownAction.setEnabled("active-status".equals(s) || "active-with-warnings".equals(s));
        this.saveConfigurationAction.setEnabled("active-status".equals(s) || "active-with-warnings".equals(s));
        this.importConfigurationAction.setEnabled("down-status".equals(s));
        this.exportConfigurationAction.setEnabled(true);
        this.deployAction.setEnabled("active-status".equals(s) || "active-with-warnings".equals(s));
        this.launcherAction.setEnabled(true);
    }

    void log(String s) {
        this.logArea.append(s + "\n");
    }

    synchronized ACLMessage createCfaRequest(AgentAction action) throws OntologyException, Codec.CodecException {
        ACLMessage request = new ACLMessage(16);
        request.setLanguage("fipa-sl");
        request.setProtocol("fipa-request");
        request.setOntology(ConfigurationOntology.getInstance().getName());
        request.addReceiver(this.cfa);
        request.setConversationId(this.myAgent.getLocalName() + "-" + System.currentTimeMillis() + "-" + this.cnt);
        ++this.cnt;
        Action actExpr = new Action();
        actExpr.setActor(this.cfa);
        actExpr.setAction((Concept)action);
        this.myAgent.getContentManager().fillContent(request, (ContentElement)actExpr);
        request.setReplyByDate(new Date(System.currentTimeMillis() + 30000L));
        return request;
    }

    private void handleException(String op, Exception e) {
        e.printStackTrace();
        String msg = "Error performing " + op + " operation [" + e + "]";
        this.log(msg);
        JOptionPane.showMessageDialog(this, msg, "WARNING", 0);
    }

    private void handleException(String op) {
        this.log(op);
        JOptionPane.showMessageDialog(this, op, "WARNING", 0);
    }

    private class ExtensionFilter
    extends FileFilter {
        private String extension;

        private ExtensionFilter(String ext) {
            this.extension = ext;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(this.extension);
        }

        public String getDescription() {
            return this.extension;
        }
    }
}

