/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.tools.management.gui;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class StatusPanel
extends JPanel {
    private String status;
    private ButtonGroup leds;
    private JRadioButton downLed;
    private JRadioButton activeLed;
    private JRadioButton startingLed;
    private JRadioButton shutdownInProgressLed;
    private JRadioButton activeWithWarningsLed;
    private JRadioButton errorLed;
    private Icon ledOff = new ImageIcon(this.getClass().getResource("images/disabled.png"));
    private Icon startupIcon = new ImageIcon(this.getClass().getResource("images/activePlatform.png"));
    private Icon notActiveIcon = new ImageIcon(this.getClass().getResource("images/notActivePlatform.png"));
    private Icon warningIcon = new ImageIcon(this.getClass().getResource("images/platformWarnings.png"));
    private Icon inProgressIcon = new ImageIcon(this.getClass().getResource("images/platformInProgress.png"));
    private Font myFont = new Font("Monospaced", 1, 10);
    private Map ledMap = new HashMap();

    public StatusPanel() {
        this.leds = new ButtonGroup();
        this.build();
    }

    public void build() {
        Border line = BorderFactory.createEtchedBorder();
        JPanel ledPanel = new JPanel();
        ledPanel.setLayout(new BoxLayout(ledPanel, 1));
        ledPanel.setAlignmentX(0.5f);
        ledPanel.setBorder(BorderFactory.createTitledBorder(line, "Current State", 2, 2, new Font("Dialog", 1, 10)));
        this.activeLed = new JRadioButton("Active", this.startupIcon);
        this.activeLed.setFont(this.myFont);
        this.activeLed.setAlignmentX(0.0f);
        this.activeLed.setDisabledSelectedIcon(this.startupIcon);
        this.activeLed.setDisabledIcon(this.ledOff);
        this.activeLed.setEnabled(false);
        this.leds.add(this.activeLed);
        this.ledMap.put("active-status", this.activeLed);
        ledPanel.add(this.activeLed);
        this.activeWithWarningsLed = new JRadioButton("Active with warnings", this.warningIcon);
        this.activeWithWarningsLed.setFont(this.myFont);
        this.activeWithWarningsLed.setAlignmentX(0.0f);
        this.activeWithWarningsLed.setDisabledSelectedIcon(this.warningIcon);
        this.activeWithWarningsLed.setDisabledIcon(this.ledOff);
        this.activeWithWarningsLed.setEnabled(false);
        this.leds.add(this.activeWithWarningsLed);
        this.ledMap.put("active-with-warnings", this.activeWithWarningsLed);
        ledPanel.add(this.activeWithWarningsLed);
        this.startingLed = new JRadioButton("Starting", this.inProgressIcon);
        this.startingLed.setFont(this.myFont);
        this.startingLed.setAlignmentX(0.0f);
        this.startingLed.setDisabledSelectedIcon(this.inProgressIcon);
        this.startingLed.setDisabledIcon(this.ledOff);
        this.startingLed.setEnabled(false);
        this.leds.add(this.startingLed);
        this.ledMap.put("starting-status", this.startingLed);
        ledPanel.add(this.startingLed);
        this.shutdownInProgressLed = new JRadioButton("Shutdown in progress", this.inProgressIcon);
        this.shutdownInProgressLed.setFont(this.myFont);
        this.shutdownInProgressLed.setAlignmentX(0.0f);
        this.shutdownInProgressLed.setDisabledSelectedIcon(this.inProgressIcon);
        this.shutdownInProgressLed.setDisabledIcon(this.ledOff);
        this.shutdownInProgressLed.setEnabled(false);
        this.leds.add(this.shutdownInProgressLed);
        this.ledMap.put("shutdown-in_progress-status", this.shutdownInProgressLed);
        ledPanel.add(this.shutdownInProgressLed);
        this.errorLed = new JRadioButton("Error", this.notActiveIcon);
        this.errorLed.setFont(this.myFont);
        this.errorLed.setAlignmentX(0.0f);
        this.errorLed.setDisabledSelectedIcon(this.notActiveIcon);
        this.errorLed.setDisabledIcon(this.ledOff);
        this.errorLed.setEnabled(false);
        this.leds.add(this.errorLed);
        this.ledMap.put("error-status", this.errorLed);
        ledPanel.add(this.errorLed);
        this.downLed = new JRadioButton("Down", this.notActiveIcon);
        this.downLed.setFont(this.myFont);
        this.downLed.setAlignmentX(0.0f);
        this.downLed.setDisabledSelectedIcon(this.notActiveIcon);
        this.downLed.setDisabledIcon(this.ledOff);
        this.downLed.setEnabled(false);
        this.leds.add(this.downLed);
        this.ledMap.put("down-status", this.downLed);
        ledPanel.add(this.downLed);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(15));
        this.add(ledPanel);
    }

    void setStatus(String status) {
        JRadioButton led = (JRadioButton)this.ledMap.get(status);
        if (led != null) {
            this.status = status;
            led.setSelected(true);
        }
    }

    String getStatus() {
        return this.status;
    }
}

