/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.tools.management.gui;

import com.tilab.wade.cfa.ontology.GetPlatformStatus;
import com.tilab.wade.tools.management.gui.ManagementGUI;
import jade.content.AgentAction;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ServiceException;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.messaging.TopicManagementHelper;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

class StatusUpdater
extends CyclicBehaviour {
    private ManagementGUI gui;
    private MessageTemplate template;

    public StatusUpdater(ManagementGUI gui) {
        super(null);
        this.gui = gui;
    }

    public void onStart() {
        this.retrieveStatus();
        try {
            TopicManagementHelper topicHelper = (TopicManagementHelper)this.myAgent.getHelper("jade.core.messaging.TopicManagement");
            AID topic = topicHelper.createTopic("Platform-Life-Cycle");
            topicHelper.register(topic);
            this.template = MessageTemplate.MatchTopic((AID)topic);
        }
        catch (ServiceException se) {
            se.printStackTrace();
            this.gui.log("Error registering to platform life-cycle topic. " + (Object)((Object)se));
        }
    }

    public void action() {
        ACLMessage msg = this.myAgent.receive(this.template);
        if (msg != null) {
            if (msg.getPerformative() == 7) {
                try {
                    Result result = (Result)this.myAgent.getContentManager().extractContent(msg);
                    this.gui.setStatus((String)result.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.gui.log("Error decoding platform life-cycle notification message. " + e);
                }
            }
        } else {
            this.block();
        }
    }

    private void retrieveStatus() {
        try {
            ACLMessage request = this.gui.createCfaRequest((AgentAction)new GetPlatformStatus());
            ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request, (long)30000L);
            if (reply != null) {
                Result result = (Result)this.myAgent.getContentManager().extractContent(reply);
                this.gui.setStatus((String)result.getValue());
            } else {
                this.gui.log("Timeout expired while retrieving platform status from Configuration Agent");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.gui.log("Error retrieving platform status from Configuration Agent. " + e);
        }
    }
}

