/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils;

import com.tilab.wade.ca.ontology.ControlOntology;
import com.tilab.wade.ca.ontology.CreateAgent;
import com.tilab.wade.ca.ontology.KillAgent;
import com.tilab.wade.cfa.beans.AgentArgumentInfo;
import com.tilab.wade.cfa.beans.AgentBaseInfo;
import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.commons.TypeManager;
import com.tilab.wade.utils.AMSUtils;
import com.tilab.wade.utils.DFUtils;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SimpleSLTokenizer;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.util.Collection;
import java.util.HashMap;

public class CAUtils {
    protected static Logger myLogger = Logger.getMyLogger((String)CAUtils.class.getName());
    private static final long DEFAULT_CA_REQUEST_TIMEOUT = 30000L;

    public static AID getCAOnLocation(Agent a, String location) throws FIPAException {
        return DFUtils.getAID((DFAgentDescription)DFUtils.searchAnyByType((Agent)a, (String)"Control Agent", (Property)new Property("AGENT-LOCATION", (Object)location)));
    }

    public static ACLMessage createAgent(Agent agent, AgentInfo agentInfo, AID creator) throws Codec.CodecException, OntologyException, FIPAException {
        ACLMessage messageCreateAgent = CAUtils.prepareCreateAgentRequest(agent, agentInfo, creator);
        return FIPAService.doFipaRequestClient((Agent)agent, (ACLMessage)messageCreateAgent, (long)30000L);
    }

    public static ACLMessage createAgent(Agent agent, AgentInfo agentInfo, String containerName) throws Codec.CodecException, OntologyException, FIPAException {
        AID aidCA = CAUtils.getCAOnLocation(agent, containerName);
        if (aidCA == null) {
            throw new FIPAException("Cannot find control agent on container " + containerName);
        }
        return CAUtils.createAgent(agent, agentInfo, aidCA);
    }

    public static ACLMessage prepareCreateAgentRequest(Agent agent, AgentInfo agentInfo, AID aidCA) throws Codec.CodecException, OntologyException {
        Collection arguments = agentInfo.getParameters();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (arguments != null) {
            for (AgentArgumentInfo currentArgument : arguments) {
                properties.put(currentArgument.getKey(), currentArgument.getValue());
            }
        }
        if (agentInfo.getType() != null) {
            properties.put("AGENT-TYPE", agentInfo.getType());
        }
        if (agentInfo.getOwner() != null) {
            properties.put("AGENT-OWNER", agentInfo.getOwner());
        }
        Object[] argument = new Object[]{properties};
        CreateAgent createAgent = new CreateAgent();
        createAgent.setName(agentInfo.getName());
        String className = TypeManager.getSafeClassName((AgentBaseInfo)agentInfo);
        createAgent.setClassName(className);
        createAgent.setArguments(argument);
        ACLMessage message = AMSUtils.createRequestMessage((Agent)agent, (AID)aidCA, (String)ControlOntology.getInstance().getName());
        Action createAgentAction = new Action(aidCA, (Concept)createAgent);
        agent.getContentManager().fillContent(message, (ContentElement)createAgentAction);
        return message;
    }

    public static ACLMessage killAgent(Agent agent, AID target) throws Codec.CodecException, OntologyException, FIPAException {
        DFAgentDescription dfd = DFUtils.searchByName((Agent)agent, (String)target.getLocalName());
        if (dfd != null) {
            ServiceDescription sd = DFUtils.getServiceDescription((DFAgentDescription)dfd);
            String location = (String)DFUtils.getPropertyValue((ServiceDescription)sd, (String)"AGENT-LOCATION");
            if (location != null) {
                AID ca = CAUtils.getCAOnLocation(agent, location);
                return CAUtils.killAgent(agent, target, ca);
            }
            throw new FIPAException("Missing location for target agent " + target.getName());
        }
        throw new FIPAException("Target agent " + target.getName() + " DF description not found");
    }

    public static ACLMessage killAgent(Agent agent, AID target, AID ca) throws Codec.CodecException, OntologyException, FIPAException {
        ACLMessage request = CAUtils.preparekillAgentRequest(agent, target, ca);
        return FIPAService.doFipaRequestClient((Agent)agent, (ACLMessage)request, (long)30000L);
    }

    public static ACLMessage preparekillAgentRequest(Agent agent, AID target, AID actor) throws Codec.CodecException, OntologyException {
        ACLMessage message = AMSUtils.createRequestMessage((Agent)agent, (AID)actor, (String)ControlOntology.getInstance().getName());
        KillAgent ka = new KillAgent();
        ka.setAgent(target);
        Action killAgentAction = new Action(actor, (Concept)ka);
        agent.getContentManager().fillContent(message, (ContentElement)killAgentAction);
        return message;
    }

    public static boolean isAuxiliary(String containerName) {
        return containerName.startsWith("BE-") || containerName.startsWith("GW-") || containerName.startsWith("WSEG") || containerName.startsWith("WSIG");
    }

    public static AID getDeadAgent(ACLMessage failure) throws FIPAException {
        if (failure.getPerformative() != 6) {
            throw new FIPAException("Invalid FAILURE message");
        }
        try {
            String content = failure.getContent();
            int start = content.indexOf("Agent-dead");
            start = content.indexOf("agent-identifier", start);
            SimpleSLTokenizer parser = new SimpleSLTokenizer(content.substring(start));
            return FIPAService.parseAID((SimpleSLTokenizer)parser);
        }
        catch (Exception e) {
            throw new FIPAException("Invalid content. " + e);
        }
    }
}

