/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils.cli;

import com.tilab.wade.commons.ontology.Attribute;
import com.tilab.wade.commons.ontology.GetAgentAttributes;
import com.tilab.wade.commons.ontology.WadeManagementOntology;
import com.tilab.wade.utils.behaviours.SimpleFipaRequestInitiator;
import jade.cli.CLICommand;
import jade.cli.CLIManager;
import jade.cli.Option;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.lang.acl.ACLMessage;
import jade.util.leap.List;
import java.util.Date;
import java.util.Properties;

public class GetAttributes
extends CLICommand {
    @Option(value="<name>", description="The name of the agent whose attributes must be retrieved")
    public static final String AGENT_OPTION = "agent";

    public static void main(String[] args) {
        CLIManager.execute((CLICommand)new GetAttributes(), (String[])args);
    }

    public Behaviour getBehaviour(Properties pp) throws IllegalArgumentException {
        final String agentName = CLIManager.getMandatoryOption((String)AGENT_OPTION, (Properties)pp);
        return new SimpleFipaRequestInitiator(){

            public void onStart() {
                this.myAgent.getContentManager().registerLanguage((Codec)new SLCodec(true));
                this.myAgent.getContentManager().registerOntology(WadeManagementOntology.getInstance());
                super.onStart();
            }

            protected ACLMessage prepareRequest(ACLMessage request) {
                GetAgentAttributes gaa = new GetAgentAttributes();
                gaa.setAgentName(agentName);
                AID target = new AID(agentName, false);
                Action actExpr = new Action();
                actExpr.setActor(target);
                actExpr.setAction((Concept)gaa);
                request = new ACLMessage(16);
                request.addReceiver(target);
                request.setProtocol("fipa-request");
                request.setLanguage("fipa-sl");
                request.setOntology(WadeManagementOntology.getInstance().getName());
                request.setReplyByDate(new Date(System.currentTimeMillis() + 20000L));
                try {
                    this.myAgent.getContentManager().fillContent(request, (ContentElement)actExpr);
                    return request;
                }
                catch (Exception e) {
                    GetAttributes.this.out.println(e.getMessage());
                    return null;
                }
            }

            public void handleInform(ACLMessage inform) {
                try {
                    Result result = (Result)this.myAgent.getContentManager().extractContent(inform);
                    List attributes = (List)result.getValue();
                    for (Attribute attr : attributes) {
                        GetAttributes.this.out.println(attr.getName() + " = " + attr.getValue());
                    }
                }
                catch (Exception e) {
                    GetAttributes.this.out.println(e.getMessage());
                }
            }

            public void handleError(ACLMessage msg) {
                GetAttributes.this.out.println("Unexpected " + ACLMessage.getPerformative((int)msg.getPerformative()) + " retrieving agent attributes. " + msg.getContent());
            }

            public void handleTimeout() {
                GetAttributes.this.out.println("Timeout");
            }
        };
    }
}

