/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils.condition;

import com.tilab.wade.utils.condition.FilterException;
import com.tilab.wade.utils.condition.FilterMatcher;
import com.tilab.wade.utils.condition.Getter;
import com.tilab.wade.utils.condition.GetterFactory;
import com.tilab.wade.utils.condition.GetterFactoryException;
import com.tilab.wade.utils.condition.IntegerMatcher;
import com.tilab.wade.utils.condition.MatcherException;
import com.tilab.wade.utils.condition.StringMatcher;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Condition {
    public static final String ELEMENT_SEPARATOR = ";";
    public static final int ELEMENT_SEPARATOR_LENGTH = ";".length();
    public static final String ESCAPED_ELEMENT_SEPARATOR = "\\;";
    public static final int ESCAPED_ELEMENT_SEPARATOR_LENGTH = "\\;".length();
    private static final String FIELDNAME = "[A-Za-z_][A-Za-z0-9_.-]*";
    private static final String OPEQUALITY = "[=!]=";
    private static final String OPINEQUALITY = ">={0,1}|<={0,1}";
    private static final String OPREGEXPMATCH = "/|%";
    private static final String OPGENERIC = "[=!]=|>={0,1}|<={0,1}|/|%";
    private static final String VALGENERIC = ".*";
    private static final Pattern ELEMENT_SEPARATOR_PATTERN = Pattern.compile("(?<!\\\\);");
    private static final Pattern genericFieldFilterPattern = Pattern.compile("^([A-Za-z_][A-Za-z0-9_.-]*)\\s*([=!]=|>={0,1}|<={0,1}|/|%)\\s*(.*)$");
    private List<FilterMatcher> matchers = new LinkedList<FilterMatcher>();
    private String filterString;
    private GetterFactory getterFactory = null;

    public static String escapeValue(String value) {
        StringBuffer sb = new StringBuffer();
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        int j = 0;
        int i = value.indexOf(ELEMENT_SEPARATOR);
        while (i >= 0) {
            String s = value.substring(j, i);
            sb.append(s);
            sb.append(ESCAPED_ELEMENT_SEPARATOR);
            j = i + ELEMENT_SEPARATOR_LENGTH;
            i = value.indexOf(ESCAPED_ELEMENT_SEPARATOR, j);
        }
        sb.append(value.substring(j));
        return sb.toString();
    }

    protected static String unescapeValue(String value) {
        StringBuffer sb = new StringBuffer();
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        int j = 0;
        int i = value.indexOf(ESCAPED_ELEMENT_SEPARATOR);
        while (i >= 0) {
            String s = value.substring(j, i);
            sb.append(s);
            sb.append(ELEMENT_SEPARATOR);
            j = i + ESCAPED_ELEMENT_SEPARATOR_LENGTH;
            i = value.indexOf(ESCAPED_ELEMENT_SEPARATOR, j);
        }
        sb.append(value.substring(j));
        return sb.toString();
    }

    private static FilterMatcher.Type getType(String op) {
        if (op.equals("==")) {
            return FilterMatcher.Type.EQ;
        }
        if (op.equals("!=")) {
            return FilterMatcher.Type.NE;
        }
        if (op.equals(">")) {
            return FilterMatcher.Type.GT;
        }
        if (op.equals(">=")) {
            return FilterMatcher.Type.GE;
        }
        if (op.equals("<")) {
            return FilterMatcher.Type.LT;
        }
        if (op.equals("<=")) {
            return FilterMatcher.Type.LE;
        }
        if (op.equals("/")) {
            return FilterMatcher.Type.REGEXMATCH;
        }
        if (op.equals("%")) {
            return FilterMatcher.Type.REGEXMATCHALL;
        }
        return null;
    }

    public Condition(GetterFactory getterFactory) throws FilterException {
        this(getterFactory, "");
    }

    public Condition(GetterFactory getterFactory, String filterDescription) throws FilterException {
        this.getterFactory = getterFactory;
        this.set(filterDescription);
    }

    public void clear() {
        this.matchers.clear();
        this.filterString = "";
    }

    public void append(String filterDescription) throws FilterException {
        LinkedList<FilterMatcher> matchersBackup = new LinkedList<FilterMatcher>(this.matchers);
        try {
            String[] matcherDescriptions = ELEMENT_SEPARATOR_PATTERN.split(filterDescription);
            for (int i = 0; i < matcherDescriptions.length; ++i) {
                this.addFilterMatcher(matcherDescriptions[i]);
            }
        }
        catch (FilterException fe) {
            this.matchers = matchersBackup;
            throw fe;
        }
        catch (Exception e) {
            this.matchers = matchersBackup;
            throw new FilterException(e);
        }
    }

    public void set(String filterDescription) throws FilterException {
        this.clear();
        this.append(filterDescription);
    }

    protected FilterMatcher buildMatcher(String s) throws FilterException {
        Getter getter;
        FilterMatcher result = null;
        Matcher m = genericFieldFilterPattern.matcher(s = s.trim());
        if (!m.matches()) {
            throw new FilterException("syntax error in expression \"" + s + "\"");
        }
        String field = m.group(1);
        FilterMatcher.Type type = Condition.getType(m.group(2));
        String value = Condition.unescapeValue(m.group(3));
        try {
            getter = this.getterFactory.createGetter(field);
        }
        catch (GetterFactoryException gfe) {
            throw new FilterException(gfe);
        }
        try {
            if (getter.getValueClass().equals(String.class)) {
                result = new StringMatcher(type, getter, value);
            } else if (getter.getValueClass().equals(Integer.class)) {
                result = new IntegerMatcher(type, getter, value);
            }
        }
        catch (MatcherException me) {
            throw new FilterException(me);
        }
        if (result == null) {
            throw new FilterException("field " + field + " has an unsupported getter");
        }
        return result;
    }

    protected void addFilterMatcher(FilterMatcher matcher) {
        this.matchers.add(matcher);
    }

    public void addFilterMatcher(String s) throws FilterException {
        LinkedList<FilterMatcher> matchersBackup = new LinkedList<FilterMatcher>(this.matchers);
        try {
            this.addFilterMatcher(this.buildMatcher(s));
            if (this.filterString.length() > 0) {
                this.filterString = this.filterString + ELEMENT_SEPARATOR;
            }
            this.filterString = this.filterString + s;
        }
        catch (FilterException fe) {
            this.matchers = matchersBackup;
            throw fe;
        }
        catch (Exception e) {
            this.matchers = matchersBackup;
            throw new FilterException(e);
        }
    }

    public boolean match(Object obj) throws MatcherException {
        for (FilterMatcher matcher : this.matchers) {
            if (matcher.matches(obj)) continue;
            return false;
        }
        return true;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public String toString() {
        return "Condition { \"" + this.filterString + "\" }";
    }
}

