/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils.condition;

import com.tilab.wade.utils.condition.FilterMatcher;
import com.tilab.wade.utils.condition.Getter;
import com.tilab.wade.utils.condition.InvalidMatchTypeException;
import com.tilab.wade.utils.condition.MatcherException;

public class IntegerMatcher
implements FilterMatcher {
    protected Getter integerGetter = null;
    protected Integer n;
    protected FilterMatcher.Type type;

    public IntegerMatcher(FilterMatcher.Type type, Getter integerGetter, Integer n) throws MatcherException {
        try {
            this.integerGetter = integerGetter;
            this.n = n;
        }
        catch (Exception e) {
            throw new MatcherException(e);
        }
        this.setType(type);
    }

    public IntegerMatcher(Getter integerGetter, Integer n) throws MatcherException {
        this(FilterMatcher.Type.EQ, integerGetter, n);
    }

    public IntegerMatcher(FilterMatcher.Type type, Getter integerGetter, String s) throws MatcherException {
        try {
            this.integerGetter = integerGetter;
            this.n = new Integer(Integer.parseInt(s));
        }
        catch (Exception e) {
            throw new MatcherException(e);
        }
        this.setType(type);
    }

    public IntegerMatcher(Getter integerGetter, String s) throws MatcherException {
        this(FilterMatcher.Type.EQ, integerGetter, s);
    }

    public void setMatchExpr(Integer n) {
        this.n = n;
    }

    public void setType(FilterMatcher.Type type) throws InvalidMatchTypeException {
        if (this.type != type) {
            if (type == FilterMatcher.Type.REGEXMATCH || type == FilterMatcher.Type.REGEXMATCHALL) {
                throw new InvalidMatchTypeException("invalid type " + (Object)((Object)type) + " for IntegerMatcher");
            }
            this.type = type;
        }
    }

    public boolean matches(Object obj) {
        boolean result = false;
        int val1 = this.n;
        int val2 = (Integer)this.integerGetter.getValue(obj);
        switch (this.type) {
            case EQ: {
                result = val2 == val1;
                break;
            }
            case NE: {
                result = val2 != val1;
                break;
            }
            case GT: {
                result = val2 > val1;
                break;
            }
            case LT: {
                result = val2 < val1;
                break;
            }
            case GE: {
                result = val2 >= val1;
                break;
            }
            case LE: {
                result = val2 <= val1;
            }
        }
        return result;
    }
}

