/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils.condition;

import com.tilab.wade.utils.condition.FilterMatcher;
import com.tilab.wade.utils.condition.Getter;
import com.tilab.wade.utils.condition.MatcherException;
import java.util.regex.Pattern;

public class StringMatcher
implements FilterMatcher {
    private FilterMatcher.Type type;
    private String matchExpr;
    private Getter stringGetter = null;
    private Pattern pattern;
    private static String WILDCARD = "*";

    public StringMatcher(FilterMatcher.Type type, Getter stringGetter, String matchExpr) throws MatcherException {
        try {
            this.type = type;
            this.stringGetter = stringGetter;
            this.setMatchExpr(matchExpr);
        }
        catch (Exception e) {
            throw new MatcherException(e);
        }
    }

    public void setMatchExpr(String matchExpr) {
        if (this.matchExpr == null && matchExpr != null || this.matchExpr != null && !this.matchExpr.equals(matchExpr)) {
            this.matchExpr = matchExpr;
            if (this.type == FilterMatcher.Type.REGEXMATCH || this.type == FilterMatcher.Type.REGEXMATCHALL) {
                this.pattern = Pattern.compile(matchExpr);
            }
        }
    }

    public void setType(FilterMatcher.Type type) {
        if (this.type != type) {
            this.type = type;
            this.matchExpr = null;
            this.pattern = null;
        }
    }

    public boolean matches(Object obj) throws MatcherException {
        if (this.matchExpr == null) {
            throw new MatcherException("match expression not set");
        }
        String value = (String)this.stringGetter.getValue(obj);
        if (value == null) {
            return false;
        }
        switch (this.type) {
            case EQ: {
                return this.matchExpr.equals(WILDCARD) || value.equals(this.matchExpr);
            }
            case NE: {
                return !value.equals(this.matchExpr);
            }
            case GT: {
                return value.compareTo(this.matchExpr) > 0;
            }
            case GE: {
                return value.compareTo(this.matchExpr) >= 0;
            }
            case LT: {
                return value.compareTo(this.matchExpr) < 0;
            }
            case LE: {
                return value.compareTo(this.matchExpr) <= 0;
            }
            case REGEXMATCH: {
                return this.pattern.matcher(value).find();
            }
            case REGEXMATCHALL: {
                return this.pattern.matcher(value).matches();
            }
        }
        throw new MatcherException("unassigned type");
    }
}

