/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils.logging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class RollingFileHandler
extends StreamHandler {
    private LogManager manager;
    private long nextCycle;
    private String baseLocation;
    private MeteredStream meter;
    private int fileIndex;
    private String location;
    private String namePrefix;
    private String dateFormat;
    private String nameSuffix;
    private int limit;
    private String cycle;

    public RollingFileHandler() {
        this.manager = LogManager.getLogManager();
        this.configure(this.getStringProperty("location"), this.getStringProperty("namePrefix"), this.getStringProperty("dateFormat"), this.getStringProperty("nameSuffix"), this.getIntProperty("limit"), this.getStringProperty("cycle"), this.getLevelProperty("level"), this.getFormatterProperty("formatter"), this.getStringProperty("encoding"), null);
        this.openFile();
    }

    public RollingFileHandler(String location, String namePrefix, String dateFormat, String nameSuffix, int limit, String cycle, Level level, Formatter formatter, String encoding, String baseLocation) {
        this.configure(location, namePrefix, dateFormat, nameSuffix, limit, cycle, level, formatter, encoding, baseLocation);
        this.openFile();
    }

    private void configure(String location, String namePrefix, String dateFormat, String nameSuffix, int limit, String cycle, Level level, Formatter formatter, String encoding, String baseLocation) {
        this.fileIndex = 0;
        this.baseLocation = baseLocation;
        if (location == null) {
            location = ".";
        }
        this.location = location;
        if (namePrefix == null) {
            namePrefix = "";
        }
        this.namePrefix = namePrefix;
        if (dateFormat == null) {
            dateFormat = "yyyy_MM_dd";
        }
        this.dateFormat = dateFormat;
        if (nameSuffix == null) {
            nameSuffix = ".log";
        }
        this.nameSuffix = nameSuffix;
        if (limit < 0) {
            limit = 0;
        }
        this.limit = limit;
        if (!(cycle != null && (cycle.equalsIgnoreCase("none") || cycle.equalsIgnoreCase("day") || cycle.equalsIgnoreCase("week") || cycle.equalsIgnoreCase("month") || cycle.equalsIgnoreCase("year")))) {
            cycle = "day";
        }
        this.cycle = cycle;
        if (level == null) {
            level = Level.ALL;
        }
        this.setLevel(level);
        if (formatter == null) {
            formatter = new SimpleFormatter();
        }
        this.setFormatter(formatter);
        try {
            this.setEncoding(encoding);
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    private synchronized void openFile() {
        Date currentDate = new Date();
        Date nextDate = null;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(currentDate);
        if (this.cycle.equalsIgnoreCase("none")) {
            nextDate = null;
        } else if (this.cycle.equalsIgnoreCase("week")) {
            gc.add(3, 1);
            nextDate = gc.getTime();
        } else if (this.cycle.equalsIgnoreCase("month")) {
            gc.add(2, 1);
            int month = gc.get(2);
            int year = gc.get(1);
            GregorianCalendar gc2 = new GregorianCalendar(year, month, 1);
            nextDate = gc2.getTime();
        } else if (this.cycle.equalsIgnoreCase("year")) {
            gc.add(1, 1);
            int year = gc.get(1);
            GregorianCalendar gc2 = new GregorianCalendar(year, 0, 1);
            nextDate = gc2.getTime();
        } else {
            gc.add(5, 1);
            nextDate = gc.getTime();
        }
        if (nextDate != null) {
            gc = new GregorianCalendar();
            gc.setTime(nextDate);
            gc.set(10, 0);
            gc.set(11, 0);
            gc.set(12, 0);
            gc.set(13, 0);
            gc.set(14, 0);
            nextDate = gc.getTime();
            this.nextCycle = nextDate.getTime();
        } else {
            this.nextCycle = 0L;
        }
        this.setOutputStream(this.getFile(currentDate));
    }

    private String getFileName(Date date) {
        String dateString = this.dateFormat;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat, Locale.getDefault());
            dateString = sdf.format(date);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        String fileName = this.namePrefix;
        if (this.nextCycle > 0L) {
            fileName = fileName + "-" + dateString;
        }
        if (this.limit > 0) {
            fileName = fileName + "-" + this.fileIndex;
        }
        fileName = fileName + this.nameSuffix;
        return fileName;
    }

    private File getFile(Date date) {
        File file;
        boolean found;
        do {
            if (!(file = new File(this.location, this.getFileName(date))).isAbsolute() && this.baseLocation != null) {
                file = new File(this.baseLocation, file.getPath());
            }
            if (this.limit > 0 && file.exists() && file.length() >= (long)this.limit) {
                ++this.fileIndex;
                found = false;
                continue;
            }
            found = true;
        } while (!found);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
        }
        return file;
    }

    private void setOutputStream(File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file, true);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            this.meter = new MeteredStream(bos, file.length());
            this.setOutputStream(this.meter);
        }
        catch (Exception fnfe) {
            this.reportError(null, fnfe, 4);
            fnfe.printStackTrace(System.err);
            this.setOutputStream(System.out);
        }
    }

    public synchronized void publish(LogRecord record) {
        boolean cycleExceeded;
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
        boolean limitExceeded = this.limit > 0 && this.meter.written >= (long)this.limit;
        boolean bl = cycleExceeded = this.nextCycle > 0L && System.currentTimeMillis() >= this.nextCycle;
        if (limitExceeded || cycleExceeded) {
            if (cycleExceeded) {
                this.fileIndex = 0;
            }
            this.rotate();
        }
    }

    private final synchronized void rotate() {
        Level oldLevel = this.getLevel();
        this.setLevel(Level.OFF);
        super.close();
        this.openFile();
        this.setLevel(oldLevel);
    }

    private String getProperty(String name) {
        return this.manager.getProperty(this.getClass().getName() + "." + name);
    }

    private String getStringProperty(String name) {
        String val = this.getProperty(name);
        if (val == null) {
            return null;
        }
        return val.trim();
    }

    private int getIntProperty(String name) {
        String val = this.getProperty(name);
        if (val == null) {
            return 0;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private Level getLevelProperty(String name) {
        String val = this.getProperty(name);
        if (val == null) {
            return null;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Formatter getFormatterProperty(String name) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        long written;

        MeteredStream(OutputStream out, long written) {
            this.out = out;
            this.written = written;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += (long)buff.length;
        }

        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += (long)len;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

