/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class WadeFormatter
extends Formatter {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String lineSeparator = System.getProperty("line.separator");
    private String sourceName;
    private boolean launchedByBootDaemon = "true".equals(System.getProperty("TSDaemon"));
    private boolean shortLine;

    public WadeFormatter() {
        this(false, null);
    }

    public WadeFormatter(boolean shortLine) {
        this(shortLine, null);
    }

    private WadeFormatter(boolean shortLine, String sourceName) {
        this.shortLine = shortLine;
        this.sourceName = sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        if (!this.launchedByBootDaemon || this.shortLine) {
            Date date = new Date(record.getMillis());
            SimpleDateFormat simpleDateFormat = formatter;
            synchronized (simpleDateFormat) {
                sb.append(formatter.format(date));
            }
            sb.append(' ');
        }
        if (!this.shortLine) {
            if (!this.launchedByBootDaemon && this.sourceName != null) {
                sb.append(this.sourceName);
                sb.append(">>");
                sb.append(' ');
            }
            sb.append(record.getLevel());
            sb.append(": ");
        }
        String message = this.formatMessage(record);
        sb.append(message);
        if (!this.shortLine) {
            sb.append(" [");
            if (record.getSourceClassName() != null) {
                sb.append(record.getSourceClassName());
            } else {
                sb.append('#');
                sb.append(record.getLoggerName());
            }
            if (record.getSourceMethodName() != null) {
                sb.append(' ');
                sb.append(record.getSourceMethodName());
                sb.append("()");
            }
            sb.append(']');
        }
        sb.append(lineSeparator);
        if (!this.shortLine && record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static void manage(Logger logger, String sourceName) {
        Handler[] handlers;
        for (Handler h : handlers = logger.getHandlers()) {
            if (!(h.getFormatter() instanceof WadeFormatter)) continue;
            WadeFormatter plf = (WadeFormatter)h.getFormatter();
            plf.setSourceName(sourceName);
        }
    }
}

