/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils.logging;

import com.tilab.wade.utils.logging.RollingFileHandler;
import com.tilab.wade.utils.logging.WadeFormatter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class WadeHandler
extends Handler {
    private LogManager logManager;
    private Properties fileProperties;
    private String projectHome;
    private Level level;
    private String location;
    private String namePrefix;
    private String dateFormat;
    private String nameSuffix;
    private int limit;
    private String cycle = "day";

    public WadeHandler() {
        this.logManager = LogManager.getLogManager();
        this.configure(this.castToString(this.getLogManagerProperty("location")), this.castToString(this.getLogManagerProperty("namePrefix")), this.castToString(this.getLogManagerProperty("dateFormat")), this.castToString(this.getLogManagerProperty("nameSuffix")), this.castToInt(this.getLogManagerProperty("limit")), this.castToString(this.getLogManagerProperty("cycle")), this.castToLevel(this.getLogManagerProperty("level")));
    }

    public WadeHandler(String projectHome, Properties props) {
        this.fileProperties = props;
        this.projectHome = projectHome;
        this.configure(this.castToString(this.getFileProperty("location")), this.castToString(this.getFileProperty("namePrefix")), this.castToString(this.getFileProperty("dateFormat")), this.castToString(this.getFileProperty("nameSuffix")), this.castToInt(this.getFileProperty("limit")), this.castToString(this.getFileProperty("cycle")), this.castToLevel(this.getFileProperty("level")));
    }

    public WadeHandler(String location, String namePrefix, String dateFormat, String nameSuffix, int limit, String cycle, Level level) {
        this.configure(location, namePrefix, dateFormat, nameSuffix, limit, cycle, level);
    }

    public void publish(LogRecord record) {
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    public Level getLevel() {
        return this.level;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getCycle() {
        return this.cycle;
    }

    public ConsoleHandler createConsoleHandler() {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(this.level);
        consoleHandler.setFormatter(new WadeFormatter());
        return consoleHandler;
    }

    public RollingFileHandler createRollingFileHandler(String name) {
        String localNamePrefix = "";
        if (this.namePrefix != null) {
            localNamePrefix = localNamePrefix + this.namePrefix;
        }
        if (name != null) {
            localNamePrefix = localNamePrefix + name;
        }
        return new RollingFileHandler(this.location, localNamePrefix, this.dateFormat, this.nameSuffix, this.limit, this.cycle, this.level, new WadeFormatter(), null, this.projectHome);
    }

    private void configure(String location, String namePrefix, String dateFormat, String nameSuffix, int limit, String cycle, Level level) {
        if (location == null) {
            location = ".";
        }
        this.location = location;
        if (namePrefix == null) {
            namePrefix = "";
        }
        this.namePrefix = namePrefix;
        if (dateFormat == null) {
            dateFormat = "yyyy_MM_dd";
        }
        this.dateFormat = dateFormat;
        if (nameSuffix == null) {
            nameSuffix = ".log";
        }
        this.nameSuffix = nameSuffix;
        if (limit < 0) {
            limit = 0;
        }
        this.limit = limit;
        if (cycle == null || !cycle.equalsIgnoreCase("day") && !cycle.equalsIgnoreCase("week") && !cycle.equalsIgnoreCase("month") && !cycle.equalsIgnoreCase("year")) {
            cycle = "day";
        }
        this.cycle = cycle;
        if (level == null) {
            level = Level.ALL;
        }
        this.level = level;
    }

    private String getLogManagerProperty(String name) {
        return this.logManager.getProperty(this.getClass().getName() + "." + name);
    }

    private String getFileProperty(String name) {
        return (String)this.fileProperties.get(this.getClass().getName() + "." + name);
    }

    private String castToString(String val) {
        if (val == null) {
            return null;
        }
        return val.trim();
    }

    private int castToInt(String val) {
        if (val == null) {
            return 0;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private Level castToLevel(String val) {
        if (val == null) {
            return null;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void manage(Logger logger, boolean mainContainer) {
        Handler[] handlers;
        WadeHandler wadeHandler = null;
        ArrayList<Handler> consoleHandlers = new ArrayList<Handler>();
        ArrayList<Handler> rollingFileHandlers = new ArrayList<Handler>();
        for (Handler h : handlers = logger.getHandlers()) {
            if (h instanceof WadeHandler) {
                wadeHandler = (WadeHandler)h;
                continue;
            }
            if (h instanceof ConsoleHandler) {
                consoleHandlers.add(h);
                continue;
            }
            if (!(h instanceof RollingFileHandler)) continue;
            rollingFileHandlers.add(h);
        }
        for (Handler ch : consoleHandlers) {
            logger.removeHandler(ch);
        }
        if (mainContainer) {
            for (Handler rfh : rollingFileHandlers) {
                logger.removeHandler(rfh);
            }
        }
        if (wadeHandler != null) {
            logger.addHandler(wadeHandler.createConsoleHandler());
            if (mainContainer) {
                logger.addHandler(wadeHandler.createRollingFileHandler("main"));
            }
        } else {
            logger.addHandler(WadeHandler.createDefaultConsoleHandler());
            if (mainContainer) {
                logger.addHandler(WadeHandler.createDefaultRollingFileHandler("main", null));
            }
        }
    }

    public static ConsoleHandler createDefaultConsoleHandler() {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(new WadeFormatter());
        return consoleHandler;
    }

    public static RollingFileHandler createDefaultRollingFileHandler(String namePrefix, String projectHome) {
        return new RollingFileHandler("./log", namePrefix, "yyyy_MM_dd", ".log", 0, "day", Level.ALL, new WadeFormatter(), null, projectHome);
    }
}

