/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.wsma;

import com.tilab.wade.commons.TypeManager;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.wsma.Storage;
import com.tilab.wade.wsma.StorageException;
import com.tilab.wade.wsma.ontology.WorkflowExecutionInfo;
import jade.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryStorage
implements Storage {
    private static final int DEFAULT_MAX_STORAGE_ENTRY = 1000;
    private static final String MAX_STORAGE_ENTRY_KEY = "maxStorageEntry";
    private Map<String, WorkflowExecutionInfo> executions;
    private Map<String, byte[]> serializedStates;
    private int maxStorageEntry;

    @Override
    public void init(Map<String, Object> arguments) throws StorageException {
        this.executions = new HashMap<String, WorkflowExecutionInfo>();
        this.serializedStates = new HashMap<String, byte[]>();
        this.maxStorageEntry = TypeManager.getInt(arguments, MAX_STORAGE_ENTRY_KEY, 1000);
    }

    @Override
    public void close() throws StorageException {
    }

    @Override
    public void started(WorkflowExecutionInfo wei) throws StorageException {
        if (this.executions.size() >= this.maxStorageEntry) {
            this.removeOlderEntry();
        }
        this.executions.put(wei.getExecutionId(), wei);
    }

    private void removeOlderEntry() {
        String olderExecutionId = null;
        long olderUpdateTime = Long.MAX_VALUE;
        for (WorkflowExecutionInfo wei : this.executions.values()) {
            if (wei.getStatus() != WorkflowExecutionInfo.WorkflowStatus.TERMINATED || wei.getLastUpdateTime() >= olderUpdateTime) continue;
            olderExecutionId = wei.getExecutionId();
            olderUpdateTime = wei.getLastUpdateTime();
        }
        this.executions.remove(olderExecutionId);
        this.serializedStates.remove(olderExecutionId);
    }

    @Override
    public void statusChanged(String executionId, WorkflowExecutionInfo.WorkflowStatus status, long timestamp) throws StorageException {
        WorkflowExecutionInfo wei = this.executions.get(executionId);
        if (wei != null) {
            wei.setLastUpdateTime(timestamp);
            wei.setStatus(status);
        }
    }

    @Override
    public void serializedStateChanged(String executionId, String currentActivity, byte[] serializedState, long timestamp) throws StorageException {
        WorkflowExecutionInfo wei = this.executions.get(executionId);
        if (wei != null) {
            wei.setLastUpdateTime(timestamp);
            wei.setWorkflowCurrentActivity(currentActivity);
            this.serializedStates.put(executionId, serializedState);
        }
    }

    @Override
    public void terminated(String executionId, WorkflowExecutionInfo.WorkflowResult result, List<Parameter> parameters, String errorMessage, long timestamp) throws StorageException {
        WorkflowExecutionInfo wei = this.executions.get(executionId);
        if (wei != null) {
            wei.setLastUpdateTime(timestamp);
            wei.setStatus(WorkflowExecutionInfo.WorkflowStatus.TERMINATED);
            wei.setResult(result);
            wei.updateWadeParameters(parameters);
            wei.setErrorMessage(errorMessage);
            wei.setWorkflowCurrentActivity(null);
            this.serializedStates.remove(executionId);
        }
    }

    @Override
    public void thawed(String executionId, String executorName, long timestamp) throws StorageException {
        WorkflowExecutionInfo wei = this.executions.get(executionId);
        if (wei != null) {
            wei.setLastUpdateTime(timestamp);
            wei.setStatus(WorkflowExecutionInfo.WorkflowStatus.ACTIVE);
            wei.setExecutorName(executorName);
        }
    }

    @Override
    public void removeExecution(String executionId) throws StorageException {
        this.executions.remove(executionId);
    }

    @Override
    public void cleanExecutions() throws StorageException {
        this.executions.clear();
    }

    @Override
    public WorkflowExecutionInfo getExecution(String executionId) throws StorageException {
        return this.executions.get(executionId);
    }

    @Override
    public byte[] getSerializedState(String executionId) throws StorageException {
        return this.serializedStates.get(executionId);
    }

    @Override
    public List<WorkflowExecutionInfo> getSessionExecutions(String sessionId) throws StorageException {
        ArrayList<WorkflowExecutionInfo> weisBySession = new ArrayList<WorkflowExecutionInfo>();
        for (WorkflowExecutionInfo wei : this.executions.values()) {
            if (!sessionId.equalsIgnoreCase(wei.getSessionId())) continue;
            weisBySession.add(wei);
        }
        return weisBySession;
    }

    @Override
    public List<WorkflowExecutionInfo> getPendingExecutions(String requester) throws StorageException {
        ArrayList<WorkflowExecutionInfo> weisByRequester = new ArrayList<WorkflowExecutionInfo>();
        for (WorkflowExecutionInfo wei : this.executions.values()) {
            if (requester != null && !requester.equalsIgnoreCase(wei.getRequester()) || wei.getStatus() == WorkflowExecutionInfo.WorkflowStatus.TERMINATED) continue;
            weisByRequester.add(wei);
        }
        return weisByRequester;
    }

    @Override
    public List queryExecutions(String what, String condition, String order, int firstResult, int maxResult) throws StorageException {
        myLogger.log(Logger.WARNING, "QueryExecutions method not available in MemoryStorage");
        throw new UnsupportedOperationException("QueryExecutions method not available in MemoryStorage");
    }
}

