/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.wsma;

import com.tilab.wade.cfa.ontology.ConfigurationOntology;
import com.tilab.wade.commons.AgentInitializationException;
import com.tilab.wade.commons.AttributeGetter;
import com.tilab.wade.commons.WadeAgentImpl;
import com.tilab.wade.performer.ontology.ThawWorkflow;
import com.tilab.wade.performer.ontology.WorkflowManagementOntology;
import com.tilab.wade.utils.GUIDGenerator;
import com.tilab.wade.wsma.MemoryStorage;
import com.tilab.wade.wsma.Storage;
import com.tilab.wade.wsma.StorageException;
import com.tilab.wade.wsma.ontology.CleanExecutions;
import com.tilab.wade.wsma.ontology.GetExecution;
import com.tilab.wade.wsma.ontology.GetPendingExecutions;
import com.tilab.wade.wsma.ontology.GetSerializedState;
import com.tilab.wade.wsma.ontology.GetSessionExecutions;
import com.tilab.wade.wsma.ontology.QueryExecutions;
import com.tilab.wade.wsma.ontology.RemoveExecution;
import com.tilab.wade.wsma.ontology.SerializedStateChanged;
import com.tilab.wade.wsma.ontology.Started;
import com.tilab.wade.wsma.ontology.StatusChanged;
import com.tilab.wade.wsma.ontology.Terminated;
import com.tilab.wade.wsma.ontology.Thawed;
import com.tilab.wade.wsma.ontology.WorkflowExecutionInfo;
import com.tilab.wade.wsma.ontology.WorkflowStatusOntology;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.leap.LEAPCodec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ServiceException;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OntologyServer;
import jade.core.behaviours.SimpleBehaviour;
import jade.core.messaging.TopicManagementHelper;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class WorkflowStatusManagerAgent
extends WadeAgentImpl {
    private static final long serialVersionUID = 4381731786126014084L;
    public static final String STORAGE_CLASS_NAME_KEY = "storageClassName";
    private Storage storage;

    @AttributeGetter(name="Storage class-name")
    public String getStorageClassName() {
        return this.storage.getClass().getName();
    }

    protected void agentSpecificSetup() throws AgentInitializationException {
        this.getContentManager().registerLanguage((Codec)new SLCodec());
        this.getContentManager().registerLanguage((Codec)new LEAPCodec());
        this.getContentManager().registerOntology(WorkflowStatusOntology.getInstance());
        this.getContentManager().registerOntology(WorkflowManagementOntology.getInstance());
        this.getContentManager().registerOntology(ConfigurationOntology.getInstance());
        String poolName = this.getArgument("AGENT_POOL", null);
        boolean agentMaster = this.getBooleanArgument("AGENT-MASTER", false);
        boolean isMaster = poolName == null || poolName != null && agentMaster;
        try {
            String storageClassName = this.getArgument(STORAGE_CLASS_NAME_KEY, null);
            if (storageClassName != null) {
                this.myLogger.log(Level.CONFIG, "Agent " + this.getName() + " - Loading Storage: " + storageClassName);
                this.storage = (Storage)Class.forName(storageClassName).newInstance();
            } else {
                try {
                    this.storage = (Storage)Class.forName("com.tilab.wade.wsma.HibernateStorage").newInstance();
                }
                catch (Exception e) {
                    this.storage = new MemoryStorage();
                }
            }
            this.myLogger.log(Level.INFO, "Agent " + this.getName() + " - Using Storage " + this.storage.getClass().getName());
            this.storage.init(this.arguments);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + " - Error creating wsma storage", (Throwable)e);
            throw new AgentInitializationException("Error creating wsma storage", e);
        }
        this.addBehaviour((Behaviour)new OntologyServer((Agent)this, WorkflowStatusOntology.getInstance(), new int[]{7, 16}, (Object)this));
        if (!this.getRestarted() && isMaster) {
            AID platformLifeCycleTopic = WorkflowStatusManagerAgent.registerToTopic(this, "Platform-Life-Cycle");
            this.addBehaviour((Behaviour)new PlatformStartupListener(platformLifeCycleTopic));
        }
    }

    protected void takeDown() {
        try {
            this.storage.close();
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error closing storage", (Throwable)e);
        }
    }

    public int getCurrentLoad() {
        return this.getCurQueueSize();
    }

    private void thaw(WorkflowExecutionInfo wei) {
        block4: {
            try {
                ACLMessage message = new ACLMessage(16);
                message.setLanguage("fipa-sl");
                message.setOntology(WorkflowManagementOntology.getInstance().getName());
                message.addReceiver(wei.getExecutor());
                message.setConversationId(GUIDGenerator.getGUID());
                byte[] workflowSerializedState = this.storage.getSerializedState(wei.getExecutionId());
                ThawWorkflow tw = new ThawWorkflow(workflowSerializedState, null, null);
                tw.setExecution(Integer.valueOf(1));
                Action action = new Action(wei.getExecutor(), (Concept)tw);
                this.getContentManager().fillContent(message, (ContentElement)action);
                this.send(message);
                MessageTemplate mt = MessageTemplate.MatchConversationId((String)message.getConversationId());
                ACLMessage reply = this.blockingReceive(mt, 10000L);
                if (reply != null) {
                    if (reply.getPerformative() != 6) break block4;
                    if (reply.getSender().equals((Object)this.getAMS())) {
                        this.handleMissingOriginalExecutor(wei);
                        break block4;
                    }
                    throw new Exception(reply.toString());
                }
                throw new Exception("Timeout");
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error thawing workflow, executionId=" + wei.getExecutionId(), (Throwable)e);
            }
        }
    }

    protected void handleMissingOriginalExecutor(WorkflowExecutionInfo wei) {
        try {
            this.storage.statusChanged(wei.getExecutionId(), WorkflowExecutionInfo.WorkflowStatus.FROZEN, System.currentTimeMillis());
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving StatusChanged predicate, executionId=" + wei.getExecutionId(), (Throwable)e);
        }
    }

    public void serveStartedInform(Started started, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving Started predicate " + started);
        try {
            WorkflowExecutionInfo wi = started.getWorkflowExecutionInfo();
            wi.setStartTime(System.currentTimeMillis());
            wi.setLastUpdateTime(wi.getStartTime());
            this.storage.started(wi);
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving Started predicate " + started, (Throwable)e);
            throw e;
        }
    }

    public void serveTerminatedInform(Terminated terminated, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving Terminated predicate " + terminated);
        try {
            String errorMessage = terminated.getErrorMessage();
            WorkflowExecutionInfo.WorkflowResult result = errorMessage != null && errorMessage.length() > 0 ? WorkflowExecutionInfo.WorkflowResult.KO : WorkflowExecutionInfo.WorkflowResult.OK;
            this.storage.terminated(terminated.getExecutionId(), result, terminated.getParameters(), errorMessage, System.currentTimeMillis());
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving Terminated predicate " + terminated, (Throwable)e);
            throw e;
        }
    }

    public void serveThawedInform(Thawed thawed, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving Thawed predicate " + thawed);
        try {
            this.storage.thawed(thawed.getExecutionId(), thawed.getExecutorName(), System.currentTimeMillis());
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving Thawed predicate " + thawed, (Throwable)e);
            throw e;
        }
    }

    public void serveSerializedStateChangedInform(SerializedStateChanged store, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving SerializedStateChanged predicate " + store);
        try {
            this.storage.serializedStateChanged(store.getExecutionId(), store.getCurrentActivity(), store.getSerializedState(), System.currentTimeMillis());
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving SerializedStateChanged predicate " + store, (Throwable)e);
            throw e;
        }
    }

    public void serveStatusChangedInform(StatusChanged changeState, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving StatusChanged predicate " + changeState);
        try {
            this.storage.statusChanged(changeState.getExecutionId(), changeState.getStatus(), System.currentTimeMillis());
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving StatusChanged predicate " + changeState, (Throwable)e);
            throw e;
        }
    }

    public void serveRemoveExecutionRequest(RemoveExecution remove, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving Remove action " + remove);
        try {
            this.storage.removeExecution(remove.getExecutionId());
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving Remove action " + remove, (Throwable)e);
            throw e;
        }
        this.sendResponse(msg, 7, (AgentAction)remove, null);
    }

    public void serveCleanExecutionsRequest(CleanExecutions clean, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving Clean action " + clean);
        try {
            this.storage.cleanExecutions();
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving Clean action " + clean, (Throwable)e);
            throw e;
        }
        this.sendResponse(msg, 7, (AgentAction)clean, null);
    }

    public void serveGetExecutionRequest(GetExecution getExecution, ACLMessage msg) throws Exception {
        WorkflowExecutionInfo wei;
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving GetExecution action " + getExecution);
        String executionId = getExecution.getExecutionId();
        try {
            wei = this.storage.getExecution(executionId);
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving GetExecution action " + getExecution, (Throwable)e);
            throw e;
        }
        if (wei != null) {
            this.sendResponse(msg, 7, (AgentAction)getExecution, wei);
        } else {
            this.sendResponse(msg, 6, (AgentAction)getExecution, "Workflow with executionId=" + executionId + " is not present");
        }
    }

    public void serveGetSerializedStateRequest(GetSerializedState getSerializedState, ACLMessage msg) throws Exception {
        byte[] serializedState;
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving GetSerializedState action " + getSerializedState);
        String executionId = getSerializedState.getExecutionId();
        try {
            serializedState = this.storage.getSerializedState(executionId);
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving GetSerializedState action " + getSerializedState, (Throwable)e);
            throw e;
        }
        if (serializedState != null) {
            this.sendResponse(msg, 7, (AgentAction)getSerializedState, serializedState);
        } else {
            this.sendResponse(msg, 6, (AgentAction)getSerializedState, "Workflow serialized state with executionId=" + executionId + " is not present");
        }
    }

    public void serveGetPendingExecutionsRequest(GetPendingExecutions getPendingExecutions, ACLMessage msg) throws Exception {
        List<WorkflowExecutionInfo> weis;
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving GetPendingExecutions action " + getPendingExecutions);
        try {
            weis = this.storage.getPendingExecutions(getPendingExecutions.getRequester());
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving GetPendingExecutions action " + getPendingExecutions, (Throwable)e);
            throw e;
        }
        this.sendResponse(msg, 7, (AgentAction)getPendingExecutions, weis);
    }

    public void serveGetSessionExecutionsRequest(GetSessionExecutions getSessionExecutions, ACLMessage msg) throws Exception {
        List<WorkflowExecutionInfo> weis;
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving GetSessionExecutions action " + getSessionExecutions);
        try {
            weis = this.storage.getSessionExecutions(getSessionExecutions.getSessionId());
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving GetSessionExecutions action " + getSessionExecutions, (Throwable)e);
            throw e;
        }
        this.sendResponse(msg, 7, (AgentAction)getSessionExecutions, weis);
    }

    public void serveQueryExecutionsRequest(QueryExecutions query, ACLMessage msg) throws Exception {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving QueryExecutions action " + query);
        try {
            List results = this.storage.queryExecutions(query.getWhat(), query.getCondition(), query.getOrder(), query.getFirstResult(), query.getMaxResult());
            this.sendResponse(msg, 7, (AgentAction)query, results);
        }
        catch (UnsupportedOperationException uoe) {
            String failureMsg = "Querying workflow executions is not supported without the Persistence Add-On";
            this.myLogger.log(Logger.WARNING, failureMsg);
            this.sendResponse(msg, 6, (AgentAction)query, failureMsg);
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error serving QueryExecutions action " + query, (Throwable)e);
            throw e;
        }
    }

    private void sendResponse(ACLMessage request, int performative, AgentAction agentAction, Object result) {
        ACLMessage reply = request.createReply();
        reply.setPerformative(performative);
        if (performative == 7) {
            if (result != null) {
                if (result instanceof byte[]) {
                    reply.setByteSequenceContent((byte[])result);
                } else if (agentAction != null) {
                    if (result instanceof java.util.ArrayList) {
                        result = new ArrayList((java.util.ArrayList)result);
                    }
                    Action action = new Action(this.getAID(), (Concept)agentAction);
                    Result ce = new Result((Concept)action, result);
                    try {
                        this.getContentManager().fillContent(reply, (ContentElement)ce);
                    }
                    catch (Exception e) {
                        this.myLogger.log(Level.SEVERE, "Agent " + this.getName() + " - Error encoding request", (Throwable)e);
                        performative = 6;
                        reply.setContent("Unexpected error: " + e.getMessage());
                    }
                }
            }
        } else if (result != null && result instanceof String) {
            reply.setContent((String)result);
        }
        this.send(reply);
    }

    private static AID registerToTopic(Agent agent, String topicName) throws AgentInitializationException {
        try {
            TopicManagementHelper topicHelper = (TopicManagementHelper)agent.getHelper("jade.core.messaging.TopicManagement");
            AID topic = topicHelper.createTopic(topicName);
            topicHelper.register(topic);
            return topic;
        }
        catch (ServiceException se) {
            throw new AgentInitializationException("Error registering to topic " + topicName, se);
        }
    }

    private void checkWorkflowExecutions() throws StorageException {
        try {
            String condition = "wi.statusName='" + WorkflowExecutionInfo.WorkflowStatus.ACTIVE + "'";
            condition = condition + " or wi.statusName='" + WorkflowExecutionInfo.WorkflowStatus.SUSPENDED + "'";
            condition = condition + " or wi.statusName='" + WorkflowExecutionInfo.WorkflowStatus.ROLLBACK + "'";
            condition = condition + " or wi.statusName='" + WorkflowExecutionInfo.WorkflowStatus.WAIT_COMMIT + "'";
            List weis = this.storage.queryExecutions(null, condition, null, 0, -1);
            for (WorkflowExecutionInfo wei : weis) {
                if (wei.isLongRunning()) {
                    if (wei.isInteractive()) {
                        this.myLogger.log(Logger.INFO, "Agent " + this.getLocalName() + " - Workflow execution " + wei.getExecutionId() + " is interactive --> Mark it as FROZEN");
                        this.storage.statusChanged(wei.getExecutionId(), WorkflowExecutionInfo.WorkflowStatus.FROZEN, System.currentTimeMillis());
                        continue;
                    }
                    this.myLogger.log(Logger.INFO, "Agent " + this.getLocalName() + " - Workflow execution " + wei.getExecutionId() + " is long-running --> resume it");
                    this.thaw(wei);
                    continue;
                }
                if (wei.isTransactional()) {
                    this.myLogger.log(Logger.INFO, "Agent " + this.getLocalName() + " - Workflow execution " + wei.getExecutionId() + " is short-running & transactional --> Mark it as TERMINATED/TRANSACTION_FAIL");
                    this.storage.terminated(wei.getExecutionId(), WorkflowExecutionInfo.WorkflowResult.TRANSACTION_FAIL, null, "Workflow not correctly terminated before platform shutting down", System.currentTimeMillis());
                    continue;
                }
                this.myLogger.log(Logger.INFO, "Agent " + this.getLocalName() + " - Workflow execution " + wei.getExecutionId() + " is short-running --> Mark it as TERMINATED/KO");
                this.storage.terminated(wei.getExecutionId(), WorkflowExecutionInfo.WorkflowResult.KO, null, "Workflow not correctly terminated before platform shutting down", System.currentTimeMillis());
            }
        }
        catch (UnsupportedOperationException uoe) {
        }
        catch (StorageException e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error checking storage consistency", (Throwable)e);
            throw e;
        }
    }

    private class PlatformStartupListener
    extends SimpleBehaviour {
        private static final long serialVersionUID = -5921795489489965046L;
        private boolean finished = false;
        private MessageTemplate template;

        private PlatformStartupListener(AID platformLifeCycleTopic) {
            this.template = MessageTemplate.MatchTopic((AID)platformLifeCycleTopic);
        }

        public void action() {
            ACLMessage msg = this.myAgent.receive(this.template);
            if (msg != null) {
                try {
                    Result r = (Result)this.myAgent.getContentManager().extractContent(msg);
                    String platformStatus = (String)r.getValue();
                    if (platformStatus.equals("active-status") || platformStatus.equals("active-with-warnings")) {
                        this.finished = true;
                        WorkflowStatusManagerAgent.this.checkWorkflowExecutions();
                    }
                }
                catch (Exception e) {
                    WorkflowStatusManagerAgent.this.myLogger.log(Logger.WARNING, "Agent " + WorkflowStatusManagerAgent.this.getName() + " - Error decoding platform life cycle notification", (Throwable)e);
                }
            } else {
                this.block();
            }
        }

        public boolean done() {
            return this.finished;
        }
    }
}

