/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.ca;

import com.tilab.wade.utils.DFUtils;
import com.tilab.wade.utils.FileUtils;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.AMSService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.proto.AchieveREInitiator;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Collection;
import jade.util.leap.List;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class JarDeployer
extends AchieveREInitiator {
    public static final String DEPLOYED_FILE_NAME = "WADE-Deployed-Name";
    public static final String REBUILD_CLASSLOADER = "Rebuild-ClassLoader";
    public static final long DEFAULT_DEPLOY_TIMEOUT = 60000L;
    private Collection deployers;
    private long timeout;
    private String destName;
    private File jarFile;
    private byte[] jarContent;
    private boolean rebuildClassLoader;
    private List successfulDeployers = new ArrayList();
    private List unSuccessfulDeployers = new ArrayList();
    private List missingDeployers = new ArrayList();
    private Map<AID, String> failureReasons = new HashMap<AID, String>();
    protected Logger logger;

    public JarDeployer(String jarFileName, Collection deployers) throws IOException {
        this(jarFileName, deployers, 60000L, null, null, true);
    }

    public JarDeployer(String jarFileName, Collection deployers, long timeout, String destName, Logger logger, boolean rebuildClassLoader) throws IOException {
        super(null, null);
        this.deployers = deployers;
        this.timeout = timeout;
        if (jarFileName != null) {
            this.jarFile = new File(jarFileName);
            this.jarContent = FileUtils.file2byte(this.jarFile);
            this.destName = destName != null ? destName : this.jarFile.getName();
        }
        this.logger = logger != null ? logger : Logger.getMyLogger((String)((Object)((Object)this)).getClass().getName());
        this.rebuildClassLoader = rebuildClassLoader;
    }

    public JarDeployer(String jarFileName, Collection deployers, long timeout, String destName, Logger logger) throws IOException {
        this(jarFileName, deployers, timeout, destName, logger, true);
    }

    protected Vector prepareRequests(ACLMessage msg) {
        ACLMessage request = new ACLMessage(16);
        StringBuffer sb = new StringBuffer("Deploying jar to:");
        if (this.deployers == null) {
            try {
                AID[] aidList;
                this.deployers = new ArrayList();
                DFAgentDescription[] dfadList = DFUtils.searchAllByType(this.myAgent, "Control Agent", null);
                for (AID aid : aidList = DFUtils.getAIDs(dfadList)) {
                    this.deployers.add((Object)aid);
                }
            }
            catch (FIPAException e) {
                e.printStackTrace();
            }
        }
        for (AID dplId : this.deployers) {
            request.addReceiver(dplId);
            this.unSuccessfulDeployers.add((Object)dplId);
            sb.append("\n- " + dplId.getName());
        }
        this.logger.log(Logger.FINE, "Agent " + this.myAgent.getName() + " - " + sb.toString());
        if (this.jarFile != null) {
            request.setByteSequenceContent(this.jarContent);
            request.addUserDefinedParameter(DEPLOYED_FILE_NAME, this.destName);
        }
        request.setOntology("Deployment-ontology");
        request.setReplyByDate(new Date(System.currentTimeMillis() + this.timeout));
        request.addUserDefinedParameter(REBUILD_CLASSLOADER, String.valueOf(this.rebuildClassLoader));
        Vector<ACLMessage> v = new Vector<ACLMessage>(1);
        v.addElement(request);
        return v;
    }

    protected void handleAllResultNotifications(Vector notifications) {
        Enumeration ee = notifications.elements();
        while (ee.hasMoreElements()) {
            ACLMessage msg = (ACLMessage)ee.nextElement();
            AID deployer = msg.getSender();
            if (msg.getPerformative() == 7) {
                this.successfulDeployers.add((Object)deployer);
                this.unSuccessfulDeployers.remove((Object)deployer);
                if (this.jarFile != null) {
                    this.logger.log(Logger.FINE, "Agent " + this.myAgent.getName() + " - Jar " + this.jarFile.getName() + " successfully deployed to " + deployer.getName());
                    continue;
                }
                this.logger.log(Logger.FINE, "Agent " + this.myAgent.getName() + " - Classloader successfully rebuilt");
                continue;
            }
            if (deployer.equals((Object)this.myAgent.getAMS())) {
                try {
                    deployer = AMSService.getFailedReceiver((Agent)this.myAgent, (ACLMessage)msg);
                    this.logger.log(Logger.WARNING, "Agent " + this.myAgent.getLocalName() + " - Deployer agent " + deployer.getName() + " does not exist.");
                    this.missingDeployers.add((Object)deployer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.jarFile != null) {
                this.logger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Deployment of jar " + this.jarFile.getName() + " failed to " + deployer.getName());
            } else {
                this.logger.log(Logger.FINE, "Agent " + this.myAgent.getName() + " - Classloader rebuild failed");
            }
            this.failureReasons.put(deployer, msg.getContent());
        }
    }

    public void setDeployers(List deployers) {
        this.deployers = deployers;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public List getSuccessfulControllers() {
        return this.successfulDeployers;
    }

    public List getUnSuccessfulControllers() {
        return this.unSuccessfulDeployers;
    }

    public List getMissingControllers() {
        return this.missingDeployers;
    }

    public String getFailureReason(AID controller) {
        return this.failureReasons.get(controller);
    }
}

