/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa.beans;

import com.tilab.wade.cfa.beans.AgentArgumentInfo;
import com.tilab.wade.cfa.beans.PlatformElement;
import com.tilab.wade.utils.FileUtils;
import jade.util.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentBaseInfo
extends PlatformElement
implements Cloneable {
    private static final long serialVersionUID = 5333949601628498610L;
    protected final Logger myLogger = Logger.getMyLogger((String)this.getClass().getName());
    private String name;
    private String type;
    private String className;
    private String owner;
    private Collection<AgentArgumentInfo> parameters = new HashSet<AgentArgumentInfo>();

    public AgentBaseInfo() {
    }

    public AgentBaseInfo(String name, String type, String className, String owner, Collection parameters) {
        this.name = name;
        this.type = type;
        this.className = className;
        this.owner = owner;
        this.parameters = parameters;
    }

    public AgentBaseInfo(String name, String type, String className, String owner) {
        this.name = name;
        this.type = type;
        this.className = className;
        this.owner = owner;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Collection<AgentArgumentInfo> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<AgentArgumentInfo> arguments) {
        this.parameters = arguments;
    }

    public void addParameter(AgentArgumentInfo agentArgumentInfo) {
        this.parameters.add(agentArgumentInfo);
    }

    public AgentArgumentInfo getParameter(String name) {
        AgentArgumentInfo result = null;
        for (AgentArgumentInfo aai : this.parameters) {
            if (!aai.getKey().equals(name)) continue;
            result = aai;
            break;
        }
        return result;
    }

    public String toString() {
        return this.toString("", false);
    }

    public String toString(String prefix, boolean onlyError) {
        StringBuffer sb = new StringBuffer(prefix + "AGENT ");
        sb.append(this.name);
        sb.append('\n');
        if (this.getErrorCode() != null) {
            sb.append(prefix + "- error-code: ");
            sb.append(this.getErrorCode());
            sb.append('\n');
        }
        if (!onlyError && this.parameters.size() > 0) {
            sb.append(prefix + "- arguments: ");
            for (AgentArgumentInfo argument : this.parameters) {
                sb.append(argument.toString(prefix + "  "));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AgentBaseInfo) {
            return this.name.equals(((AgentBaseInfo)obj).getName());
        }
        return false;
    }

    public boolean isEquivalent(AgentBaseInfo ai) {
        if (ai == null) {
            return false;
        }
        return FileUtils.compareObject(this.getName(), ai.getName()) && FileUtils.compareObject(this.getType(), ai.getType());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean skipArgument(String argumentKey) {
        return false;
    }

    public SortedMap<String, String> getParametersForComparison() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        return result;
    }
}

