/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa.beans;

import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.cfa.beans.PlatformElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerInfo
extends PlatformElement {
    private static final long serialVersionUID = -8863153516957235502L;
    private String name;
    private String projectName;
    private String javaProfile;
    private String jadeProfile;
    private String jadeAdditionalArgs;
    private Collection<AgentInfo> agents = new HashSet<AgentInfo>();

    public ContainerInfo() {
    }

    public ContainerInfo(String name) {
        this.name = name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getJadeAdditionalArgs() {
        return this.jadeAdditionalArgs;
    }

    public void setJadeAdditionalArgs(String jadeAdditionalArgs) {
        this.jadeAdditionalArgs = jadeAdditionalArgs;
    }

    public String getJadeProfile() {
        return this.jadeProfile;
    }

    public void setJadeProfile(String jadeProfile) {
        this.jadeProfile = jadeProfile;
    }

    public String getJavaProfile() {
        return this.javaProfile;
    }

    public void setJavaProfile(String javaProfile) {
        this.javaProfile = javaProfile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAgents(Collection<AgentInfo> agents) {
        this.agents = agents;
    }

    public Collection<AgentInfo> getAgents() {
        return this.agents;
    }

    public List getAgentsAsList() {
        return new ArrayList<AgentInfo>(this.agents);
    }

    public void addAgent(AgentInfo agentInfo) {
        if (this.agents.contains(agentInfo)) {
            this.agents.remove(agentInfo);
        }
        this.agents.add(agentInfo);
    }

    public AgentInfo getAgent(String agentName) {
        AgentInfo result = null;
        for (AgentInfo ai : this.agents) {
            if (!ai.getName().equals(agentName)) continue;
            result = ai;
            break;
        }
        return result;
    }

    public boolean removeAgent(AgentInfo ai) {
        return this.agents.remove(ai);
    }

    public String toString() {
        return this.toString("", false);
    }

    public String toString(String prefix, boolean onlyError) {
        StringBuffer sb = new StringBuffer(prefix + "CONTAINER ");
        sb.append(this.name);
        sb.append('\n');
        if (this.getErrorCode() != null) {
            sb.append(prefix + "- error-code: ");
            sb.append(this.getErrorCode());
            sb.append('\n');
        }
        if (this.agents.size() > 0) {
            sb.append(prefix + "- agents:\n");
            for (AgentInfo agent : this.agents) {
                sb.append(agent.toString(prefix + "  ", onlyError));
            }
        }
        return sb.toString();
    }
}

