/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa.beans;

import com.tilab.wade.cfa.beans.ContainerInfo;
import com.tilab.wade.cfa.beans.PlatformElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostInfo
extends PlatformElement {
    private static final long serialVersionUID = 2060315148568397980L;
    private String name;
    private String ipAddress;
    private String cpuNumber;
    private String ram;
    private String adminState;
    private String benchmarkSpecInt;
    private String benchmarkWf;
    private boolean availability;
    private boolean reachability;
    private boolean backupAllowed = false;
    private Collection<ContainerInfo> containers = new HashSet<ContainerInfo>();

    public boolean getAvailability() {
        return this.availability;
    }

    public void setAvailability(boolean availability) {
        this.availability = availability;
    }

    public Collection<ContainerInfo> getContainers() {
        return this.containers;
    }

    public void setContainers(Collection<ContainerInfo> containers) {
        this.containers = containers;
    }

    public void addContainer(ContainerInfo containerInfo) {
        this.containers.add(containerInfo);
    }

    public void removeAllContainers() {
        this.containers.clear();
    }

    public String getCpuNumber() {
        return this.cpuNumber;
    }

    public void setCpuNumber(String cpuNumber) {
        this.cpuNumber = cpuNumber;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBenchmarkSpecInt() {
        return this.benchmarkSpecInt;
    }

    public void setBenchmarkSpecInt(String benchmarkSpecInt) {
        this.benchmarkSpecInt = benchmarkSpecInt;
    }

    public String getBenchmarkWf() {
        return this.benchmarkWf;
    }

    public void setBenchmarkWf(String benchmarkWf) {
        this.benchmarkWf = benchmarkWf;
    }

    public String getRam() {
        return this.ram;
    }

    public void setRam(String ram) {
        this.ram = ram;
    }

    public String getAdminState() {
        return this.adminState;
    }

    public void setAdminState(String adminState) {
        this.adminState = adminState;
    }

    public List getContainersAsList() {
        return new ArrayList<ContainerInfo>(this.containers);
    }

    public boolean getReachability() {
        return this.reachability;
    }

    public void setReachability(boolean reachability) {
        this.reachability = reachability;
    }

    public boolean isBackupAllowed() {
        return this.backupAllowed;
    }

    public boolean getBackupAllowed() {
        return this.isBackupAllowed();
    }

    public void setBackupAllowed(boolean backupAllowed) {
        this.backupAllowed = backupAllowed;
    }

    public boolean equals(Object obj) {
        return obj instanceof HostInfo && this.name.equalsIgnoreCase(((HostInfo)obj).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.toString("", false);
    }

    public String toString(String prefix, boolean onlyError) {
        StringBuffer sb = new StringBuffer(prefix + "HOST ");
        sb.append(this.name);
        sb.append('\n');
        if (this.getErrorCode() != null) {
            sb.append(prefix + "- error-code: ");
            sb.append(this.getErrorCode());
            sb.append('\n');
        }
        if (!onlyError) {
            sb.append(prefix + "- reachability: ");
            sb.append(this.reachability);
            sb.append('\n');
            sb.append(prefix + "- availability: ");
            sb.append(this.availability);
            sb.append('\n');
        }
        if (this.containers.size() > 0) {
            sb.append(prefix + "- containers:\n");
            for (ContainerInfo container : this.containers) {
                sb.append(container.toString(prefix + "  ", onlyError));
            }
        }
        return sb.toString();
    }
}

