/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa.beans;

import com.tilab.wade.cfa.beans.AgentPoolInfo;
import com.tilab.wade.cfa.beans.ContainerProfileInfo;
import com.tilab.wade.cfa.beans.HostInfo;
import com.tilab.wade.cfa.beans.PlatformElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformInfo
extends PlatformElement {
    private static final long serialVersionUID = -639390821466559901L;
    private String name;
    private String description;
    private int backupsNumber = 0;
    private Collection<HostInfo> hosts = new HashSet<HostInfo>();
    private Collection<ContainerProfileInfo> containerProfiles = new HashSet<ContainerProfileInfo>();
    private Collection<AgentPoolInfo> agentPools = new HashSet<AgentPoolInfo>();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<ContainerProfileInfo> getContainerProfiles() {
        return this.containerProfiles;
    }

    public void addContainerProfile(ContainerProfileInfo containerProfileInfo) {
        this.containerProfiles.add(containerProfileInfo);
    }

    public Collection<HostInfo> getHosts() {
        return this.hosts;
    }

    public List getHostsAsList() {
        return new ArrayList<HostInfo>(this.hosts);
    }

    public void addHost(HostInfo hostInfo) {
        this.hosts.add(hostInfo);
    }

    public void setContainerProfiles(Collection<ContainerProfileInfo> containerProfiles) {
        this.containerProfiles = containerProfiles;
    }

    public void setHosts(Collection<HostInfo> hosts) {
        this.hosts = hosts;
    }

    public boolean equals(Object obj) {
        return obj instanceof PlatformInfo && super.equals(obj);
    }

    public int getBackupsNumber() {
        return this.backupsNumber;
    }

    public void setBackupsNumber(int backupsNumber) {
        this.backupsNumber = backupsNumber;
    }

    public List getAgentPoolsAsList() {
        return new ArrayList<AgentPoolInfo>(this.agentPools);
    }

    public Collection<AgentPoolInfo> getAgentPools() {
        return this.agentPools;
    }

    public void addAgentPool(AgentPoolInfo agentPoolInfo) {
        this.agentPools.add(agentPoolInfo);
    }

    public void setAgentPools(Collection<AgentPoolInfo> agentPools) {
        this.agentPools = agentPools;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean onlyError) {
        StringBuffer sb = new StringBuffer("PLATFORM ");
        sb.append(this.name);
        sb.append('\n');
        if (this.getErrorCode() != null) {
            sb.append("- error-code: ");
            sb.append(this.getErrorCode());
            sb.append('\n');
        }
        if (this.hosts != null && this.hosts.size() > 0) {
            sb.append("- hosts:\n");
            for (HostInfo host : this.hosts) {
                sb.append(host.toString("  ", onlyError));
            }
            sb.append('\n');
        }
        if (this.agentPools != null && this.agentPools.size() > 0) {
            sb.append("- agentPools:\n");
            for (AgentPoolInfo agentPool : this.agentPools) {
                sb.append(agentPool.toString("  ", onlyError));
            }
            sb.append('\n');
        }
        if (!onlyError) {
            sb.append("- backup mains: " + this.backupsNumber);
        }
        return sb.toString();
    }
}

