/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.cfa.ontology;

import com.tilab.wade.cfa.beans.AgentArgumentInfo;
import com.tilab.wade.cfa.beans.AgentBaseInfo;
import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.cfa.beans.AgentPoolInfo;
import com.tilab.wade.cfa.beans.ContainerInfo;
import com.tilab.wade.cfa.beans.ContainerProfileInfo;
import com.tilab.wade.cfa.beans.ContainerProfilePropertyInfo;
import com.tilab.wade.cfa.beans.HostInfo;
import com.tilab.wade.cfa.beans.PlatformElement;
import com.tilab.wade.cfa.beans.PlatformInfo;
import com.tilab.wade.cfa.beans.VersionsInfo;
import com.tilab.wade.cfa.beans.VirtualAgentInfo;
import com.tilab.wade.cfa.ontology.AddHost;
import com.tilab.wade.cfa.ontology.CompareRunningWithTargetConfiguration;
import com.tilab.wade.cfa.ontology.ConfigurationVocabulary;
import com.tilab.wade.cfa.ontology.ExportConfiguration;
import com.tilab.wade.cfa.ontology.GetAgentPools;
import com.tilab.wade.cfa.ontology.GetConfigurations;
import com.tilab.wade.cfa.ontology.GetContainerProfiles;
import com.tilab.wade.cfa.ontology.GetHosts;
import com.tilab.wade.cfa.ontology.GetPlatformStatus;
import com.tilab.wade.cfa.ontology.GetStatusDetail;
import com.tilab.wade.cfa.ontology.GetVersionsInfo;
import com.tilab.wade.cfa.ontology.ImportConfiguration;
import com.tilab.wade.cfa.ontology.KillContainer;
import com.tilab.wade.cfa.ontology.RemoveConfiguration;
import com.tilab.wade.cfa.ontology.RemoveHost;
import com.tilab.wade.cfa.ontology.ResetErrorStatus;
import com.tilab.wade.cfa.ontology.SaveConfiguration;
import com.tilab.wade.cfa.ontology.ShutdownPlatform;
import com.tilab.wade.cfa.ontology.StartBackupMainContainer;
import com.tilab.wade.cfa.ontology.StartContainer;
import com.tilab.wade.cfa.ontology.StartupPlatform;
import jade.content.onto.BasicOntology;
import jade.content.onto.CFReflectiveIntrospector;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.SerializableOntology;
import jade.content.schema.AgentActionSchema;
import jade.content.schema.ConceptSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PrimitiveSchema;
import jade.content.schema.TermSchema;

public class ConfigurationOntology
extends Ontology
implements ConfigurationVocabulary {
    private static final Ontology theInstance = new ConfigurationOntology();
    public static final String STARTING_STATUS = "starting-status";
    public static final String ACTIVE_STATUS = "active-status";
    public static final String SHUTDOWN_IN_PROGRESS = "shutdown-in_progress-status";
    public static final String DOWN_STATUS = "down-status";
    public static final String ACTIVE_WITH_WARNINGS_STATUS = "active-with-warnings";
    public static final String ERROR_STATUS = "error-status";
    public static final int OK = 0;
    public static final int KO = 1;

    public static final Ontology getInstance() {
        return theInstance;
    }

    private ConfigurationOntology() {
        super("Configuration-Ontology", new Ontology[]{BasicOntology.getInstance(), SerializableOntology.getInstance()}, (Introspector)new CFReflectiveIntrospector());
        try {
            this.createAllConcepts();
            this.defineAllConcepts();
            this.createAllActions();
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createAllActions() throws OntologyException {
        this.add((ObjectSchema)new AgentActionSchema("startup-platform"), StartupPlatform.class);
        this.add((ObjectSchema)new AgentActionSchema("shutdown-platform"), ShutdownPlatform.class);
        this.add((ObjectSchema)new AgentActionSchema("save-configuration"), SaveConfiguration.class);
        this.add((ObjectSchema)new AgentActionSchema("import-configuration"), ImportConfiguration.class);
        this.add((ObjectSchema)new AgentActionSchema("export-configuration"), ExportConfiguration.class);
        this.add((ObjectSchema)new AgentActionSchema("remove-configuration"), RemoveConfiguration.class);
        this.add((ObjectSchema)new AgentActionSchema("compare-running-with-target-configuration"), CompareRunningWithTargetConfiguration.class);
        this.add((ObjectSchema)new AgentActionSchema("get-configurations"), GetConfigurations.class);
        this.add((ObjectSchema)new AgentActionSchema("get-platform-status"), GetPlatformStatus.class);
        this.add((ObjectSchema)new AgentActionSchema("get-status-detail"), GetStatusDetail.class);
        this.add((ObjectSchema)new AgentActionSchema("get-hosts"), GetHosts.class);
        this.add((ObjectSchema)new AgentActionSchema("get-agent-pools"), GetAgentPools.class);
        this.add((ObjectSchema)new AgentActionSchema("get-container-profiles"), GetContainerProfiles.class);
        this.add((ObjectSchema)new AgentActionSchema("start-container"), StartContainer.class);
        this.add((ObjectSchema)new AgentActionSchema("start-backup-main-container"), StartBackupMainContainer.class);
        this.add((ObjectSchema)new AgentActionSchema("kill-container"), KillContainer.class);
        this.add((ObjectSchema)new AgentActionSchema("reset-error-state"), ResetErrorStatus.class);
        this.add((ObjectSchema)new AgentActionSchema("add-host"), AddHost.class);
        this.add((ObjectSchema)new AgentActionSchema("remove-host"), RemoveHost.class);
        this.add((ObjectSchema)new AgentActionSchema("get-versions-info"), GetVersionsInfo.class);
        AgentActionSchema as = (AgentActionSchema)this.getSchema("import-configuration");
        as.add("name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        as = (AgentActionSchema)this.getSchema("export-configuration");
        as.add("name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        as.add("description", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        as.add("override", (TermSchema)((PrimitiveSchema)this.getSchema("BO_Boolean")));
        as = (AgentActionSchema)this.getSchema("remove-configuration");
        as.add("name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        as = (AgentActionSchema)this.getSchema("start-container");
        as.add("project-name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        as.add("container-name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        as.add("java-profile", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        as.add("jade-profile", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        as.add("jade-additional-args", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        as.add("host-name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        as.add("agents", (TermSchema)((ConceptSchema)this.getSchema("agent")), 0, -1);
        as = (AgentActionSchema)this.getSchema("start-backup-main-container");
        as.add("container-name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        as.add("host-name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        as = (AgentActionSchema)this.getSchema("kill-container");
        as.add("container-name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        as.add("hard-termination", (TermSchema)((PrimitiveSchema)this.getSchema("BO_Boolean")));
        as = (AgentActionSchema)this.getSchema("shutdown-platform");
        as.add("hard-termination", (TermSchema)((PrimitiveSchema)this.getSchema("BO_Boolean")));
        as = (AgentActionSchema)this.getSchema("add-host");
        as.add("host-info", (TermSchema)((ConceptSchema)this.getSchema("host")));
        as = (AgentActionSchema)this.getSchema("remove-host");
        as.add("host-name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
    }

    private void createAllConcepts() throws OntologyException {
        this.add((ObjectSchema)new ConceptSchema("platformElement"), PlatformElement.class);
        this.add((ObjectSchema)new ConceptSchema("platform"), PlatformInfo.class);
        this.add((ObjectSchema)new ConceptSchema("host"), HostInfo.class);
        this.add((ObjectSchema)new ConceptSchema("container"), ContainerInfo.class);
        this.add((ObjectSchema)new ConceptSchema("agentBase"), AgentBaseInfo.class);
        this.add((ObjectSchema)new ConceptSchema("agent"), AgentInfo.class);
        this.add((ObjectSchema)new ConceptSchema("agentPool"), AgentPoolInfo.class);
        this.add((ObjectSchema)new ConceptSchema("virtualAgent"), VirtualAgentInfo.class);
        this.add((ObjectSchema)new ConceptSchema("parameter"), AgentArgumentInfo.class);
        this.add((ObjectSchema)new ConceptSchema("containerProfile"), ContainerProfileInfo.class);
        this.add((ObjectSchema)new ConceptSchema("property"), ContainerProfilePropertyInfo.class);
        this.add((ObjectSchema)new ConceptSchema("versions"), VersionsInfo.class);
    }

    private void defineAllConcepts() throws OntologyException {
        this.definePlatformElementConcept();
        this.definePlatformConcept();
        this.defineHostConcept();
        this.defineContainerConcept();
        this.defineAgentBaseConcept();
        this.defineAgentConcept();
        this.defineAgentPoolConcept();
        this.defineVirtualAgentConcept();
        this.defineAgentArgumentConcept();
        this.defineContainerProfileConcept();
        this.defineContainerProfileProperty();
        this.defineVersionsConcept();
    }

    private void definePlatformElementConcept() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("platformElement");
        conceptSchema.add("errorCode", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
    }

    private void definePlatformConcept() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("platform");
        conceptSchema.addSuperSchema((ConceptSchema)this.getSchema("platformElement"));
        conceptSchema.add("name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("description", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("backupsNumber", (TermSchema)((PrimitiveSchema)this.getSchema("BO_Integer")), 1);
        conceptSchema.add("hosts", (TermSchema)((ConceptSchema)this.getSchema("host")), 0, -1, "set");
        conceptSchema.add("agentPools", (TermSchema)((ConceptSchema)this.getSchema("agentPool")), 0, -1, "set");
        conceptSchema.add("containerProfiles", (TermSchema)((ConceptSchema)this.getSchema("containerProfile")), 0, -1, "set");
    }

    private void defineHostConcept() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("host");
        conceptSchema.addSuperSchema((ConceptSchema)this.getSchema("platformElement"));
        conceptSchema.add("name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("ipAddress", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("availability", (TermSchema)((PrimitiveSchema)this.getSchema("BO_Boolean")));
        conceptSchema.add("reachability", (TermSchema)((PrimitiveSchema)this.getSchema("BO_Boolean")));
        conceptSchema.add("cpuNumber", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("ram", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("adminState", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("benchmarkSpecInt", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("benchmarkWf", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("containers", (TermSchema)((ConceptSchema)this.getSchema("container")), 0, -1, "set");
        conceptSchema.add("backupAllowed", (TermSchema)((PrimitiveSchema)this.getSchema("BO_Boolean")), 1);
    }

    private void defineContainerConcept() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("container");
        conceptSchema.addSuperSchema((ConceptSchema)this.getSchema("platformElement"));
        conceptSchema.add("name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("projectName", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("javaProfile", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("jadeProfile", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("jadeAdditionalArgs", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("agents", (TermSchema)((ConceptSchema)this.getSchema("agent")), 0, -1, "set");
    }

    private void defineAgentBaseConcept() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("agentBase");
        conceptSchema.addSuperSchema((ConceptSchema)this.getSchema("platformElement"));
        conceptSchema.add("name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("type", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("className", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("owner", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("parameters", (TermSchema)((ConceptSchema)this.getSchema("parameter")), 0, -1, "set");
    }

    private void defineAgentConcept() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("agent");
        conceptSchema.addSuperSchema((ConceptSchema)this.getSchema("agentBase"));
    }

    private void defineAgentPoolConcept() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("agentPool");
        conceptSchema.addSuperSchema((ConceptSchema)this.getSchema("agentBase"));
        conceptSchema.add("size", (TermSchema)((PrimitiveSchema)this.getSchema("BO_Integer")));
    }

    private void defineVirtualAgentConcept() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("virtualAgent");
        conceptSchema.addSuperSchema((ConceptSchema)this.getSchema("agent"));
        conceptSchema.add("numberOfReplicas", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("replicationType", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
    }

    private void defineAgentArgumentConcept() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("parameter");
        conceptSchema.addSuperSchema((ConceptSchema)this.getSchema("platformElement"));
        conceptSchema.add("key", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("value", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
    }

    private void defineContainerProfileConcept() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("containerProfile");
        conceptSchema.addSuperSchema((ConceptSchema)this.getSchema("platformElement"));
        conceptSchema.add("name", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("type", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        conceptSchema.add("properties", (TermSchema)((ConceptSchema)this.getSchema("property")), 0, -1, "set");
    }

    private void defineContainerProfileProperty() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("property");
        conceptSchema.addSuperSchema((ConceptSchema)this.getSchema("platformElement"));
        conceptSchema.add("key", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("value", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
    }

    private void defineVersionsConcept() throws OntologyException {
        ConceptSchema conceptSchema = (ConceptSchema)this.getSchema("versions");
        conceptSchema.add("jadeVersion", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("jadeRevision", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("jadeDate", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("wadeVersion", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("wadeRevision", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("wadeDate", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("projectVersion", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("projectRevision", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        conceptSchema.add("projectDate", (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
    }
}

