/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.commons.locale;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class MessageLocalizer {
    private static final String RESOURCE_BUNDLE_BASE_NAME = "locales.language";
    private static ResourceBundle myBundle;

    public static void setLocale(Locale locale) {
        myBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME, locale);
    }

    public static String localize(String msg) {
        if (msg.startsWith("MSGCODE_")) {
            int codeStartIndex = "MSGCODE_".length();
            int codeEndIndex = msg.indexOf("_,_");
            String code = null;
            List params = null;
            if (codeEndIndex < 0) {
                code = msg.substring(codeStartIndex);
            } else {
                code = msg.substring(codeStartIndex, codeEndIndex);
                params = MessageLocalizer.getParams(msg.substring(codeEndIndex + 1));
            }
            try {
                String localizedMsg = myBundle.getString(code);
                if (params != null) {
                    localizedMsg = MessageFormat.format(localizedMsg, params.toArray());
                }
                return localizedMsg;
            }
            catch (Exception e) {
                return msg;
            }
        }
        return msg;
    }

    private static List getParams(String paramsStr) {
        ArrayList<String> l = new ArrayList<String>();
        if (paramsStr != null) {
            StringTokenizer st = new StringTokenizer(paramsStr, "_,_");
            while (st.hasMoreTokens()) {
                l.add(st.nextToken());
            }
        }
        return l;
    }
}

