/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.commons.ontology;

import jade.content.Concept;
import jade.util.leap.List;

public class Attribute
implements Concept {
    public static final int NO_TYPE = 0;
    public static final int STRING_TYPE = 1;
    public static final int INTEGER_TYPE = 2;
    public static final int BOOLEAN_TYPE = 3;
    public static final int DATE_TYPE = 4;
    public static final int FLOAT_TYPE = 5;
    public static final int SERIALIZABLE_TYPE = 6;
    private static final String[] typeNames = new String[]{"NONE", "STRING", "INTEGER", "BOOLEAN", "DATE", "FLOAT", "SERIALIZABLE"};
    private String id;
    private String name;
    private Object value;
    private boolean readOnly = true;
    private Object defaultValue;
    private List permittedValues;
    private int type = 0;

    public static String getTypeName(int type) {
        return typeNames[type];
    }

    public static Object decode(String valueStr, int type) throws FormatException {
        try {
            switch (type) {
                case 1: {
                    return valueStr;
                }
                case 2: {
                    return Long.parseLong(valueStr);
                }
                case 3: {
                    return Boolean.parseBoolean(valueStr);
                }
                case 5: {
                    return Double.parseDouble(valueStr);
                }
            }
            throw new FormatException("Can't handle values of type " + Attribute.getTypeName(type));
        }
        catch (FormatException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FormatException("Value " + valueStr + " cannot be converted into a " + Attribute.getTypeName(type));
        }
    }

    public Attribute() {
    }

    public Attribute(String id, Object value) {
        this.id = id;
        this.value = value;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id != null ? this.id : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name != null ? this.name : this.id;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setPermittedValues(List permittedValues) {
        this.permittedValues = permittedValues;
    }

    public List getPermittedValues() {
        return this.permittedValues;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static class FormatException
    extends Exception {
        public FormatException(String msg) {
            super(msg);
        }
    }
}

