/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.dispatcher;

import com.tilab.wade.dispatcher.WorkflowExecutionException;
import com.tilab.wade.dispatcher.WorkflowLoadException;
import com.tilab.wade.dispatcher.WorkflowNotificationException;
import com.tilab.wade.dispatcher.WorkflowResultListener;
import com.tilab.wade.performer.descriptors.ElementDescriptor;
import com.tilab.wade.performer.ontology.ExecutionError;
import jade.core.AID;
import jade.util.leap.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchWorkflowResultAdapter
implements WorkflowResultListener {
    private List results;
    private WorkflowExecutionException workflowExecutionException;
    private WorkflowLoadException workflowLoadException;
    private WorkflowNotificationException workflowNotificationException;
    private boolean terminated = false;

    @Override
    public void handleAssignedId(AID executor, String executionId) {
    }

    @Override
    public void handleExecutionCompleted(List results, AID executor, String executionId) {
        this.results = results;
        this.setTerminated();
    }

    @Override
    public void handleExecutionError(ExecutionError er, AID executor, String executionId) {
        this.workflowExecutionException = new WorkflowExecutionException(er, executor, executionId);
        this.setTerminated();
    }

    @Override
    public void handleLoadError(String reason) {
        this.workflowLoadException = new WorkflowLoadException(reason);
        this.setTerminated();
    }

    @Override
    public void handleNotificationError(AID executor, String executionId) {
        this.workflowNotificationException = new WorkflowNotificationException(executor, executionId);
        this.setTerminated();
    }

    private synchronized void setTerminated() {
        this.terminated = true;
        this.notifyAll();
    }

    public synchronized Map<String, Object> getWorkflowResult() throws WorkflowExecutionException, WorkflowLoadException, WorkflowNotificationException, InterruptedException {
        return this.getWorkflowResult(0L);
    }

    public synchronized Map<String, Object> getWorkflowResult(long timeout) throws WorkflowExecutionException, WorkflowLoadException, WorkflowNotificationException, InterruptedException {
        return ElementDescriptor.paramListToMap(this.getResult(timeout));
    }

    public synchronized List getResult() throws WorkflowExecutionException, WorkflowLoadException, WorkflowNotificationException, InterruptedException {
        return this.getResult(0L);
    }

    public synchronized List getResult(long timeout) throws WorkflowExecutionException, WorkflowLoadException, WorkflowNotificationException, InterruptedException {
        if (!this.terminated) {
            this.wait(timeout);
            if (!this.terminated) {
                return null;
            }
        }
        if (this.workflowExecutionException != null) {
            throw this.workflowExecutionException;
        }
        if (this.workflowLoadException != null) {
            throw this.workflowLoadException;
        }
        if (this.workflowNotificationException != null) {
            throw this.workflowNotificationException;
        }
        return this.results;
    }
}

