/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.event;

import com.tilab.wade.event.EventOntology;
import com.tilab.wade.event.EventSource;
import com.tilab.wade.event.GenericEvent;
import com.tilab.wade.event.Occurred;
import com.tilab.wade.utils.DFUtils;
import jade.content.ContentElement;
import jade.content.ContentManager;
import jade.content.lang.Codec;
import jade.content.lang.leap.LEAPCodec;
import jade.content.lang.sl.SLCodec;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.wrapper.gateway.DynamicJadeGateway;
import jade.wrapper.gateway.JadeGateway;

public class EventChannel {
    private Connector myConnector;
    private ContentManager myContentManager;
    private EventSource mySource;
    private AID eventSystemAgent;
    private String languageName = "fipa-sl";

    public EventChannel(Agent agent) {
        this.myConnector = new AgentBasedConnector(agent);
        this.initContentManager();
    }

    public EventChannel(DynamicJadeGateway gateway) {
        this.myConnector = new GatewayBasedConnector(gateway);
        this.initContentManager();
    }

    public EventChannel() {
        this(JadeGateway.getDefaultGateway());
    }

    public void setSource(EventSource source) {
        this.mySource = source;
    }

    public void useBinaryEncoding(boolean b) {
        this.languageName = b ? "LEAP" : "fipa-sl";
    }

    public void submitEvent(GenericEvent ev) throws Exception {
        this.myConnector.sendEventMessage(ev);
    }

    private void initContentManager() {
        if (System.getProperty("SL-preserve-java-types") == null) {
            System.setProperty("SL-preserve-java-types", "true");
        }
        this.myContentManager = new ContentManager();
        this.myContentManager.registerLanguage((Codec)new SLCodec(), "fipa-sl");
        this.myContentManager.registerLanguage((Codec)new LEAPCodec());
        this.myContentManager.registerOntology(EventOntology.getInstance());
    }

    private void sendEventMessage(GenericEvent ev, Agent a) throws Exception {
        if (this.eventSystemAgent == null) {
            this.eventSystemAgent = DFUtils.getAID(DFUtils.searchAnyByType(a, "Event System Agent", null));
        }
        ACLMessage msg = new ACLMessage(7);
        msg.addReceiver(this.eventSystemAgent);
        msg.setLanguage(this.languageName);
        msg.setOntology(EventOntology.getInstance().getName());
        msg.addUserDefinedParameter("JADE-ignore-failure", "true");
        Occurred occurred = new Occurred(System.currentTimeMillis(), ev);
        occurred.setSource(this.mySource);
        this.myContentManager.fillContent(msg, (ContentElement)occurred);
        a.send(msg);
    }

    private class SendEventMessageBehaviour
    extends OneShotBehaviour {
        private GenericEvent myEvent;
        private Exception exception;

        SendEventMessageBehaviour(GenericEvent ev) {
            super(null);
            this.myEvent = ev;
        }

        public void action() {
            try {
                EventChannel.this.sendEventMessage(this.myEvent, this.myAgent);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        Exception getException() {
            return this.exception;
        }
    }

    private class GatewayBasedConnector
    implements Connector {
        private DynamicJadeGateway myGateway;

        GatewayBasedConnector(DynamicJadeGateway gateway) {
            this.myGateway = gateway;
        }

        public void sendEventMessage(GenericEvent ev) throws Exception {
            SendEventMessageBehaviour b = new SendEventMessageBehaviour(ev);
            this.myGateway.execute((Object)b);
            Exception exc = b.getException();
            if (exc != null) {
                throw exc;
            }
        }
    }

    private class AgentBasedConnector
    implements Connector {
        private Agent myAgent;

        AgentBasedConnector(Agent a) {
            this.myAgent = a;
        }

        public void sendEventMessage(GenericEvent ev) throws Exception {
            EventChannel.this.sendEventMessage(ev, this.myAgent);
        }
    }

    private static interface Connector {
        public void sendEventMessage(GenericEvent var1) throws Exception;
    }
}

