/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.descriptors;

import com.tilab.wade.performer.descriptors.Wrapper;
import com.tilab.wade.utils.OntologyUtils;
import jade.content.Concept;
import jade.content.abs.AbsObject;
import jade.content.schema.ObjectSchema;

public class Parameter
implements Concept,
Comparable {
    public static final int UNBOUNDED = -1;
    private String name;
    private String documentation;
    private String type;
    private transient Class typeClass;
    private String elementType;
    private transient Class elementTypeClass;
    private ObjectSchema schema;
    private int mode = -1;
    private Object value;
    private Object defaultValue;
    private boolean mandatory = true;
    private String regex;
    private Integer cardMin;
    private Integer cardMax;
    private Object[] permittedValues;

    public Parameter() {
    }

    public Parameter(String name, String type, int mode) {
        this.name = name;
        this.type = type;
        this.mode = mode;
    }

    public Parameter(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public Parameter(Object value) {
        this.value = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Class getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class typeClass) {
        this.typeClass = typeClass;
    }

    public Class getTypeClass(boolean overwrite, ClassLoader cl) throws Exception {
        if (this.typeClass == null || overwrite) {
            this.typeClass = OntologyUtils.getClassByName(this.type, cl);
        }
        return this.typeClass;
    }

    public void setElementType(String elementType) {
        this.elementType = elementType;
    }

    public String getElementType() {
        return this.elementType;
    }

    public Class getElementTypeClass() {
        return this.elementTypeClass;
    }

    public void setElementTypeClass(Class elementTypeClass) {
        this.elementTypeClass = elementTypeClass;
    }

    public Class getElementTypeClass(boolean overwrite, ClassLoader cl) throws Exception {
        if ((this.elementTypeClass == null || overwrite) && this.elementType != null) {
            this.elementTypeClass = OntologyUtils.getClassByName(this.elementType, cl);
        }
        return this.elementTypeClass;
    }

    public ObjectSchema getSchema() {
        return this.schema;
    }

    public void setSchema(ObjectSchema schema) {
        this.schema = schema;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getWrappedValue() {
        if (this.value instanceof AbsObject) {
            return new Wrapper(this.value);
        }
        return this.value;
    }

    public void setWrappedValue(Object obj) {
        this.value = obj instanceof Wrapper ? ((Wrapper)obj).getValue() : obj;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public Integer getCardMin() {
        return this.cardMin;
    }

    public void setCardMin(int cardMin) {
        this.cardMin = cardMin;
    }

    public Integer getCardMax() {
        return this.cardMax;
    }

    public void setCardMax(int cardMax) {
        this.cardMax = cardMax;
    }

    public Object[] getPermittedValues() {
        return this.permittedValues;
    }

    public void setPermittedValues(Object[] permittedValues) {
        this.permittedValues = permittedValues;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public Parameter toActual() {
        return new Parameter(this.name, this.value);
    }

    public String toString() {
        return "Parameter " + (this.name != null ? "name=" + this.name + " " : "") + (this.type != null ? "type=" + this.type + " " : "") + "mode=" + this.mode + " " + (this.value != null ? "value=" + this.value + " " : "");
    }

    public int compareTo(Object obj) {
        return this.name.compareTo(((Parameter)obj).getName());
    }
}

