/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.event;

import com.tilab.wade.event.EventOntology;
import com.tilab.wade.event.Occurred;
import com.tilab.wade.performer.event.WorkflowEvent;
import com.tilab.wade.performer.ontology.ControlInfo;
import com.tilab.wade.performer.ontology.ControlInfoChanges;
import jade.content.ContentElement;
import jade.core.AID;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.List;
import java.io.Serializable;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventEmitter
implements Serializable {
    private transient Agent myAgent;
    private String myId;
    private Hashtable<String, ControlInfo> myControlInfo = new Hashtable();
    private ACLMessage eventMsg = new ACLMessage(7);
    private boolean synchEnabled = true;

    public EventEmitter(Agent agent, String id) {
        this(agent, id, null, null);
    }

    public EventEmitter(Agent agent, String id, String onto, String lang) {
        this.myAgent = agent;
        this.myId = id;
        this.eventMsg.setConversationId(this.myId);
        this.eventMsg.setOntology(onto != null ? onto : EventOntology.getInstance().getName());
        this.eventMsg.setLanguage(lang != null ? lang : "fipa-sl");
        this.eventMsg.addUserDefinedParameter("WADE-event-message", "true");
    }

    public Agent getAgent() {
        return this.myAgent;
    }

    public void setAgent(Agent a) {
        this.myAgent = a;
        this.eventMsg.setSender(a.getAID());
    }

    public String getId() {
        return this.myId;
    }

    public final void setControlInfo(String type, AID controller) {
        ControlInfo cInfo = new ControlInfo(type, controller);
        this.setControlInfo(cInfo);
    }

    public final void setControlInfo(String type, AID controller, int level) {
        ControlInfo cInfo = new ControlInfo(type, controller, level);
        this.setControlInfo(cInfo);
    }

    public final void setControlInfo(List cInfos) {
        this.myControlInfo.clear();
        if (cInfos != null) {
            for (ControlInfo cInfo : cInfos) {
                this.setControlInfo(cInfo);
            }
        }
    }

    public final void setControlInfo(ControlInfo info) {
        Boolean selfConfig = info.getSelfConfig();
        if (selfConfig != null && selfConfig.booleanValue()) {
            this.adjustControlInfo(info);
        }
        this.myControlInfo.put(info.getType(), info);
    }

    public final void updateControlInfo(ControlInfoChanges infoChanges) {
        String type = infoChanges.getType();
        ControlInfo oldCInfo = this.myControlInfo.get(type);
        if (oldCInfo == null) {
            oldCInfo = new ControlInfo();
            oldCInfo.setType(type);
        }
        if (infoChanges.getSynch() != null) {
            oldCInfo.setSynch(infoChanges.getSynch());
        }
        if (infoChanges.getVerbosityLevel() != null) {
            oldCInfo.setVerbosityLevel(infoChanges.getVerbosityLevel());
        }
        if (infoChanges.getSelfConfig() != null) {
            oldCInfo.setSelfConfig(infoChanges.getSelfConfig());
        }
        if (infoChanges.getControllers() != null) {
            oldCInfo.setControllers(infoChanges.getControllers());
        } else {
            List controllersToAdd;
            List oldControllers = oldCInfo.getControllers();
            List controllersToRemove = infoChanges.getControllersToRemove();
            if (oldControllers != null && controllersToRemove != null) {
                for (int i = 0; i < controllersToRemove.size(); ++i) {
                    oldControllers.remove(controllersToRemove.get(i));
                }
            }
            if ((controllersToAdd = infoChanges.getControllersToAdd()) != null) {
                if (oldControllers == null) {
                    oldCInfo.setControllers(controllersToAdd);
                } else {
                    for (int i = 0; i < controllersToAdd.size(); ++i) {
                        AID controller = (AID)controllersToAdd.get(i);
                        if (oldControllers.contains((Object)controller)) continue;
                        oldControllers.add((Object)controller);
                    }
                }
            }
        }
        this.setControlInfo(oldCInfo);
    }

    public final Hashtable<String, ControlInfo> getControlInfo() {
        return this.myControlInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void fireEvent(String type, WorkflowEvent ev, int level) {
        ControlInfo cInfo = this.myControlInfo.get(type);
        if (cInfo == null || cInfo.getVerbosityLevel() < level) return;
        List controllers = cInfo.getControllers();
        if (controllers != null && controllers.size() > 0) {
            long time = System.currentTimeMillis();
            ev = this.customizeEvent(this.myId, time, type, ev, controllers);
            this.eventMsg.clearAllReceiver();
            for (int i = 0; i < controllers.size(); ++i) {
                this.eventMsg.addReceiver((AID)controllers.get(i));
            }
            this.eventMsg.setProtocol(type);
            if (cInfo.getSynch() && this.synchEnabled) {
                this.eventMsg.setReplyWith("synch");
                this.eventMsg.removeUserDefinedParameter("JADE-ignore-failure");
            } else {
                this.eventMsg.setReplyWith(null);
                this.eventMsg.addUserDefinedParameter("JADE-ignore-failure", "true");
            }
            Occurred o = new Occurred(time, ev);
            try {
                if (this.myAgent == null) return;
                this.myAgent.getContentManager().fillContent(this.eventMsg, (ContentElement)o);
                this.myAgent.send(this.eventMsg);
                if (!cInfo.getSynch() || !this.synchEnabled) return;
                for (int i = 0; i < controllers.size(); ++i) {
                    this.myAgent.blockingReceive(MessageTemplate.MatchConversationId((String)this.myId));
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        } else {
            this.handleEvent(this.myId, type, ev);
        }
    }

    public final boolean isFireable(String type, int level) {
        ControlInfo cInfo = this.myControlInfo.get(type);
        if (cInfo != null) {
            return cInfo.getVerbosityLevel() >= level;
        }
        return false;
    }

    public void disableSynchEvents() {
        this.synchEnabled = false;
    }

    public void close() {
        this.eventMsg.setPerformative(2);
        if (this.myAgent != null) {
            Object[] tmp = this.myControlInfo.values().toArray();
            for (int i = 0; i < tmp.length; ++i) {
                ControlInfo cInfo = (ControlInfo)tmp[i];
                List controllers = cInfo.getControllers();
                if (controllers == null || controllers.size() <= 0) continue;
                this.eventMsg.clearAllReceiver();
                for (int j = 0; j < controllers.size(); ++j) {
                    this.eventMsg.addReceiver((AID)controllers.get(j));
                }
                this.eventMsg.setProtocol(cInfo.getType());
                this.eventMsg.setReplyWith(null);
                this.myAgent.send(this.eventMsg);
            }
        }
    }

    protected void adjustControlInfo(ControlInfo cInfo) {
    }

    protected void handleEvent(String id, String type, Object ev) {
    }

    protected WorkflowEvent customizeEvent(String id, long time, String type, WorkflowEvent ev, List controllers) {
        return ev;
    }
}

