/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.interactivity.Component;
import com.tilab.wade.performer.interactivity.ConstraintException;
import com.tilab.wade.performer.interactivity.Panel;
import com.tilab.wade.performer.interactivity.VisualElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Action
extends VisualElement {
    private static final long serialVersionUID = 2169877448335206976L;
    private boolean selected;
    @XmlElementWrapper(name="validateComponents")
    @XmlElement(name="id")
    private List<String> toValidateComponentIds = new ArrayList<String>();
    private boolean validateAllComponents;
    private ActionType type;
    @XmlTransient
    protected Panel mainPanel;

    protected Action() {
    }

    public Action(String label) {
        this(null, label);
    }

    public Action(String id, String label) {
        this.id = id;
        this.label = label;
        this.selected = false;
        this.validateAllComponents = false;
        this.type = ActionType.DEFAULT;
    }

    public ActionType getType() {
        return this.type;
    }

    public void setType(ActionType type) {
        this.type = type;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void requireAllComponentsValidation() {
        this.validateAllComponents = true;
        this.toValidateComponentIds.clear();
    }

    public void addRequireValidationComponent(Component comp) {
        if (comp.getId() != null) {
            this.validateAllComponents = false;
            this.toValidateComponentIds.add(comp.getId());
        }
    }

    public List<Component> getRequireValidationComponents() {
        if (this.validateAllComponents || this.mainPanel == null) {
            return null;
        }
        ArrayList<Component> mandatoryComponents = new ArrayList<Component>();
        for (String id : this.toValidateComponentIds) {
            mandatoryComponents.add(this.mainPanel.getComponent(id));
        }
        return mandatoryComponents;
    }

    public void validate() throws ConstraintException {
        if (this.mainPanel == null) {
            return;
        }
        if (this.validateAllComponents) {
            this.mainPanel.validate();
        } else {
            for (String id : this.toValidateComponentIds) {
                Component comp = this.mainPanel.getComponent(id);
                if (comp == null) continue;
                comp.validate();
            }
        }
    }

    @Override
    void fillCacheData(Map<String, Object> userData) {
    }

    @Override
    void setCacheData(Map<String, Object> userData) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionType {
        DEFAULT,
        ABORT,
        FREEZE,
        CUSTOM;

    }
}

