/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.interactivity.Component;
import com.tilab.wade.performer.interactivity.ConstraintException;
import com.tilab.wade.performer.interactivity.Panel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BorderPanel
extends Panel {
    private static final long serialVersionUID = -5914675143178567957L;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int CENTER = 4;
    private Component northComponent;
    private Component southComponent;
    private Component eastComponent;
    private Component westComponent;
    private Component centerComponent;

    public BorderPanel() {
        this(null);
    }

    public BorderPanel(String id) {
        this.id = id;
    }

    public void setComponent(Component comp, int position) {
        switch (position) {
            case 0: {
                this.northComponent = comp;
                break;
            }
            case 1: {
                this.southComponent = comp;
                break;
            }
            case 2: {
                this.eastComponent = comp;
                break;
            }
            case 3: {
                this.westComponent = comp;
                break;
            }
            case 4: {
                this.centerComponent = comp;
                break;
            }
            default: {
                throw new RuntimeException("Position (" + position + ") not permitted in BorderPanel");
            }
        }
    }

    public Component getComponent(int position) {
        switch (position) {
            case 0: {
                return this.northComponent;
            }
            case 1: {
                return this.southComponent;
            }
            case 2: {
                return this.eastComponent;
            }
            case 3: {
                return this.westComponent;
            }
            case 4: {
                return this.centerComponent;
            }
        }
        throw new RuntimeException("Position (" + position + ") not permitted in BorderPanel");
    }

    @Override
    public List<Component> getComponents() {
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.northComponent != null) {
            components.add(this.northComponent);
        }
        if (this.southComponent != null) {
            components.add(this.southComponent);
        }
        if (this.eastComponent != null) {
            components.add(this.eastComponent);
        }
        if (this.westComponent != null) {
            components.add(this.westComponent);
        }
        if (this.centerComponent != null) {
            components.add(this.centerComponent);
        }
        return components;
    }

    @Override
    public Component getComponent(String id) {
        Component c = this.getComponentById(this.northComponent, id);
        if (c != null) {
            return c;
        }
        c = this.getComponentById(this.southComponent, id);
        if (c != null) {
            return c;
        }
        c = this.getComponentById(this.eastComponent, id);
        if (c != null) {
            return c;
        }
        c = this.getComponentById(this.westComponent, id);
        if (c != null) {
            return c;
        }
        c = this.getComponentById(this.centerComponent, id);
        if (c != null) {
            return c;
        }
        return null;
    }

    @Override
    public void doValidate() throws ConstraintException {
        if (this.northComponent != null) {
            this.northComponent.validate();
        }
        if (this.southComponent != null) {
            this.southComponent.validate();
        }
        if (this.eastComponent != null) {
            this.eastComponent.validate();
        }
        if (this.westComponent != null) {
            this.westComponent.validate();
        }
        if (this.centerComponent != null) {
            this.centerComponent.validate();
        }
    }

    @Override
    public void stamp() {
        if (this.northComponent != null) {
            this.northComponent.stamp();
        }
        if (this.southComponent != null) {
            this.southComponent.stamp();
        }
        if (this.eastComponent != null) {
            this.eastComponent.stamp();
        }
        if (this.westComponent != null) {
            this.westComponent.stamp();
        }
        if (this.centerComponent != null) {
            this.centerComponent.stamp();
        }
    }

    @Override
    void fillCacheData(Map<String, Object> userData) {
        if (this.northComponent != null) {
            this.northComponent.fillCacheData(userData);
        }
        if (this.southComponent != null) {
            this.southComponent.fillCacheData(userData);
        }
        if (this.eastComponent != null) {
            this.eastComponent.fillCacheData(userData);
        }
        if (this.westComponent != null) {
            this.westComponent.fillCacheData(userData);
        }
        if (this.centerComponent != null) {
            this.centerComponent.fillCacheData(userData);
        }
    }

    @Override
    void setCacheData(Map<String, Object> userData) {
        if (this.northComponent != null) {
            this.northComponent.setCacheData(userData);
        }
        if (this.southComponent != null) {
            this.southComponent.setCacheData(userData);
        }
        if (this.eastComponent != null) {
            this.eastComponent.setCacheData(userData);
        }
        if (this.westComponent != null) {
            this.westComponent.setCacheData(userData);
        }
        if (this.centerComponent != null) {
            this.centerComponent.setCacheData(userData);
        }
    }
}

