/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.interactivity.Component;
import com.tilab.wade.performer.interactivity.ConstraintException;
import com.tilab.wade.performer.interactivity.Panel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GridPanel
extends Panel {
    private static final long serialVersionUID = -3516378151658862252L;
    private int rows;
    private int columns;
    private ArrayList<ArrayList<Component>> gridComponents;

    protected GridPanel() {
    }

    public GridPanel(int rows, int columns) {
        this(null, rows, columns);
    }

    public GridPanel(String id, int rows, int columns) {
        this.id = id;
        this.rows = rows;
        this.columns = columns;
        this.gridComponents = new ArrayList(rows);
        for (int r = 0; r < rows; ++r) {
            ArrayList<Object> cols = new ArrayList<Object>(columns);
            for (int c = 0; c < columns; ++c) {
                cols.add(null);
            }
            this.gridComponents.add(cols);
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setComponent(Component comp, int row, int col) {
        this.gridComponents.get(row).set(col, comp);
    }

    public Component getComponent(int row, int col) {
        return this.gridComponents.get(row).get(col);
    }

    @Override
    public List<Component> getComponents() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                Component comp = this.getComponent(r, c);
                if (comp == null) continue;
                components.add(comp);
            }
        }
        return components;
    }

    @Override
    public Component getComponent(String id) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                Component comp = this.getComponentById(this.getComponent(r, c), id);
                if (comp == null) continue;
                return comp;
            }
        }
        return null;
    }

    @Override
    public void doValidate() throws ConstraintException {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                Component comp = this.getComponent(r, c);
                if (comp == null) continue;
                comp.validate();
            }
        }
    }

    @Override
    public void stamp() {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                Component comp = this.getComponent(r, c);
                if (comp == null) continue;
                comp.stamp();
            }
        }
    }

    @Override
    void fillCacheData(Map<String, Object> userData) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                Component comp = this.getComponent(r, c);
                if (comp == null) continue;
                comp.fillCacheData(userData);
            }
        }
    }

    @Override
    void setCacheData(Map<String, Object> userData) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                Component comp = this.getComponent(r, c);
                if (comp == null) continue;
                comp.setCacheData(userData);
            }
        }
    }
}

