/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.interactivity.Calendar;
import com.tilab.wade.performer.interactivity.Component;
import com.tilab.wade.performer.interactivity.Constraint;
import com.tilab.wade.performer.interactivity.ConstraintException;
import com.tilab.wade.performer.interactivity.DisplayResource;
import com.tilab.wade.performer.interactivity.ExclusiveChoice;
import com.tilab.wade.performer.interactivity.Image;
import com.tilab.wade.performer.interactivity.Label;
import com.tilab.wade.performer.interactivity.Map;
import com.tilab.wade.performer.interactivity.MultipleChoice;
import com.tilab.wade.performer.interactivity.PictureCamera;
import com.tilab.wade.performer.interactivity.TextBox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={Calendar.class, DisplayResource.class, ExclusiveChoice.class, Image.class, Label.class, Map.class, MultipleChoice.class, PictureCamera.class, TextBox.class})
public abstract class InformationElement
extends Component {
    @XmlElementWrapper(name="constraints")
    @XmlElement(name="constraint")
    protected ArrayList<Constraint> constraints = new ArrayList();

    protected abstract Object getCacheValue();

    protected abstract void setCacheValue(Object var1);

    protected InformationElement() {
    }

    public InformationElement(String id) {
        this.id = id;
    }

    @Override
    final void fillCacheData(java.util.Map<String, Object> cacheData) {
        if (this.getId() != null) {
            Object cacheValue = this.getCacheValue();
            cacheData.put(this.getId(), cacheValue);
        }
    }

    @Override
    final void setCacheData(java.util.Map<String, Object> cacheData) {
        if (this.getId() != null) {
            try {
                if (cacheData.containsKey(this.getId())) {
                    this.setCacheValue(cacheData.get(this.getId()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public void addConstraint(Constraint constraint) {
        this.addConstraint(constraint, false);
    }

    public void addConstraint(Constraint constraint, boolean override) {
        if (!this.containConstraint(constraint.getClass())) {
            this.constraints.add(constraint);
        } else if (override) {
            this.removeConstraint(constraint.getClass());
            this.constraints.add(constraint);
        }
    }

    public boolean containConstraint(Class constraintClass) {
        for (Constraint constraint : this.constraints) {
            if (constraint.getClass() != constraintClass) continue;
            return true;
        }
        return false;
    }

    public void removeConstraint(Class constraintClass) {
        Iterator<Constraint> it = this.constraints.iterator();
        while (it.hasNext()) {
            Constraint constraint = it.next();
            if (constraint.getClass() != constraintClass) continue;
            it.remove();
        }
    }

    protected void validateConstraints(Object value) throws ConstraintException {
        for (Constraint constraint : this.constraints) {
            constraint.validate(value);
        }
    }
}

