/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.interactivity.Action;
import com.tilab.wade.performer.interactivity.Component;
import com.tilab.wade.performer.interactivity.Panel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Interaction
implements Serializable {
    private static final long serialVersionUID = 3655342160816769261L;
    private String id;
    private String title;
    private boolean last;
    private boolean backEnabled;
    @XmlElementWrapper(name="actions")
    @XmlElement(name="action")
    private List<Action> actions = new ArrayList<Action>();
    private Panel mainPanel;

    public Interaction() {
        this(null, null);
    }

    public Interaction(String title) {
        this(null, title);
    }

    public Interaction(String id, String title) {
        this.id = id;
        this.title = title;
        this.last = false;
        this.setBackEnabled(false);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public void setBackEnabled(boolean backEnabled) {
        this.backEnabled = backEnabled;
    }

    public boolean isBackEnabled() {
        return this.backEnabled;
    }

    public void addAction(Action action) {
        action.mainPanel = this.mainPanel;
        this.actions.add(action);
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public Action getAction(String id) {
        for (Action action : this.actions) {
            String actId = action.getId();
            if (actId == null || !actId.equals(id)) continue;
            return action;
        }
        return null;
    }

    public Action getSelectedAction() {
        for (Action action : this.actions) {
            if (!action.isSelected()) continue;
            return action;
        }
        return null;
    }

    public Panel getMainPanel() {
        return this.mainPanel;
    }

    public void setMainPanel(Panel mainPanel) {
        this.mainPanel = mainPanel;
        for (Action action : this.actions) {
            action.mainPanel = mainPanel;
        }
    }

    public Component getComponent(String id) {
        if (this.mainPanel != null) {
            return this.mainPanel.getComponent(id);
        }
        return null;
    }

    public void stamp() {
        if (this.mainPanel != null) {
            this.mainPanel.stamp();
        }
    }

    public Map<String, Object> getCacheData() {
        HashMap<String, Object> cacheDataMap = new HashMap<String, Object>();
        if (this.mainPanel != null) {
            this.mainPanel.fillCacheData(cacheDataMap);
        }
        return cacheDataMap;
    }

    public void setCacheData(Map<String, Object> userDataMap) {
        if (userDataMap != null && this.mainPanel != null) {
            this.mainPanel.setCacheData(userDataMap);
        }
    }
}

