/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.interactivity.ConstraintException;
import com.tilab.wade.performer.interactivity.ConstraintImpl;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsVariable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PermittedValuesConstraint
extends ConstraintImpl {
    private static final long serialVersionUID = -4955595263385438987L;
    private Object[] permittedValues;

    protected PermittedValuesConstraint() {
    }

    public PermittedValuesConstraint(Object[] permittedValues) {
        this.permittedValues = permittedValues;
    }

    public Object[] getPermittedValues() {
        return this.permittedValues;
    }

    public String getPermittedValuesString() {
        StringBuilder sb = new StringBuilder();
        if (this.permittedValues != null) {
            for (int i = 0; i < this.permittedValues.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(this.permittedValues[i]);
            }
        }
        return sb.toString();
    }

    public void validate(Object value) throws ConstraintException {
        if (this.permittedValues == null) {
            return;
        }
        Object oValue = value instanceof AbsPrimitive ? ((AbsPrimitive)value).getObject() : (value instanceof AbsVariable ? null : value);
        if (oValue != null) {
            for (int i = 0; i < this.permittedValues.length; ++i) {
                if (!oValue.equals(this.permittedValues[i])) continue;
                return;
            }
            throw new ConstraintException("Permitted values violated, value=" + oValue + ", expected values=" + this.getPermittedValuesString(), this);
        }
    }
}

