/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.interactivity.ConstraintException;
import com.tilab.wade.performer.interactivity.Image;
import com.tilab.wade.performer.interactivity.Map;
import com.tilab.wade.performer.interactivity.PermittedValuesConstraint;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Position
extends Map {
    private static final long serialVersionUID = 4467886152512749472L;
    private static final double INVALID_VALUE = Double.NEGATIVE_INFINITY;
    private double longitude;
    private double latitude;
    private double altitude;
    private double accuracy;
    private boolean valid;
    private Image positionMarker;

    protected Position() {
    }

    public Position(String id, Image positionMarker, Image defaultMarker) {
        super(id, defaultMarker);
        this.positionMarker = positionMarker;
        this.accuracy = Double.NEGATIVE_INFINITY;
        this.altitude = Double.NEGATIVE_INFINITY;
        this.longitude = Double.NEGATIVE_INFINITY;
        this.latitude = Double.NEGATIVE_INFINITY;
        this.addConstraint(new PermittedValuesConstraint(new Object[]{Boolean.TRUE}));
    }

    public Image getPositionMarker() {
        return this.positionMarker;
    }

    public void setPositionMarker(Image positionMarker) {
        this.positionMarker = positionMarker;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
        this.checkValid();
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
        this.checkValid();
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
        this.checkValid();
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(double accuracy) {
        this.accuracy = accuracy;
        this.checkValid();
    }

    protected void checkValid() {
        this.valid = this.longitude != Double.NEGATIVE_INFINITY && this.latitude != Double.NEGATIVE_INFINITY && this.altitude != Double.NEGATIVE_INFINITY && this.accuracy != Double.NEGATIVE_INFINITY;
    }

    public void doValidate() throws ConstraintException {
        this.validateConstraints(this.valid);
    }

    public void stamp() {
        super.stamp();
        this.positionMarker = null;
    }

    protected Object getCacheValue() {
        return new Object[]{super.getCacheValue(), this.longitude, this.latitude, this.altitude, this.accuracy, this.valid};
    }

    protected void setCacheValue(Object value) {
        Object[] cache = (Object[])value;
        super.setCacheValue(cache[0]);
        this.longitude = (Double)cache[1];
        this.latitude = (Double)cache[2];
        this.altitude = (Double)cache[3];
        this.accuracy = (Double)cache[4];
        this.valid = (Boolean)cache[5];
    }
}

