/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.interactivity.CardinalityConstraint;
import com.tilab.wade.performer.interactivity.ConstrainedAbsConcept;
import com.tilab.wade.performer.interactivity.Constraint;
import com.tilab.wade.performer.interactivity.ConstraintException;
import com.tilab.wade.performer.interactivity.DefaultConstraint;
import com.tilab.wade.performer.interactivity.DocumentationConstraint;
import com.tilab.wade.performer.interactivity.InformationElement;
import com.tilab.wade.performer.interactivity.MandatoryConstraint;
import com.tilab.wade.performer.interactivity.OptionalityConstraint;
import com.tilab.wade.performer.interactivity.PermittedValuesConstraint;
import com.tilab.wade.performer.interactivity.RegexConstraint;
import com.tilab.wade.performer.interactivity.TypeConstraint;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.onto.OntologyException;
import jade.content.schema.AggregateSchema;
import jade.content.schema.Facet;
import jade.content.schema.ObjectSchema;
import jade.content.schema.TermSchema;
import jade.content.schema.facets.CardinalityFacet;
import jade.content.schema.facets.DefaultValueFacet;
import jade.content.schema.facets.DocumentationFacet;
import jade.content.schema.facets.PermittedValuesFacet;
import jade.content.schema.facets.RegexFacet;
import java.util.ArrayList;
import java.util.List;

public class StructuredDataElement
extends InformationElement {
    private static final long serialVersionUID = 2279945410133843228L;
    private AbsObject value;
    private boolean rootRemoved = false;
    private boolean editable = true;

    protected StructuredDataElement() {
    }

    public StructuredDataElement(String id) {
        super(id);
    }

    public StructuredDataElement(String id, AbsObject value) throws OntologyException {
        this(id);
        this.setValue(value);
    }

    public StructuredDataElement(String id, ObjectSchema schema) throws OntologyException {
        this(id);
        AbsObject templateValue = AbsHelper.createAbsTemplate((ObjectSchema)schema);
        this.setValue(templateValue);
        this.addNodeConstraints(schema);
    }

    public StructuredDataElement(String id, Parameter parameter) throws OntologyException {
        this(id);
        ObjectSchema schema = parameter.getSchema();
        if (schema == null) {
            throw new OntologyException("Schema not definited in parameter " + parameter.getName());
        }
        AbsObject templateValue = AbsHelper.createAbsTemplate((ObjectSchema)schema);
        this.setValue(templateValue);
        this.addNodeConstraints(schema);
        this.addConstraints(parameter);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public AbsObject getValue() {
        return this.value;
    }

    public void setValue(AbsObject value) {
        this.value = value;
        this.constraints.clear();
    }

    public void addNodeConstraints(ObjectSchema schema) throws OntologyException {
        this.value = StructuredDataElement.getConstrainedValue(this.value, schema, this.editable);
    }

    public void addConstraints(Parameter parameter) {
        String documentation;
        this.constraints.clear();
        boolean mandatory = parameter.getMandatory();
        if (this.editable && this.value != null) {
            if (this.value instanceof AbsVariable) {
                if (mandatory) {
                    this.constraints.add(new MandatoryConstraint());
                }
            } else if (!mandatory) {
                this.constraints.add(new OptionalityConstraint());
            }
        }
        if (this.value != null) {
            AbsAggregate aggValue;
            AbsTerm aggElementValue;
            if (this.value instanceof AbsVariable) {
                AbsVariable varValue = (AbsVariable)this.value;
                this.constraints.add(new TypeConstraint(varValue.getType()));
            } else if (this.value instanceof AbsAggregate && (aggElementValue = (aggValue = (AbsAggregate)this.value).getElementTemplate()) instanceof AbsVariable) {
                this.constraints.add(new TypeConstraint(((AbsVariable)aggElementValue).getType()));
            }
        }
        Object defaultValue = parameter.getDefaultValue();
        if (this.editable && defaultValue != null) {
            this.constraints.add(new DefaultConstraint(defaultValue));
        }
        String regex = parameter.getRegex();
        if (this.editable && regex != null) {
            this.constraints.add(new RegexConstraint(regex));
        }
        if ((documentation = parameter.getDocumentation()) != null) {
            this.constraints.add(new DocumentationConstraint(documentation));
        }
        Object[] permittedValues = parameter.getPermittedValues();
        if (this.editable && permittedValues != null && permittedValues.length > 0) {
            this.constraints.add(new PermittedValuesConstraint(permittedValues));
        }
        Integer cardMin = parameter.getCardMin();
        Integer cardMax = parameter.getCardMax();
        if (this.editable && cardMin != null && cardMax != null) {
            this.constraints.add(new CardinalityConstraint(cardMin, cardMax));
        }
    }

    public void markToBeRemove(boolean remove) {
        if (this.editable) {
            this.rootRemoved = remove;
        }
    }

    public void markToBeRemove(String part, boolean remove) throws OntologyException {
        AbsObject internalAbs;
        if (part == null || "".equals(part)) {
            this.markToBeRemove(remove);
        } else if (this.value != null && (internalAbs = this.convertIntoConstrainedAbsObject(part)) instanceof ConstrainedAbsConcept) {
            ConstrainedAbsConcept cac = (ConstrainedAbsConcept)internalAbs;
            cac.markToBeRemove(this.getSlot(part), remove);
        }
    }

    public boolean isToBeRemove() {
        return this.rootRemoved;
    }

    public void stamp() {
        if (this.editable) {
            if (this.rootRemoved) {
                this.value = null;
            } else {
                this.stamp(this.value);
            }
        }
    }

    private void stamp(AbsObject value) {
        if (value == null || value instanceof AbsVariable) {
            return;
        }
        String[] slotNames = value.getNames();
        if (slotNames == null) {
            return;
        }
        ConstrainedAbsConcept cac = null;
        if (value instanceof ConstrainedAbsConcept) {
            cac = (ConstrainedAbsConcept)value;
        }
        for (String slotName : value.getNames()) {
            if (cac != null && cac.isToBeRemove(slotName)) {
                cac.set(slotName, null);
                continue;
            }
            AbsObject slotValue = value.getAbsObject(slotName);
            this.stamp(slotValue);
        }
    }

    public void doValidate() throws ConstraintException {
        AbsObject valueToValidate = this.value;
        if (this.rootRemoved) {
            valueToValidate = null;
        }
        this.validateConstraints(valueToValidate);
        this.validate(valueToValidate);
    }

    private void validate(AbsObject value) throws ConstraintException {
        if (value == null || value instanceof AbsVariable) {
            return;
        }
        String[] slotNames = value.getNames();
        if (slotNames == null) {
            return;
        }
        ConstrainedAbsConcept cac = null;
        if (value instanceof ConstrainedAbsConcept) {
            cac = (ConstrainedAbsConcept)value;
        }
        for (String slotName : value.getNames()) {
            List<Constraint> nodeConstraints;
            AbsObject slotValue = value.getAbsObject(slotName);
            boolean slotRemoved = false;
            if (cac != null && !(slotRemoved = cac.isToBeRemove(slotName)) && (nodeConstraints = cac.getConstraints(slotName)) != null) {
                for (Constraint nodeConstraint : nodeConstraints) {
                    nodeConstraint.validate(slotValue);
                }
            }
            if (slotRemoved) continue;
            this.validate(slotValue);
        }
    }

    private static AbsObject getConstrainedValue(AbsObject value, ObjectSchema schema, boolean editable) throws OntologyException {
        Object constrainedValue = value;
        if (value != null) {
            if (value instanceof AbsAggregate) {
                AbsAggregate aggValue = (AbsAggregate)value;
                AbsTerm aggElementValue = aggValue.getElementTemplate();
                AggregateSchema aggSchema = (AggregateSchema)schema;
                TermSchema aggElementSchema = aggSchema.getElementsSchema();
                if (aggElementValue != null && aggElementSchema != null) {
                    aggValue.setElementTemplate((AbsTerm)StructuredDataElement.getConstrainedValue((AbsObject)aggElementValue, (ObjectSchema)aggElementSchema, editable));
                }
            } else if (value instanceof AbsConcept) {
                String typeName = value.getTypeName();
                constrainedValue = new ConstrainedAbsConcept(typeName);
                String[] slotNames = value.getNames();
                if (slotNames != null) {
                    for (String slotName : value.getNames()) {
                        AbsObject slotValue = value.getAbsObject(slotName);
                        ObjectSchema slotSchema = schema.getSchema(slotName);
                        AbsObject slotConstrainedValue = StructuredDataElement.getConstrainedValue(slotValue, slotSchema, editable);
                        boolean slotMandatory = schema.isMandatory(slotName);
                        if (slotValue instanceof AbsVariable) {
                            DocumentationFacet documentationFacet;
                            String slotTypeName = schema.getSchema(slotName).getTypeName();
                            StructuredDataElement.addSlotConstraint(constrainedValue, slotName, new TypeConstraint(slotTypeName));
                            if (editable && slotMandatory) {
                                StructuredDataElement.addSlotConstraint(constrainedValue, slotName, new MandatoryConstraint());
                            }
                            DefaultValueFacet defaultValueFacet = (DefaultValueFacet)StructuredDataElement.getFacet(schema, slotName, DefaultValueFacet.class);
                            if (editable && defaultValueFacet != null) {
                                StructuredDataElement.addSlotConstraint(constrainedValue, slotName, new DefaultConstraint(defaultValueFacet.getDefaultValue()));
                            }
                            RegexFacet regexFacet = (RegexFacet)StructuredDataElement.getFacet(schema, slotName, RegexFacet.class);
                            if (editable && regexFacet != null) {
                                StructuredDataElement.addSlotConstraint(constrainedValue, slotName, new RegexConstraint(regexFacet.getRegex()));
                            }
                            if ((documentationFacet = (DocumentationFacet)StructuredDataElement.getFacet(schema, slotName, DocumentationFacet.class)) != null) {
                                StructuredDataElement.addSlotConstraint(constrainedValue, slotName, new DocumentationConstraint(documentationFacet.getDocumentation()));
                            }
                            PermittedValuesFacet permittedValuesFacet = (PermittedValuesFacet)StructuredDataElement.getFacet(schema, slotName, PermittedValuesFacet.class);
                            if (editable && permittedValuesFacet != null) {
                                StructuredDataElement.addSlotConstraint(constrainedValue, slotName, new PermittedValuesConstraint(permittedValuesFacet.getPermittedValues()));
                            }
                        } else {
                            if (editable && !slotMandatory) {
                                StructuredDataElement.addSlotConstraint(constrainedValue, slotName, new OptionalityConstraint());
                            }
                            if (slotValue instanceof AbsAggregate) {
                                AbsAggregate aggValue;
                                AbsTerm aggElementValue;
                                CardinalityFacet cardinalityFacet = (CardinalityFacet)StructuredDataElement.getFacet(schema, slotName, CardinalityFacet.class);
                                if (editable && cardinalityFacet != null) {
                                    StructuredDataElement.addSlotConstraint(constrainedValue, slotName, new CardinalityConstraint(cardinalityFacet.getCardMin(), cardinalityFacet.getCardMax()));
                                }
                                if ((aggElementValue = (aggValue = (AbsAggregate)slotValue).getElementTemplate()) instanceof AbsVariable) {
                                    StructuredDataElement.addSlotConstraint(constrainedValue, slotName, new TypeConstraint(((AbsVariable)aggElementValue).getType()));
                                }
                            }
                        }
                        ((ConstrainedAbsConcept)((Object)constrainedValue)).set(slotName, slotConstrainedValue);
                    }
                }
            }
        }
        return constrainedValue;
    }

    private static void addSlotConstraint(AbsObject constrainedValue, String slotName, Constraint constraint) {
        ((ConstrainedAbsConcept)constrainedValue).addConstraint(slotName, constraint);
    }

    public void addConstraint(Constraint constraint, String part) throws OntologyException {
        this.addConstraint(constraint, part, false);
    }

    public void addConstraint(Constraint constraint, String part, boolean override) throws OntologyException {
        AbsObject internalAbs;
        if (part == null || "".equals(part)) {
            this.addConstraint(constraint, override);
        } else if (this.value != null && (internalAbs = this.convertIntoConstrainedAbsObject(part)) instanceof ConstrainedAbsConcept) {
            ConstrainedAbsConcept cac = (ConstrainedAbsConcept)internalAbs;
            cac.addConstraint(this.getSlot(part), constraint, override);
        }
    }

    private String getSlot(String part) {
        String[] slots = this.splitPart(part);
        return slots[slots.length - 1];
    }

    private String[] splitPart(String part) {
        part = part.replaceAll("_JADE.UNNAMED", "_JADE-UNNAMED");
        String[] slots = part.split("\\.");
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = slots[i].replaceAll("_JADE-UNNAMED", "_JADE.UNNAMED");
        }
        return slots;
    }

    private AbsObject convertIntoConstrainedAbsObject(String part) throws OntologyException {
        String[] slots = this.splitPart(part);
        AbsObject internalSuperAbs = null;
        String superSlotName = null;
        Object internalAbs = this.value;
        for (int i = 0; i < slots.length - 1; ++i) {
            internalSuperAbs = internalAbs;
            superSlotName = slots[i];
            if ((internalAbs = internalAbs.getAbsObject(slots[i])) != null) continue;
            throw new OntologyException("Slot " + slots[i] + " is not present in abs value " + this.value);
        }
        if (!(internalAbs instanceof ConstrainedAbsConcept) && internalAbs instanceof AbsConcept) {
            String typeName = internalAbs.getTypeName();
            ConstrainedAbsConcept constrainedInternalAbs = new ConstrainedAbsConcept(typeName);
            String[] slotNames = internalAbs.getNames();
            if (slotNames != null) {
                for (String slotName : internalAbs.getNames()) {
                    constrainedInternalAbs.set(slotName, internalAbs.getAbsObject(slotName));
                }
            }
            internalAbs = constrainedInternalAbs;
            if (internalSuperAbs != null) {
                ((AbsConcept)internalSuperAbs).set(superSlotName, (AbsTerm)constrainedInternalAbs);
            } else {
                this.value = constrainedInternalAbs;
            }
        }
        return internalAbs;
    }

    private static Facet getFacet(ObjectSchema schema, String slotName, Class facetClass) {
        Facet[] slotFacets = schema.getFacets(slotName);
        if (slotFacets != null) {
            for (Facet f : slotFacets) {
                if (f.getClass() != facetClass) continue;
                return f;
            }
        }
        return null;
    }

    public void showValue() {
        StructuredDataElement.showValue(this, this.getValue(), this.label != null ? this.label : this.id, 0);
    }

    private static void showValue(Object parent, AbsObject value, String name, int currentLevel) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (!(value instanceof AbsVariable)) break block2;
                        StructuredDataElement.writeLine("-" + name + " = ? " + StructuredDataElement.getConstaints(parent, name), currentLevel);
                        break block3;
                    }
                    if (!(value instanceof AbsPrimitive)) break block4;
                    StructuredDataElement.writeLine("-" + name + " = " + value, currentLevel);
                    break block3;
                }
                if (!(value instanceof AbsAggregate)) break block5;
                AbsAggregate agg = (AbsAggregate)value;
                StructuredDataElement.writeLine("[]" + name + " " + StructuredDataElement.getConstaints(parent, name), currentLevel);
                StructuredDataElement.showValue(value, (AbsObject)agg.getElementTemplate(), "elementType (" + agg.getElementTemplate().getTypeName() + ")", currentLevel + 1);
                for (int i = 0; i < agg.size(); ++i) {
                    StructuredDataElement.showValue(value, (AbsObject)agg.get(i), "#" + i, currentLevel + 1);
                }
                break block3;
            }
            if (!(value instanceof AbsConcept)) break block3;
            StructuredDataElement.writeLine("+" + name + " " + StructuredDataElement.getConstaints(parent, name), currentLevel);
            for (String slot : value.getNames()) {
                StructuredDataElement.showValue(value, value.getAbsObject(slot), slot, currentLevel + 1);
            }
        }
    }

    private static String getConstaints(Object parent, String name) {
        String consts;
        List<Object> constraints = new ArrayList();
        if (parent instanceof StructuredDataElement) {
            constraints = ((StructuredDataElement)parent).getConstraints();
        } else if (parent instanceof ConstrainedAbsConcept) {
            constraints = ((ConstrainedAbsConcept)((Object)parent)).getConstraints(name);
        }
        StringBuilder sb = new StringBuilder();
        if (constraints != null) {
            for (Constraint constraint : constraints) {
                if (constraint instanceof TypeConstraint) {
                    StructuredDataElement.addToConstaintsList(sb, ((TypeConstraint)constraint).getType());
                    continue;
                }
                if (constraint instanceof MandatoryConstraint) {
                    StructuredDataElement.addToConstaintsList(sb, "MAN");
                    continue;
                }
                if (constraint instanceof OptionalityConstraint) {
                    StructuredDataElement.addToConstaintsList(sb, "OPT");
                    continue;
                }
                if (constraint instanceof DefaultConstraint) {
                    StructuredDataElement.addToConstaintsList(sb, "def=" + ((DefaultConstraint)constraint).getValue());
                    continue;
                }
                if (constraint instanceof PermittedValuesConstraint) {
                    StructuredDataElement.addToConstaintsList(sb, "values={" + ((PermittedValuesConstraint)constraint).getPermittedValuesString() + "}");
                    continue;
                }
                if (constraint instanceof RegexConstraint) {
                    StructuredDataElement.addToConstaintsList(sb, "rgx=" + ((RegexConstraint)constraint).getRegex());
                    continue;
                }
                if (constraint instanceof DocumentationConstraint) {
                    StructuredDataElement.addToConstaintsList(sb, "doc=" + ((DocumentationConstraint)constraint).getDocumentation());
                    continue;
                }
                if (!(constraint instanceof CardinalityConstraint)) continue;
                int min = ((CardinalityConstraint)constraint).getMin();
                int max = ((CardinalityConstraint)constraint).getMax();
                StructuredDataElement.addToConstaintsList(sb, "[" + min + "," + (max == -1 ? "unbounded" : Integer.valueOf(max)) + "]");
            }
        }
        if ((consts = sb.toString()).length() > 0) {
            consts = "(" + consts + ")";
        }
        return consts;
    }

    private static void addToConstaintsList(StringBuilder sb, String text) {
        if (sb.length() != 0) {
            sb.append(", ");
        }
        sb.append(text);
    }

    private static void writeLine(String text, int indentLevel) {
        if (text != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append(text);
            System.out.println(sb.toString());
        }
    }

    protected Object getCacheValue() {
        return this.getValue();
    }

    protected void setCacheValue(Object cacheValueObj) {
        try {
            this.manageCachedValues(null, this.getValue(), (AbsObject)cacheValueObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void manageCachedValues(String part, AbsObject currentValue, AbsObject cacheValue) throws OntologyException {
        block12: {
            block11: {
                if (currentValue == null) {
                    return;
                }
                if (cacheValue == null) {
                    this.markToBeRemove(part, true);
                    return;
                }
                if (!(currentValue instanceof AbsVariable)) break block11;
                if (!(cacheValue instanceof AbsPrimitive)) break block12;
                this.addConstraint(new DefaultConstraint(((AbsPrimitive)cacheValue).getObject()), part, true);
                break block12;
            }
            if (currentValue instanceof AbsAggregate) {
                AbsAggregate currentAggregate = (AbsAggregate)currentValue;
                String[] arr$ = cacheValue.getNames();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    AbsObject slotAbsObject;
                    String slotName;
                    String newPart = slotName = arr$[i$];
                    if (part != null) {
                        newPart = part + "." + newPart;
                    }
                    try {
                        slotAbsObject = currentValue.getAbsObject(slotName);
                    }
                    catch (IndexOutOfBoundsException e) {
                        currentAggregate.add(currentAggregate.getElementTemplate());
                        slotAbsObject = currentValue.getAbsObject(slotName);
                    }
                    this.manageCachedValues(newPart, slotAbsObject, cacheValue.getAbsObject(slotName));
                }
            } else if (currentValue instanceof AbsConcept) {
                String[] arr$ = currentValue.getNames();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String slotName;
                    String newPart = slotName = arr$[i$];
                    if (part != null) {
                        newPart = part + "." + newPart;
                    }
                    this.manageCachedValues(newPart, currentValue.getAbsObject(slotName), cacheValue.getAbsObject(slotName));
                }
            }
        }
    }
}

