/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.interactivity.Component;
import com.tilab.wade.performer.interactivity.ConstraintException;
import com.tilab.wade.performer.interactivity.Panel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TabelPanel
extends Panel {
    private static final long serialVersionUID = 2296784780368694737L;
    private int columns;
    @XmlElementWrapper(name="tableElements")
    @XmlElement(name="tableElement")
    private List<TableElement> tableElements = new ArrayList<TableElement>();

    protected TabelPanel() {
    }

    public TabelPanel(int columns) {
        this(null, columns);
    }

    public TabelPanel(String id, int columns) {
        this.id = id;
        this.columns = columns;
    }

    public int getColumns() {
        return this.columns;
    }

    public void addTableElement(Component comp, String title, int colSpan, int rowSpan) {
        TableElement te = new TableElement(comp, title, colSpan, rowSpan);
        this.tableElements.add(te);
    }

    public List<TableElement> getTableElements() {
        return this.tableElements;
    }

    @Override
    public List<Component> getComponents() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (TableElement te : this.tableElements) {
            components.add(te.getComponent());
        }
        return components;
    }

    @Override
    public Component getComponent(String id) {
        for (TableElement te : this.tableElements) {
            Component c = this.getComponentById(te.getComponent(), id);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    @Override
    public void doValidate() throws ConstraintException {
        for (TableElement te : this.tableElements) {
            te.getComponent().validate();
        }
    }

    @Override
    public void stamp() {
        for (TableElement te : this.tableElements) {
            te.getComponent().stamp();
        }
    }

    @Override
    void fillCacheData(Map<String, Object> userData) {
        for (TableElement te : this.tableElements) {
            te.getComponent().fillCacheData(userData);
        }
    }

    @Override
    void setCacheData(Map<String, Object> userData) {
        for (TableElement te : this.tableElements) {
            te.getComponent().setCacheData(userData);
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public class TableElement {
        private int colSpan;
        private int rowSpan;
        private String title;
        private Component comp;

        public TableElement(Component comp, String title, int colSpan, int rowSpan) {
            this.comp = comp;
            this.title = title;
            this.colSpan = colSpan;
            this.rowSpan = rowSpan;
        }

        public int getColSpan() {
            return this.colSpan;
        }

        public int getRowSpan() {
            return this.rowSpan;
        }

        public String getTitle() {
            return this.title;
        }

        public Component getComponent() {
            return this.comp;
        }
    }
}

