/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.interactivity.ConstraintException;
import com.tilab.wade.performer.interactivity.ConstraintImpl;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.onto.BasicOntology;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TypeConstraint
extends ConstraintImpl {
    private static final long serialVersionUID = -1589645067599127330L;
    private static Map<String, Class> typesMap = new HashMap<String, Class>();
    private String type;

    protected TypeConstraint() {
    }

    public TypeConstraint(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void validate(Object value) throws ConstraintException {
        if (value instanceof AbsAggregate) {
            AbsAggregate absAggregate = (AbsAggregate)value;
            for (String aggSlotName : absAggregate.getNames()) {
                this.validate(absAggregate.getAbsObject(aggSlotName));
            }
            return;
        }
        if ("Term".equalsIgnoreCase(this.type)) {
            return;
        }
        if (value instanceof AbsPrimitive) {
            AbsPrimitive absPrimitive = (AbsPrimitive)value;
            if (!absPrimitive.getTypeName().equalsIgnoreCase(this.type)) {
                throw new ConstraintException("Type violated, value type=" + absPrimitive.getTypeName() + ", expected type=" + this.type, this);
            }
            return;
        }
        if (value != null && !AbsObject.class.isAssignableFrom(value.getClass())) {
            Class clazz = typesMap.get(this.type);
            Object adjustedvalue = BasicOntology.adjustPrimitiveValue((Object)value, (Class)clazz);
            if (adjustedvalue.getClass() != clazz) {
                throw new ConstraintException("Type violated, value class=" + clazz.getName() + ", expected type=" + this.type, this);
            }
            return;
        }
    }

    static {
        typesMap.put("BO_String", String.class);
        typesMap.put("BO_Float", Double.class);
        typesMap.put("BO_Integer", Long.class);
        typesMap.put("BO_Boolean", Boolean.class);
        typesMap.put("BO_Date", Date.class);
        typesMap.put("BO_Byte-sequence", byte[].class);
    }
}

