/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.proxy;

import com.tilab.wade.ca.ontology.WorkflowDetails;
import com.tilab.wade.dispatcher.WorkflowEventListener;
import com.tilab.wade.dispatcher.WorkflowResultListener;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import com.tilab.wade.performer.interactivity.ontology.InteractivityOntology;
import com.tilab.wade.performer.ontology.WorkflowManagementOntology;
import com.tilab.wade.proxy.EngineProxyException;
import com.tilab.wade.proxy.EngineProxyHandlers;
import com.tilab.wade.proxy.EventGenerationConfiguration;
import com.tilab.wade.proxy.GetExecutionBehaviour;
import com.tilab.wade.proxy.GetPendingExecutionsBehaviour;
import com.tilab.wade.proxy.GetSerializedStateBehaviour;
import com.tilab.wade.proxy.GetSessionExecutionsBehaviour;
import com.tilab.wade.proxy.GetWorkflowParametersBehaviour;
import com.tilab.wade.proxy.GetWorkflowsBehaviour;
import com.tilab.wade.proxy.KillWorkflowBehaviour;
import com.tilab.wade.proxy.QueryExecutionsBehaviour;
import com.tilab.wade.proxy.RemoveExecutionBehaviour;
import com.tilab.wade.proxy.SetExecutionStatusBehaviour;
import com.tilab.wade.proxy.WorkflowContext;
import com.tilab.wade.proxy.WorkflowController;
import com.tilab.wade.proxy.WorkflowLauncherBehaviour;
import com.tilab.wade.proxy.WorkflowManagementBehaviour;
import com.tilab.wade.proxy.WorkflowRecoverBehaviour;
import com.tilab.wade.proxy.WorkflowThawBehaviour;
import com.tilab.wade.utils.GUIDGenerator;
import com.tilab.wade.wsma.ontology.WorkflowExecutionInfo;
import jade.content.lang.Codec;
import jade.content.lang.leap.LEAPCodec;
import jade.content.lang.sl.SLCodec;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.util.Logger;
import jade.wrapper.gateway.DynamicJadeGateway;
import jade.wrapper.gateway.GatewayAgent;
import jade.wrapper.gateway.GatewayListener;
import jade.wrapper.gateway.JadeGateway;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineProxy
implements GatewayListener {
    private static final String DEFAULT_WORKFLOW_ID = "UNKNOWN";
    private static final long MAX_PROXY_STARTUP_TIME = 5000L;
    private static final long CLEAN_SESSION_PERIOD = 300000L;
    private static final long COMMAND_DEFAULT_TIMEOUT = 0L;
    private static Logger myLogger = Logger.getMyLogger((String)EngineProxy.class.getName());
    private static Map<DynamicJadeGateway, EngineProxy> engineProxies = new HashMap<DynamicJadeGateway, EngineProxy>();
    private DFAgentDescription executorTemplate;
    private Map<String, WorkflowController> controllers = new HashMap<String, WorkflowController>();
    private List<AID> executors;
    private int currentExecutorIndex = 0;
    private boolean proxyActive = false;
    private EngineProxyHandlers engineProxyHandlers;
    DynamicJadeGateway dynamicJadeGateway;
    private boolean customExecutors;

    public static synchronized EngineProxy getEngineProxy() {
        return EngineProxy.getEngineProxy(null, null, null);
    }

    public static synchronized EngineProxy getEngineProxy(DynamicJadeGateway djg) {
        return EngineProxy.getEngineProxy(djg, null, null);
    }

    public static synchronized EngineProxy getEngineProxy(DFAgentDescription executorTemplate) {
        return EngineProxy.getEngineProxy(null, executorTemplate, null);
    }

    public static synchronized EngineProxy getEngineProxy(List<AID> executors) {
        return EngineProxy.getEngineProxy(null, null, executors);
    }

    public static synchronized EngineProxy getEngineProxy(DynamicJadeGateway djg, DFAgentDescription executorTemplate) {
        return EngineProxy.getEngineProxy(djg, executorTemplate, null);
    }

    public static synchronized EngineProxy getEngineProxy(DynamicJadeGateway djg, List<AID> executors) {
        return EngineProxy.getEngineProxy(djg, null, executors);
    }

    private static synchronized EngineProxy getEngineProxy(DynamicJadeGateway djg, DFAgentDescription executorTemplate, List<AID> executors) {
        EngineProxy ep;
        if (djg == null) {
            djg = JadeGateway.getDefaultGateway();
        }
        if ((ep = engineProxies.get(djg)) == null) {
            ep = new EngineProxy(djg, executorTemplate, executors);
            engineProxies.put(djg, ep);
        }
        return ep;
    }

    private EngineProxy(DynamicJadeGateway dynamicJadeGateway, DFAgentDescription executorTemplate, List<AID> executors) {
        if (System.getProperty("SL-preserve-java-types") == null) {
            System.setProperty("SL-preserve-java-types", "true");
        }
        dynamicJadeGateway.addListener((GatewayListener)this);
        this.dynamicJadeGateway = dynamicJadeGateway;
        if (executors == null) {
            if (executorTemplate == null) {
                executorTemplate = new DFAgentDescription();
                ServiceDescription sd = new ServiceDescription();
                sd.addProperties(new Property("AGENT-ROLE", (Object)"Workflow Executor"));
                executorTemplate.addServices(sd);
            }
            this.customExecutors = false;
            this.executorTemplate = executorTemplate;
            this.executors = new ArrayList<AID>();
        } else {
            this.customExecutors = true;
            this.executors = executors;
        }
        this.engineProxyHandlers = new EngineProxyHandlers(this);
        myLogger.log(Logger.INFO, "Engine proxy created");
        if (dynamicJadeGateway.isGatewayActive()) {
            this.activate();
        }
    }

    private void activate() {
        try {
            this.dynamicJadeGateway.execute((Object)new OneShotBehaviour(){

                public void action() {
                    this.myAgent.getContentManager().registerLanguage((Codec)new SLCodec());
                    this.myAgent.getContentManager().registerLanguage((Codec)new LEAPCodec());
                    this.myAgent.getContentManager().registerOntology(InteractivityOntology.getInstance());
                    this.myAgent.getContentManager().registerOntology(WorkflowManagementOntology.getInstance());
                }
            });
            if (!this.customExecutors) {
                this.executors.clear();
            }
            this.engineProxyHandlers.startNotificationHandler();
            this.engineProxyHandlers.startResultHandler();
            if (this.executorTemplate != null) {
                this.engineProxyHandlers.startExecutorHandler();
            }
            this.controllers.clear();
            this.getHandlers().cleanResultHanhler();
            this.proxyActive = true;
            myLogger.log(Logger.INFO, "EngineProxy active");
        }
        catch (Exception e) {
            myLogger.log(Logger.SEVERE, "Error activating engine proxy", (Throwable)e);
        }
    }

    public void execute(Object command) throws EngineProxyException {
        this.execute(command, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object command, long timeout) throws EngineProxyException {
        EngineProxy engineProxy = this;
        synchronized (engineProxy) {
            if (!this.proxyActive) {
                try {
                    this.dynamicJadeGateway.checkJADE();
                }
                catch (Exception e) {
                    throw new EngineProxyException("Gateway starting error", e);
                }
                long startTime = System.currentTimeMillis();
                while (!this.proxyActive && System.currentTimeMillis() - startTime < 5000L) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (!this.proxyActive) {
                    throw new EngineProxyException("Gateway command aborted becouse EngineProxy not correctly activated");
                }
            }
        }
        try {
            this.dynamicJadeGateway.execute(command, timeout);
        }
        catch (Exception e) {
            throw new EngineProxyException("Error executing engine-proxy command", e);
        }
    }

    public WorkflowController launch(WorkflowDescriptor wd, WorkflowResultListener resultListener, boolean interactiveMode) throws EngineProxyException {
        return this.launch(wd, resultListener, (EventGenerationConfiguration)null, null, interactiveMode);
    }

    public WorkflowController launch(WorkflowDescriptor wd, WorkflowResultListener resultListener, WorkflowEventListener eventListener, WorkflowContext context, boolean interactiveMode) throws EngineProxyException {
        EventGenerationConfiguration eventCfg = null;
        if (eventListener != null) {
            eventCfg = EventGenerationConfiguration.getDefault(eventListener);
        }
        return this.launch(wd, resultListener, eventCfg, context, interactiveMode);
    }

    public WorkflowController launch(WorkflowDescriptor wd, WorkflowResultListener resultListener, EventGenerationConfiguration eventCfg, WorkflowContext context, boolean interactiveMode) throws EngineProxyException {
        if (wd.getId() == null) {
            if (wd.getFormat() != null && wd.getRepresentation() != null) {
                wd.setId(DEFAULT_WORKFLOW_ID);
            } else {
                String errorMsg = "WorkflowDescriptor without workflowId";
                myLogger.log(Logger.SEVERE, errorMsg);
                throw new EngineProxyException(errorMsg);
            }
        }
        if (wd.getSessionId() == null) {
            wd.setSessionId(GUIDGenerator.getGUID());
        }
        WorkflowLauncherBehaviour launcherBehaviour = new WorkflowLauncherBehaviour(this, wd, resultListener, eventCfg, context, interactiveMode);
        this.execute((Object)launcherBehaviour);
        if (launcherBehaviour.isAborted()) {
            myLogger.log(Logger.WARNING, launcherBehaviour.getAbortMessage());
            throw new EngineProxyException(launcherBehaviour.getAbortMessage(), launcherBehaviour.getAbortException());
        }
        WorkflowController wc = launcherBehaviour.getWorkflowController();
        myLogger.log(Logger.INFO, "Workflow " + wd.getId() + " launched, executionId=" + wc.getExecutionId());
        return wc;
    }

    public WorkflowController recover(String executionId, WorkflowResultListener resultListener, boolean interactiveMode) throws EngineProxyException {
        return this.recover(executionId, resultListener, (EventGenerationConfiguration)null, null, interactiveMode);
    }

    public WorkflowController recover(String executionId, WorkflowResultListener resultListener, WorkflowEventListener eventListener, WorkflowContext context, boolean interactiveMode) throws EngineProxyException {
        EventGenerationConfiguration eventCfg = null;
        if (eventListener != null) {
            eventCfg = EventGenerationConfiguration.getDefault(eventListener);
        }
        return this.recover(executionId, resultListener, eventCfg, null, interactiveMode);
    }

    public WorkflowController recover(String executionId, WorkflowResultListener resultListener, EventGenerationConfiguration eventCfg, WorkflowContext context, boolean interactiveMode) throws EngineProxyException {
        WorkflowExecutionInfo wei = this.getSafeExecution(executionId);
        WorkflowController wc = this.controllers.get(wei.getSessionId());
        if (wc != null && !wc.isTerminated()) {
            wc.markAsRecovered();
            wc.update(resultListener, eventCfg, context, interactiveMode);
        } else if (wei.getStatus() == WorkflowExecutionInfo.WorkflowStatus.FROZEN) {
            myLogger.log(Logger.INFO, "Workflow with executionId=" + executionId + " is FREEZED -> thaw it");
            byte[] workflowSerializedState = this.getSerializedState(executionId);
            WorkflowThawBehaviour thawBehaviour = new WorkflowThawBehaviour(this, wei.getSessionId(), workflowSerializedState, resultListener, eventCfg, context, interactiveMode);
            this.execute((Object)thawBehaviour);
            wc = thawBehaviour.getWorkflowController();
        } else if (wei.getStatus() == WorkflowExecutionInfo.WorkflowStatus.ACTIVE || wei.getStatus() == WorkflowExecutionInfo.WorkflowStatus.ROLLBACK || wei.getStatus() == WorkflowExecutionInfo.WorkflowStatus.SUSPENDED) {
            myLogger.log(Logger.INFO, "Workflow with executionId=" + executionId + " is already ACTIVE or SUSPENDED -> recover it");
            WorkflowRecoverBehaviour recoverBehaviour = new WorkflowRecoverBehaviour(this, wei, resultListener, eventCfg, context, interactiveMode);
            this.execute((Object)recoverBehaviour);
            wc = recoverBehaviour.getWorkflowController();
        } else {
            String errorMsg = "Workflow with executionId=" + executionId + " present in the platform but with not correct status (" + (Object)((Object)wei.getStatus()) + ")";
            myLogger.log(Logger.SEVERE, errorMsg);
            throw new EngineProxyException(errorMsg);
        }
        return wc;
    }

    public void kill(String executionId) throws EngineProxyException {
        this.kill(executionId, 0, null);
    }

    public void kill(String executionId, int scope, String message) throws EngineProxyException {
        WorkflowExecutionInfo wei = this.getSafeExecution(executionId);
        if (wei.getStatus() == WorkflowExecutionInfo.WorkflowStatus.TERMINATED) {
            throw new EngineProxyException("Operation not permitted, workflow current state is " + (Object)((Object)wei.getStatus()));
        }
        if (wei.getStatus() == WorkflowExecutionInfo.WorkflowStatus.FROZEN) {
            SetExecutionStatusBehaviour setExecutionStatusBehaviour = new SetExecutionStatusBehaviour(executionId, WorkflowExecutionInfo.WorkflowStatus.TERMINATED, "Killed from the outside");
            this.execute((Object)setExecutionStatusBehaviour);
            setExecutionStatusBehaviour.checkError();
        } else {
            AID executor = wei.getExecutor();
            KillWorkflowBehaviour killWorkflowBehaviour = new KillWorkflowBehaviour(executor, executionId, false, scope, message);
            this.execute((Object)killWorkflowBehaviour);
            killWorkflowBehaviour.checkError();
            WorkflowController wc = this.controllers.get(wei.getSessionId());
            if (wc != null) {
                wc.setInteractionTerminated("Workflow aborted");
            }
        }
    }

    public void freeze(String executionId) throws EngineProxyException {
        this.freeze(executionId, 0);
    }

    public void freeze(String executionId, int scope) throws EngineProxyException {
        WorkflowExecutionInfo wei = this.getSafeExecution(executionId);
        if (wei.getStatus() == WorkflowExecutionInfo.WorkflowStatus.TERMINATED || wei.getStatus() == WorkflowExecutionInfo.WorkflowStatus.FROZEN) {
            throw new EngineProxyException("Operation not permitted, workflow current state is " + (Object)((Object)wei.getStatus()));
        }
        String sessionId = wei.getSessionId();
        AID executor = wei.getExecutor();
        KillWorkflowBehaviour killWorkflowBehaviour = new KillWorkflowBehaviour(executor, executionId, true, scope, null);
        this.execute((Object)killWorkflowBehaviour);
        killWorkflowBehaviour.checkError();
    }

    public List<WorkflowDetails> getWorkflows() throws EngineProxyException {
        GetWorkflowsBehaviour getWfsBehaviour = new GetWorkflowsBehaviour();
        this.execute((Object)getWfsBehaviour);
        myLogger.log(Logger.INFO, "EngineProxy: Request workflows list");
        return getWfsBehaviour.getWorkflowsDetails();
    }

    public List<Parameter> getWorkflowParameters(String workflowId) throws EngineProxyException {
        GetWorkflowParametersBehaviour getWfParametersBehaviour = new GetWorkflowParametersBehaviour(workflowId);
        this.execute((Object)getWfParametersBehaviour);
        myLogger.log(Logger.INFO, "EngineProxy: Request parameters for workflow " + workflowId);
        return getWfParametersBehaviour.getParameters();
    }

    public WorkflowExecutionInfo getExecution(String executionId) throws EngineProxyException {
        GetExecutionBehaviour getExecutionBehaviour = new GetExecutionBehaviour(executionId);
        this.execute((Object)getExecutionBehaviour);
        myLogger.log(Logger.INFO, "EngineProxy: Request workflow execution info for executionId " + executionId);
        return getExecutionBehaviour.getExecution();
    }

    private WorkflowExecutionInfo getSafeExecution(String executionId) throws EngineProxyException {
        WorkflowExecutionInfo wei = this.getExecution(executionId);
        if (wei == null) {
            String errorMsg = "Workflow with executionId=" + executionId + " not present in the platform";
            myLogger.log(Logger.WARNING, errorMsg);
            throw new EngineProxyException(errorMsg);
        }
        return wei;
    }

    public List<WorkflowExecutionInfo> getPendingExecutions(String requester) throws EngineProxyException {
        GetPendingExecutionsBehaviour getPendingExecutionsBehaviour = new GetPendingExecutionsBehaviour(requester);
        this.execute((Object)getPendingExecutionsBehaviour);
        myLogger.log(Logger.INFO, "EngineProxy: Request pending executions for requester " + requester);
        return getPendingExecutionsBehaviour.getExecutions();
    }

    public List<WorkflowExecutionInfo> getSessionExecutions(String sessionId) throws EngineProxyException {
        GetSessionExecutionsBehaviour getSessionExecutionsBehaviour = new GetSessionExecutionsBehaviour(sessionId);
        this.execute((Object)getSessionExecutionsBehaviour);
        myLogger.log(Logger.INFO, "EngineProxy: Request session executions for sessionId " + sessionId);
        return getSessionExecutionsBehaviour.getExecutions();
    }

    public List queryExecutions(String what, String condition, String order) throws EngineProxyException {
        return this.queryExecutions(what, condition, order, 0, -1);
    }

    public List queryExecutions(String what, String condition, String order, int firstResult, int maxResult) throws EngineProxyException {
        QueryExecutionsBehaviour queryExecutionsBehaviour = new QueryExecutionsBehaviour(what, condition, order, firstResult, maxResult);
        this.execute((Object)queryExecutionsBehaviour);
        myLogger.log(Logger.INFO, "EngineProxy: Request query executions for: what=" + what + ", condition=" + condition + ", order=" + order);
        return queryExecutionsBehaviour.getResults();
    }

    public void remove(String executionId) throws EngineProxyException {
        RemoveExecutionBehaviour removeExecutionBehaviour = new RemoveExecutionBehaviour(executionId);
        this.execute((Object)removeExecutionBehaviour);
        myLogger.log(Logger.INFO, "EngineProxy: Request remove execution for executionId " + executionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowController getControllerByExecution(String executionId) {
        Map<String, WorkflowController> map = this.controllers;
        synchronized (map) {
            for (WorkflowController wc : this.controllers.values()) {
                if (!wc.getExecutionId().equals(executionId)) continue;
                return wc;
            }
        }
        return null;
    }

    void addExecutor(AID agent) {
        if (!this.executors.contains(agent)) {
            this.executors.add(agent);
            myLogger.log(Logger.CONFIG, "EngineProxy: Added executor " + agent);
        }
    }

    void removeExecutor(AID agent) {
        this.executors.remove(agent);
        myLogger.log(Logger.CONFIG, "EngineProxy: Removed executor " + agent);
    }

    AID nextExecutor(Agent gatewayAgent) {
        int executorsSize;
        AID executorAgent = null;
        if (this.executors.size() == 0 && this.executorTemplate != null) {
            try {
                DFAgentDescription[] dfds = DFService.search((Agent)gatewayAgent, (AID)gatewayAgent.getDefaultDF(), (DFAgentDescription)this.executorTemplate);
                for (int i = 0; i < dfds.length; ++i) {
                    AID agent = dfds[i].getName();
                    this.addExecutor(agent);
                }
            }
            catch (FIPAException e1) {
                myLogger.log(Logger.SEVERE, "EngineProxy: Error searching executor agents");
            }
        }
        if ((executorsSize = this.executors.size()) != 0) {
            executorAgent = this.executors.get(this.currentExecutorIndex++ % executorsSize);
            if (this.currentExecutorIndex >= executorsSize) {
                this.currentExecutorIndex = 0;
            }
        }
        return executorAgent;
    }

    DFAgentDescription getExecutorTemplate() {
        return this.executorTemplate;
    }

    List<AID> getExecutors() {
        return this.executors;
    }

    WorkflowController getController(String sessionId) {
        return this.controllers.get(sessionId);
    }

    void addController(String sessionId, WorkflowController controller) {
        this.controllers.put(sessionId, controller);
    }

    EngineProxyHandlers getHandlers() {
        return this.engineProxyHandlers;
    }

    void cleanSession(WorkflowManagementBehaviour wmb, String message) {
        this.getHandlers().removeFromResultHandler(wmb.getConversationId());
        String sessionId = wmb.getSessionId();
        WorkflowController controller = this.controllers.get(sessionId);
        if (controller != null) {
            controller.setTerminated();
            try {
                this.execute((Object)new CleanSessionBehaviour(sessionId, 300000L));
            }
            catch (EngineProxyException e) {
                myLogger.log(Logger.SEVERE, "EngineProxy: Error cleaning session " + sessionId, (Throwable)e);
            }
        } else {
            wmb.abort("Error launching workflow: " + message);
        }
    }

    private byte[] getSerializedState(String executionId) throws EngineProxyException {
        GetSerializedStateBehaviour getSerializedStateBehaviour = new GetSerializedStateBehaviour(executionId);
        this.execute((Object)getSerializedStateBehaviour);
        byte[] serializedState = getSerializedStateBehaviour.getSerializedState();
        if (serializedState == null) {
            String errorMsg = "Workflow serialized state with executionId=" + executionId + " not present in the storage";
            myLogger.log(Logger.WARNING, errorMsg);
            throw new EngineProxyException(errorMsg);
        }
        return serializedState;
    }

    public void handleGatewayConnected() {
        this.activate();
    }

    public void handleGatewayDisconnected() {
        myLogger.log(Logger.INFO, "EngineProxy not active");
        this.proxyActive = false;
    }

    private class CleanSessionBehaviour
    extends WakerBehaviour {
        private String sessionId;

        public CleanSessionBehaviour(String sessionId, long period) {
            super(null, period);
            this.sessionId = sessionId;
        }

        public void onStart() {
            super.onStart();
            ((GatewayAgent)this.myAgent).releaseCommand((Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onWake() {
            WorkflowController controller = (WorkflowController)EngineProxy.this.controllers.get(this.sessionId);
            Map map = EngineProxy.this.controllers;
            synchronized (map) {
                if (controller != null && controller.isTerminated()) {
                    EngineProxy.this.controllers.remove(this.sessionId);
                }
            }
        }
    }
}

