/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.proxy;

import com.tilab.wade.proxy.EngineProxyException;
import com.tilab.wade.utils.DFUtils;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.util.Date;

abstract class EngineProxyBehaviour
extends OneShotBehaviour {
    private static long TIMEOUT = 10000L;
    protected static Logger logger = Logger.getMyLogger((String)EngineProxyBehaviour.class.getName());
    private Object resultValue;
    private String errorMessage;
    private Exception errorException;

    public void action() {
        this.myAgent.getContentManager().registerOntology(this.getOntology());
        try {
            ACLMessage reply;
            AID aid;
            if (logger.isLoggable(Logger.CONFIG)) {
                logger.log(Logger.CONFIG, "Agent " + this.myAgent.getLocalName() + ": Request " + ((Object)((Object)this)).getClass().getSimpleName());
            }
            if ((aid = this.getActor()) == null) {
                this.errorMessage = "Agent actor not available";
                logger.log(Logger.WARNING, "Agent " + this.myAgent.getLocalName() + ": " + this.errorMessage);
                return;
            }
            AgentAction aa = this.getAgentAction();
            if (aa == null) {
                this.errorMessage = "Agent action not created";
                logger.log(Logger.WARNING, "Agent " + this.myAgent.getLocalName() + ": " + this.errorMessage);
                return;
            }
            ACLMessage message = this.createRequest(aid, aa, TIMEOUT);
            if (logger.isLoggable(Logger.FINE)) {
                logger.log(Logger.FINE, "EngineProxyBehaviour, send msg=" + message);
            }
            if ((reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)message)) != null) {
                if (logger.isLoggable(Logger.FINE)) {
                    logger.log(Logger.FINE, "EngineProxyBehaviour receive msg=" + reply);
                }
                if (this.extractAsByteSequence()) {
                    this.resultValue = reply.getByteSequenceContent();
                } else if (reply.getContent() != null) {
                    Result result = (Result)this.myAgent.getContentManager().extractContent(reply);
                    this.resultValue = result.getValue();
                }
            } else {
                this.errorMessage = "Timeout";
            }
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            this.errorException = e;
            logger.log(Logger.WARNING, "Agent " + this.myAgent.getLocalName() + ": Error execution " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)e);
        }
    }

    private ACLMessage createRequest(AID aid, AgentAction aa, Long timeout) throws Codec.CodecException, OntologyException {
        ACLMessage myRequest = new ACLMessage(16);
        myRequest.setLanguage("fipa-sl");
        myRequest.setProtocol("fipa-request");
        myRequest.setOntology(this.getOntology().getName());
        myRequest.addReceiver(aid);
        if (timeout != null) {
            myRequest.setReplyByDate(new Date(System.currentTimeMillis() + timeout));
        }
        Action action = new Action();
        action.setActor(aid);
        action.setAction((Concept)aa);
        this.myAgent.getContentManager().fillContent(myRequest, (ContentElement)action);
        return myRequest;
    }

    protected Object getResultValue() throws EngineProxyException {
        if (this.errorMessage == null) {
            return this.resultValue;
        }
        throw new EngineProxyException(this.errorMessage, this.errorException);
    }

    protected AID getWSMAActor() throws FIPAException {
        return EngineProxyBehaviour.getWSMAActor(this.myAgent);
    }

    static AID getWSMAActor(Agent agent) throws FIPAException {
        AID aid = null;
        DFAgentDescription[] dfds = DFUtils.searchAllByType(agent, "Workflow Status Manager Agent", null);
        if (dfds.length > 0) {
            int randomPos = (int)(Math.random() * (double)dfds.length);
            aid = DFUtils.getAID(dfds[randomPos]);
        } else {
            logger.log(Logger.WARNING, "Agent " + agent.getLocalName() + ": Agent WSMA not available");
        }
        return aid;
    }

    protected AID getCAActor() throws FIPAException {
        return EngineProxyBehaviour.getCAActor(this.myAgent);
    }

    static AID getCAActor(Agent agent) throws FIPAException {
        AID aid = DFUtils.getAID(DFUtils.searchAnyByType(agent, "Control Agent", null));
        if (aid == null) {
            logger.log(Logger.WARNING, "Agent " + agent.getLocalName() + ": Agent CA not available");
        }
        return aid;
    }

    protected boolean extractAsByteSequence() {
        return false;
    }

    protected abstract Ontology getOntology();

    protected abstract AID getActor() throws FIPAException;

    protected abstract AgentAction getAgentAction();
}

