/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.proxy;

import com.tilab.wade.dispatcher.WorkflowEventListener;
import com.tilab.wade.dispatcher.WorkflowResultListener;
import com.tilab.wade.event.Occurred;
import com.tilab.wade.performer.event.WorkflowEvent;
import com.tilab.wade.performer.ontology.ExecutionError;
import com.tilab.wade.performer.ontology.Frozen;
import com.tilab.wade.performer.ontology.GenericError;
import com.tilab.wade.performer.ontology.NotificationError;
import com.tilab.wade.proxy.EngineProxy;
import com.tilab.wade.proxy.WorkflowController;
import com.tilab.wade.proxy.WorkflowManagementBehaviour;
import jade.content.Predicate;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.ThreadedBehaviourFactory;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.SubscriptionInitiator;
import jade.util.Logger;
import jade.wrapper.gateway.GatewayAgent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class EngineProxyHandlers {
    protected static Logger logger = Logger.getMyLogger((String)EngineProxyHandlers.class.getName());
    private EngineProxy engineProxy;
    private ThreadedBehaviourFactory tbf;
    private Behaviour wrappedNotificationBehaviour;
    private Behaviour wrappedResultBehaviour;
    private Map<String, WorkflowManagementBehaviour> wmbs = new HashMap<String, WorkflowManagementBehaviour>();

    EngineProxyHandlers(EngineProxy engineProxy) {
        this.engineProxy = engineProxy;
        this.tbf = new ThreadedBehaviourFactory();
    }

    void startNotificationHandler() throws Exception {
        CyclicBehaviour notificationBehaviour = new CyclicBehaviour(){
            private MessageTemplate template;

            public void onStart() {
                super.onStart();
                this.template = new MessageTemplate(new MessageTemplate.MatchExpression(){

                    public boolean match(ACLMessage msg) {
                        String eventMessage = msg.getUserDefinedParameter("WADE-event-message");
                        return "true".equals(eventMessage);
                    }
                });
                ((GatewayAgent)this.myAgent).releaseCommand((Object)EngineProxyHandlers.this.wrappedNotificationBehaviour);
            }

            public void action() {
                block7: {
                    ACLMessage msg = this.myAgent.receive(this.template);
                    if (msg != null) {
                        try {
                            WorkflowEventListener listener;
                            if (msg.getPerformative() != 7) break block7;
                            Occurred occurred = (Occurred)this.myAgent.getContentManager().extractContent(msg);
                            WorkflowEvent ev = (WorkflowEvent)occurred.getEvent();
                            if (logger.isLoggable(Logger.FINE)) {
                                logger.log(Logger.FINE, "EngineProxy.NotificationHandler: Received notification, " + ev);
                            }
                            String executionId = msg.getConversationId();
                            WorkflowController controller = EngineProxyHandlers.this.engineProxy.getController(ev.getSessionId());
                            if (controller == null || (listener = controller.getNotificationListener(msg.getProtocol())) == null) break block7;
                            try {
                                listener.handleEvent(occurred.getTime(), ev, msg.getSender(), executionId);
                            }
                            catch (Exception e) {
                                logger.log(Logger.WARNING, "EngineProxy.NotificationHandler: HandleEvent failed", (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Logger.SEVERE, "EngineProxy.NotificationHandler: Error decoding notification", (Throwable)e);
                        }
                    } else {
                        this.block();
                    }
                }
            }
        };
        this.wrappedNotificationBehaviour = this.tbf.wrap((Behaviour)notificationBehaviour);
        this.engineProxy.dynamicJadeGateway.execute((Object)this.wrappedNotificationBehaviour);
    }

    void startResultHandler() throws Exception {
        CyclicBehaviour resultBehaviour = new CyclicBehaviour(){
            private MessageTemplate template;

            public void onStart() {
                super.onStart();
                this.template = new MessageTemplate(new MessageTemplate.MatchExpression(){

                    public boolean match(ACLMessage msg) {
                        String conversationId = msg.getConversationId();
                        return EngineProxyHandlers.this.wmbs.containsKey(conversationId);
                    }
                });
                ((GatewayAgent)this.myAgent).releaseCommand((Object)EngineProxyHandlers.this.wrappedResultBehaviour);
            }

            public void action() {
                block13: {
                    ACLMessage msg = this.myAgent.receive(this.template);
                    if (msg != null) {
                        try {
                            String conversationId = msg.getConversationId();
                            WorkflowManagementBehaviour wmb = (WorkflowManagementBehaviour)((Object)EngineProxyHandlers.this.wmbs.get(conversationId));
                            if (wmb != null) {
                                WorkflowResultListener resultListener = wmb.getResultListener();
                                switch (msg.getPerformative()) {
                                    case 1: {
                                        this.handleAgree(msg, wmb, resultListener);
                                        break;
                                    }
                                    case 7: {
                                        this.handleInform(msg, wmb, resultListener);
                                        break;
                                    }
                                    case 14: {
                                        this.handleRefuse(msg, wmb, resultListener);
                                        break;
                                    }
                                    case 6: {
                                        this.handleFailure(msg, wmb, resultListener);
                                        break;
                                    }
                                    case 10: {
                                        this.handleNotUnderstood(msg, wmb, resultListener);
                                        break;
                                    }
                                    default: {
                                        logger.log(Logger.WARNING, "EngineProxy.ResultHandler: Received message=" + msg + " with unexpected performative");
                                    }
                                }
                                if (msg.getPerformative() != 1) {
                                    EngineProxyHandlers.this.engineProxy.cleanSession(wmb, msg.getContent());
                                }
                                break block13;
                            }
                            logger.log(Logger.WARNING, "EngineProxy.ResultHandler: Received message=" + msg + " but no one wmb waiting for it");
                        }
                        catch (Exception e) {
                            logger.log(Logger.SEVERE, "EngineProxy.ResultHandler: Error decoding notification", (Throwable)e);
                        }
                    } else {
                        this.block();
                    }
                }
            }

            private void handleAgree(ACLMessage msg, WorkflowManagementBehaviour wmb, WorkflowResultListener resultListener) {
                if (logger.isLoggable(Logger.FINE)) {
                    logger.log(Logger.FINE, "EngineProxy.ResultHandler: Received AGREE msg=" + msg);
                }
                String executionId = msg.getContent();
                wmb.setAgreeInfo(executionId, msg.getSender());
                if (resultListener != null) {
                    try {
                        resultListener.handleAssignedId(msg.getSender(), executionId);
                    }
                    catch (Exception e) {
                        logger.log(Logger.WARNING, "EngineProxy.ResultHandler: HandleAssignedId failed, msg=" + msg, (Throwable)e);
                    }
                }
            }

            private void handleInform(ACLMessage msg, WorkflowManagementBehaviour wmb, WorkflowResultListener resultListener) {
                if (logger.isLoggable(Logger.FINE)) {
                    logger.log(Logger.FINE, "EngineProxy.ResultHandler: Received INFORM msg=" + msg);
                }
                if (resultListener != null) {
                    try {
                        Predicate p = (Predicate)this.myAgent.getContentManager().extractContent(msg);
                        if (p instanceof Result) {
                            resultListener.handleExecutionCompleted(((Result)p).getItems(), msg.getSender(), wmb.getExecutionId());
                        } else if (p instanceof Frozen) {
                            resultListener.handleExecutionCompleted(null, msg.getSender(), wmb.getExecutionId());
                        }
                    }
                    catch (Exception e) {
                        logger.log(Logger.WARNING, "EngineProxy.ResultHandler: HandleExecutionCompleted failed, msg=" + msg, (Throwable)e);
                    }
                }
            }

            private void handleRefuse(ACLMessage msg, WorkflowManagementBehaviour wmb, WorkflowResultListener resultListener) {
                if (logger.isLoggable(Logger.FINE)) {
                    logger.log(Logger.FINE, "EngineProxy.ResultHandler: Received REFUSE msg=" + msg);
                }
                if (resultListener != null) {
                    try {
                        resultListener.handleLoadError(msg.getContent());
                    }
                    catch (Exception e) {
                        logger.log(Logger.WARNING, "EngineProxy.ResultHandler: HandleLoadError failed, msg=" + msg, (Throwable)e);
                    }
                }
            }

            protected void handleNotUnderstood(ACLMessage msg, WorkflowManagementBehaviour wmb, WorkflowResultListener resultListener) {
                if (logger.isLoggable(Logger.FINE)) {
                    logger.log(Logger.FINE, "EngineProxy.ResultHandler: Received NOT-UNDERSTOOD msg=" + msg);
                }
                if (resultListener != null) {
                    try {
                        resultListener.handleLoadError(msg.getContent());
                    }
                    catch (Exception e) {
                        logger.log(Logger.WARNING, "EngineProxy.ResultHandler: HandleLoadError failed, msg=" + msg, (Throwable)e);
                    }
                }
            }

            private void handleFailure(ACLMessage msg, WorkflowManagementBehaviour wmb, WorkflowResultListener resultListener) {
                if (logger.isLoggable(Logger.FINE)) {
                    logger.log(Logger.FINE, "EngineProxy.ResultHandler: Received FAILURE msg=" + msg);
                }
                if (resultListener != null) {
                    if (msg.getSender().equals((Object)this.myAgent.getAMS())) {
                        resultListener.handleLoadError("EngineProxy.ResultHandler: Receved failure from AMS, msg=" + msg);
                    } else {
                        try {
                            Predicate p = (Predicate)this.myAgent.getContentManager().extractContent(msg);
                            if (p instanceof GenericError) {
                                resultListener.handleLoadError(((GenericError)p).getReason());
                            } else if (p instanceof NotificationError) {
                                resultListener.handleNotificationError(msg.getSender(), wmb.getExecutionId());
                            } else if (p instanceof ExecutionError) {
                                resultListener.handleExecutionError((ExecutionError)p, msg.getSender(), wmb.getExecutionId());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                resultListener.handleNotificationError(msg.getSender(), wmb.getExecutionId());
                            }
                            catch (Exception e1) {
                                logger.log(Logger.WARNING, "EngineProxy.ResultHandler: HandleNotificationError failed, msg=" + msg, (Throwable)e);
                            }
                        }
                    }
                }
            }
        };
        this.wrappedResultBehaviour = this.tbf.wrap((Behaviour)resultBehaviour);
        this.engineProxy.dynamicJadeGateway.execute((Object)this.wrappedResultBehaviour);
    }

    void addToResultHandler(String conversationId, WorkflowManagementBehaviour wmb) {
        this.wmbs.put(conversationId, wmb);
    }

    void removeFromResultHandler(String conversationId) {
        this.wmbs.remove(conversationId);
    }

    void cleanResultHanhler() {
        this.wmbs.clear();
    }

    void startExecutorHandler() throws Exception {
        this.engineProxy.dynamicJadeGateway.execute((Object)new SubscriptionInitiator(null, null){

            public void onStart() {
                super.onStart();
                ((GatewayAgent)this.myAgent).releaseCommand((Object)this);
            }

            protected Vector prepareSubscriptions(ACLMessage subscription) {
                Vector<ACLMessage> l = new Vector<ACLMessage>(1);
                l.addElement(DFService.createSubscriptionMessage((Agent)this.myAgent, (AID)this.myAgent.getDefaultDF(), (DFAgentDescription)EngineProxyHandlers.this.engineProxy.getExecutorTemplate(), null));
                return l;
            }

            protected void handleInform(ACLMessage inform) {
                try {
                    DFAgentDescription[] dfds = DFService.decodeNotification((String)inform.getContent());
                    for (int i = 0; i < dfds.length; ++i) {
                        AID agent = dfds[i].getName();
                        if (dfds[i].getAllServices().hasNext()) {
                            EngineProxyHandlers.this.engineProxy.addExecutor(agent);
                            continue;
                        }
                        EngineProxyHandlers.this.engineProxy.removeExecutor(agent);
                    }
                }
                catch (FIPAException e) {
                    logger.log(Logger.SEVERE, "EngineProxy.ExecutorHandler: Error decoding df notification", (Throwable)e);
                }
            }
        });
    }
}

