/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.proxy;

import com.tilab.wade.dispatcher.WorkflowEventListener;
import com.tilab.wade.performer.ontology.ControlInfo;
import com.tilab.wade.proxy.EngineProxyException;
import jade.core.AID;
import jade.util.leap.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventGenerationConfiguration {
    private List controlInfos = new jade.util.leap.ArrayList();
    private Map<String, WorkflowEventListener> listeners = new HashMap<String, WorkflowEventListener>();

    public void setGenerateEvents(String type, int verbosityLevel, WorkflowEventListener notificationListener) throws EngineProxyException {
        this.setGenerateEvents(type, verbosityLevel, notificationListener, null);
    }

    public void setGenerateEvents(String type, int verbosityLevel, WorkflowEventListener notificationListener, java.util.List<AID> controllers) throws EngineProxyException {
        if (this.listeners.containsKey(type)) {
            throw new EngineProxyException("Event of type " + type + " already managed");
        }
        ControlInfo ci = new ControlInfo();
        ci.setType(type);
        ci.setVerbosityLevel(verbosityLevel);
        if (controllers != null) {
            ci.setControllers((List)new jade.util.leap.ArrayList((ArrayList)controllers));
        }
        this.controlInfos.add((Object)ci);
        if (notificationListener != null) {
            this.listeners.put(type, notificationListener);
        }
    }

    List getControlInfos() {
        return this.controlInfos;
    }

    Map<String, WorkflowEventListener> getListeners() {
        return this.listeners;
    }

    static EventGenerationConfiguration getDefault(WorkflowEventListener eventListener) {
        EventGenerationConfiguration eventCfg = new EventGenerationConfiguration();
        try {
            eventCfg.setGenerateEvents("flow", 4, eventListener);
            eventCfg.setGenerateEvents("tracing", 3, eventListener);
        }
        catch (EngineProxyException e) {
            e.printStackTrace();
        }
        return eventCfg;
    }
}

