/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.proxy;

import com.tilab.wade.performer.interactivity.InteractivitySnapshot;
import com.tilab.wade.performer.interactivity.ontology.GetSnapshot;
import com.tilab.wade.performer.interactivity.ontology.InteractivityCompleted;
import com.tilab.wade.performer.interactivity.ontology.InteractivityOntology;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.Predicate;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.IMTPException;
import jade.core.behaviours.SimpleBehaviour;
import jade.domain.AMSService;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;

public class GetSnapshotBehaviour
extends SimpleBehaviour {
    protected static Logger logger = Logger.getMyLogger((String)GetSnapshotBehaviour.class.getName());
    public static final int UNDEFINED_STATUS = -1;
    public static final int SUCCESS_STATUS = 0;
    public static final int FAILURE_STATUS = 1;
    private static final String GET_SNAPSHOT_REPLY_WITH = "GET_SNAPSHOT";
    private AID executor;
    private String sessionId;
    private InteractivitySnapshot snapshot;
    private int status = -1;
    private String error;
    private Exception nestedException;
    private MessageTemplate snapshotTemplate;
    private ACLMessage request;
    private Ontology interactivityOnto = InteractivityOntology.getInstance();
    private boolean finished = false;

    public GetSnapshotBehaviour(AID executor, String sessionId) {
        super(null);
        this.executor = executor;
        this.sessionId = sessionId;
        this.snapshotTemplate = MessageTemplate.and((MessageTemplate)MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)InteractivityOntology.getInstance().getName()), (MessageTemplate)MessageTemplate.MatchConversationId((String)sessionId)), (MessageTemplate)MessageTemplate.MatchInReplyTo((String)GET_SNAPSHOT_REPLY_WITH));
    }

    public void onStart() {
        super.onStart();
        if (!this.finished) {
            try {
                while (this.myAgent.receive(this.snapshotTemplate) != null) {
                }
                this.request = new ACLMessage(16);
                this.request.setLanguage("LEAP");
                this.request.setOntology(this.interactivityOnto.getName());
                this.request.setProtocol("fipa-request");
                this.request.setConversationId(this.sessionId);
                this.request.addReceiver(this.executor);
                this.request.setReplyWith(GET_SNAPSHOT_REPLY_WITH);
                Action act = new Action(this.myAgent.getAID(), (Concept)new GetSnapshot());
                this.myAgent.getContentManager().fillContent(this.request, (ContentElement)act);
                if (logger.isLoggable(Logger.FINE)) {
                    logger.log(Logger.FINE, "Send REQUEST(GET-SNAPSHOT) for sessionId=" + this.sessionId);
                }
                this.myAgent.send(this.request);
            }
            catch (Exception e) {
                this.status = 1;
                this.error = e.getMessage();
                this.finished = true;
            }
        }
    }

    public int onEnd() {
        return super.onEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action() {
        ACLMessage msg = this.myAgent.receive(this.snapshotTemplate);
        if (msg != null) {
            GetSnapshotBehaviour getSnapshotBehaviour = this;
            synchronized (getSnapshotBehaviour) {
                if (!this.finished) {
                    if (msg.getSender().equals((Object)this.myAgent.getAMS())) {
                        this.error = "Agent " + this.executor.getLocalName() + " UNREACHABLE";
                        this.status = 1;
                        try {
                            this.nestedException = new IMTPException(AMSService.getFailureReason((Agent)this.myAgent, (ACLMessage)msg));
                        }
                        catch (FIPAException e) {
                            logger.log(Logger.WARNING, "Wrong AMS FAILURE reason, msg=" + msg);
                        }
                    } else if (msg.getPerformative() == 7) {
                        try {
                            Predicate p = (Predicate)this.myAgent.getContentManager().extractContent(msg);
                            if (p instanceof Result) {
                                this.snapshot = (InteractivitySnapshot)((Result)p).getValue();
                                this.status = 0;
                            } else if (p instanceof InteractivityCompleted) {
                                throw new Exception("Workflow interactivity already terminated, snapshot not available");
                            }
                        }
                        catch (Exception e) {
                            this.status = 1;
                            this.error = "Extracting result error: " + e.getMessage();
                        }
                    } else {
                        this.status = 1;
                        this.error = msg.getContent();
                    }
                    this.finished = true;
                }
            }
        }
        this.block();
    }

    public boolean done() {
        return this.finished;
    }

    public InteractivitySnapshot getSnapshot() {
        return this.snapshot;
    }

    public String getError() {
        return this.error;
    }

    public Exception getNestedException() {
        return this.nestedException;
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        boolean aborted = false;
        GetSnapshotBehaviour getSnapshotBehaviour = this;
        synchronized (getSnapshotBehaviour) {
            if (this.status == -1) {
                this.status = 1;
                this.error = "Aborted";
                this.finished = true;
                aborted = true;
            }
        }
        if (aborted) {
            this.restart();
        }
    }
}

