/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.proxy;

import com.tilab.wade.performer.interactivity.Interaction;
import com.tilab.wade.performer.interactivity.ontology.Go;
import com.tilab.wade.performer.interactivity.ontology.InteractivityCompleted;
import com.tilab.wade.performer.interactivity.ontology.InteractivityOntology;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.Predicate;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.IMTPException;
import jade.core.behaviours.SimpleBehaviour;
import jade.domain.AMSService;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;

public class GoRequesterBehaviour
extends SimpleBehaviour {
    protected static Logger logger = Logger.getMyLogger((String)GoRequesterBehaviour.class.getName());
    public static final int UNDEFINED_STATUS = -1;
    public static final int SUCCESS_STATUS = 0;
    public static final int FAILURE_STATUS = 1;
    public static final int SUSPENDED_STATUS = 2;
    public static final int FROZEN_STATUS = 3;
    private AID executor;
    private String sessionId;
    private Interaction prevInteraction;
    private Interaction nextInteraction;
    private Ontology interactivityOnto = InteractivityOntology.getInstance();
    private MessageTemplate interactionTemplate;
    private ACLMessage request;
    private int status = -1;
    private String error;
    private Exception nestedException;
    private boolean finished = false;

    public GoRequesterBehaviour(AID executor, String sessionId, Interaction interaction) {
        super(null);
        this.executor = executor;
        this.sessionId = sessionId;
        this.prevInteraction = interaction;
        this.interactionTemplate = MessageTemplate.and((MessageTemplate)MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)InteractivityOntology.getInstance().getName()), (MessageTemplate)MessageTemplate.MatchConversationId((String)sessionId)), (MessageTemplate)new MessageTemplate(new MessageTemplate.MatchExpression(){

            public boolean match(ACLMessage msg) {
                return msg.getInReplyTo() == null;
            }
        }));
    }

    public void onStart() {
        super.onStart();
        if (!this.finished) {
            try {
                while (this.myAgent.receive(this.interactionTemplate) != null) {
                }
                this.request = new ACLMessage(16);
                this.request.setLanguage("LEAP");
                this.request.setOntology(this.interactivityOnto.getName());
                this.request.setProtocol("fipa-request");
                this.request.setConversationId(this.sessionId);
                this.request.addReceiver(this.executor);
                Action act = new Action(this.myAgent.getAID(), (Concept)this.getAgentAction());
                this.myAgent.getContentManager().fillContent(this.request, (ContentElement)act);
                if (logger.isLoggable(Logger.FINE)) {
                    logger.log(Logger.FINE, "Send REQUEST(GO/BACK) for sessionId=" + this.sessionId);
                }
                this.myAgent.send(this.request);
            }
            catch (Exception e) {
                this.status = 1;
                this.error = e.getMessage();
                this.finished = true;
            }
        }
    }

    public int onEnd() {
        return super.onEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action() {
        ACLMessage msg = this.myAgent.receive(this.interactionTemplate);
        if (msg != null) {
            GoRequesterBehaviour goRequesterBehaviour = this;
            synchronized (goRequesterBehaviour) {
                if (!this.finished) {
                    block24: {
                        if (msg.getSender().equals((Object)this.myAgent.getAMS())) {
                            this.error = "Agent " + this.executor.getLocalName() + " UNREACHABLE";
                            this.status = 1;
                            try {
                                this.nestedException = new IMTPException(AMSService.getFailureReason((Agent)this.myAgent, (ACLMessage)msg));
                            }
                            catch (FIPAException e) {
                                logger.log(Logger.WARNING, "Wrong AMS FAILURE reason, msg=" + msg);
                            }
                        } else if (msg.getPerformative() == 7) {
                            try {
                                Predicate p = (Predicate)this.myAgent.getContentManager().extractContent(msg);
                                if (p instanceof Result) {
                                    if (logger.isLoggable(Logger.FINE)) {
                                        logger.log(Logger.FINE, "Receive INFORM(RESULT(GO)) for sessionId=" + this.sessionId);
                                    }
                                    this.nextInteraction = (Interaction)((Result)p).getValue();
                                    this.status = 0;
                                    this.error = null;
                                    break block24;
                                }
                                if (p instanceof InteractivityCompleted) {
                                    this.nextInteraction = null;
                                    this.error = null;
                                    InteractivityCompleted ic = (InteractivityCompleted)p;
                                    if (ic.getReason() == InteractivityCompleted.Reason.PROGRAMMATING) {
                                        if (logger.isLoggable(Logger.FINE)) {
                                            logger.log(Logger.FINE, "Receive INFORM(INTERACTIVITY-COMPLETED-PROGRAMMATING) for sessionId=" + this.sessionId);
                                        }
                                        this.status = 0;
                                    } else if (ic.getReason() == InteractivityCompleted.Reason.SUSPENDED) {
                                        if (logger.isLoggable(Logger.FINE)) {
                                            logger.log(Logger.FINE, "Receive INFORM(INTERACTIVITY-COMPLETED-SUSPENDED) for sessionId=" + this.sessionId);
                                        }
                                        this.status = 2;
                                        this.error = ic.getSuspendMessage();
                                    } else if (ic.getReason() == InteractivityCompleted.Reason.FROZEN) {
                                        if (logger.isLoggable(Logger.FINE)) {
                                            logger.log(Logger.FINE, "Receive INFORM(INTERACTIVITY-COMPLETED-FROZEN) for sessionId=" + this.sessionId);
                                        }
                                        this.status = 3;
                                    }
                                    break block24;
                                }
                                throw new Exception("Predicate " + p + " not supported");
                            }
                            catch (Exception e) {
                                this.status = 1;
                                this.error = "Extracting result error: " + e.getMessage();
                            }
                        } else {
                            this.status = 1;
                            this.error = msg.getContent();
                        }
                    }
                    this.finished = true;
                }
            }
        }
        this.block();
    }

    public boolean done() {
        return this.finished;
    }

    protected AgentAction getAgentAction() {
        return new Go(this.prevInteraction);
    }

    public Interaction getNextInteraction() {
        return this.nextInteraction;
    }

    public String getError() {
        return this.error;
    }

    public Exception getNestedException() {
        return this.nestedException;
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        boolean aborted = false;
        GoRequesterBehaviour goRequesterBehaviour = this;
        synchronized (goRequesterBehaviour) {
            if (this.status == -1) {
                this.status = 1;
                this.error = "Aborted";
                this.finished = true;
                aborted = true;
            }
        }
        if (aborted) {
            this.restart();
        }
    }
}

