/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.proxy;

import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.proxy.EngineProxyBehaviour;
import com.tilab.wade.proxy.EngineProxyException;
import com.tilab.wade.wsma.ontology.StatusChanged;
import com.tilab.wade.wsma.ontology.Terminated;
import com.tilab.wade.wsma.ontology.WorkflowExecutionInfo;
import com.tilab.wade.wsma.ontology.WorkflowStatusOntology;
import jade.content.ContentElement;
import jade.core.AID;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.util.ArrayList;
import java.util.logging.Level;

public class SetExecutionStatusBehaviour
extends OneShotBehaviour {
    protected static Logger logger = Logger.getMyLogger((String)SetExecutionStatusBehaviour.class.getName());
    private String executionId;
    private WorkflowExecutionInfo.WorkflowStatus status;
    private String terminationMessage;
    private String errorMessage;

    public SetExecutionStatusBehaviour(String executionId, WorkflowExecutionInfo.WorkflowStatus status, String terminationMessage) {
        this.executionId = executionId;
        this.status = status;
        this.terminationMessage = terminationMessage;
        this.errorMessage = null;
    }

    public void action() {
        try {
            AID wsmaAid = EngineProxyBehaviour.getWSMAActor(this.myAgent);
            Object predicate = this.status == WorkflowExecutionInfo.WorkflowStatus.TERMINATED ? new Terminated(this.executionId, new ArrayList<Parameter>(), this.terminationMessage) : new StatusChanged(this.executionId, this.status);
            ACLMessage inform = new ACLMessage(7);
            inform.setLanguage("fipa-sl");
            inform.setOntology(WorkflowStatusOntology.getInstance().getName());
            inform.setProtocol("fipa-request");
            inform.addUserDefinedParameter("JADE-ignore-failure", "true");
            inform.addReceiver(wsmaAid);
            this.myAgent.getContentManager().fillContent(inform, (ContentElement)predicate);
            this.myAgent.send(inform);
            logger.log(Logger.FINE, "Status notification " + predicate + " sended to agent " + wsmaAid);
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            logger.log(Level.SEVERE, "Error sending status notification request", (Throwable)e);
        }
    }

    public void checkError() throws EngineProxyException {
        if (this.errorMessage != null) {
            throw new EngineProxyException(this.errorMessage);
        }
    }
}

