/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.proxy;

import com.tilab.wade.dispatcher.WorkflowEventListener;
import com.tilab.wade.dispatcher.WorkflowResultListener;
import com.tilab.wade.performer.interactivity.Interaction;
import com.tilab.wade.performer.interactivity.InteractivitySnapshot;
import com.tilab.wade.proxy.BackRequesterBehaviour;
import com.tilab.wade.proxy.EngineProxy;
import com.tilab.wade.proxy.EngineProxyException;
import com.tilab.wade.proxy.EventGenerationConfiguration;
import com.tilab.wade.proxy.FrozenException;
import com.tilab.wade.proxy.GetSnapshotBehaviour;
import com.tilab.wade.proxy.GoRequesterBehaviour;
import com.tilab.wade.proxy.ResetControlInfosBehaviour;
import com.tilab.wade.proxy.ResetModifiersBehaviour;
import com.tilab.wade.proxy.SuspendedException;
import com.tilab.wade.proxy.WorkflowContext;
import com.tilab.wade.proxy.WorkflowManagementBehaviour;
import jade.core.AID;
import jade.util.Logger;
import jade.util.leap.List;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;

public class WorkflowController {
    protected static Logger logger = Logger.getMyLogger((String)WorkflowController.class.getName());
    private EngineProxy engineProxy;
    private AID executor;
    private String executionId;
    private String sessionId;
    private boolean recovered;
    private boolean backEnabled;
    private Map<String, WorkflowEventListener> notificationListeners;
    private String interactionTerminatedMessage;
    private boolean interactionTerminated;
    private boolean terminated;
    private GoRequesterBehaviour gobackBehaviour;
    private GetSnapshotBehaviour getSnapshotBehaviour;
    private WorkflowManagementBehaviour wmBehaviour;
    private Map<String, Map<String, Object>> cacheDataMap = new HashMap<String, Map<String, Object>>();

    WorkflowController(EngineProxy engineProxy, AID executor, String executionId, String sessionId, EventGenerationConfiguration eventCfg, boolean recovered, WorkflowManagementBehaviour wmb) {
        this.engineProxy = engineProxy;
        this.sessionId = sessionId;
        this.executor = executor;
        this.executionId = executionId;
        this.recovered = recovered;
        this.interactionTerminated = false;
        this.terminated = false;
        this.wmBehaviour = wmb;
        this.backEnabled = false;
        this.setNotificationListener(eventCfg);
    }

    public Interaction go() throws EngineProxyException {
        return this.go(null);
    }

    public Interaction go(Interaction interaction) throws EngineProxyException {
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "Begin go() for sessionId=" + this.sessionId);
        }
        Interaction nextInteraction = this.goback(new GoRequesterBehaviour(this.executor, this.sessionId, interaction), interaction);
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "End go() for sessionId=" + this.sessionId);
        }
        return nextInteraction;
    }

    public Interaction back() throws EngineProxyException {
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "Begin back() for sessionId=" + this.sessionId);
        }
        if (!this.backEnabled) {
            throw new UnsupportedOperationException("Back not possible; workflow not support TAG or no previous step available");
        }
        Interaction prevInteraction = this.goback(new BackRequesterBehaviour(this.executor, this.sessionId), null);
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "End back() for sessionId=" + this.sessionId);
        }
        return prevInteraction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Interaction goback(GoRequesterBehaviour b, Interaction interaction) throws EngineProxyException {
        if (this.interactionTerminated) {
            throw new EngineProxyException(this.interactionTerminatedMessage);
        }
        WorkflowController workflowController = this;
        synchronized (workflowController) {
            if (this.gobackBehaviour != null) {
                throw new ConcurrentModificationException("Action not possible; go/back action active");
            }
            this.gobackBehaviour = b;
        }
        this.storeCacheData(interaction);
        try {
            this.engineProxy.execute((Object)b);
            if (b.getStatus() == 1) {
                String error = b.getError();
                Exception nestedException = b.getNestedException();
                throw new EngineProxyException(error, nestedException);
            }
            if (b.getStatus() == 3) {
                this.setInteractionTerminated("Controlled workflow frozen");
                throw new FrozenException();
            }
            if (b.getStatus() == 2) {
                this.setInteractionTerminated("Controlled workflow suspended");
                WorkflowResultListener resultListener = this.wmBehaviour.getResultListener();
                if (resultListener != null) {
                    resultListener.handleExecutionCompleted(null, this.executor, this.wmBehaviour.getExecutionId());
                }
                this.engineProxy.cleanSession(this.wmBehaviour, null);
                throw new SuspendedException(b.getError());
            }
            Interaction nextInteraction = b.getNextInteraction();
            if (nextInteraction == null || nextInteraction.isLast()) {
                this.setInteractionTerminated("Interaction terminated");
            }
            this.setBackEnabled(nextInteraction);
            this.applyCacheData(nextInteraction);
            Interaction interaction2 = nextInteraction;
            return interaction2;
        }
        catch (Exception e) {
            throw new EngineProxyException("Error executing action " + ((Object)((Object)b)).getClass().getSimpleName(), e);
        }
        finally {
            WorkflowController workflowController2 = this;
            synchronized (workflowController2) {
                this.gobackBehaviour = null;
            }
        }
    }

    private void storeCacheData(Interaction interaction) {
        if (interaction != null && interaction.getId() != null) {
            Map<String, Object> interactionCacheData = interaction.getCacheData();
            this.cacheDataMap.put(interaction.getId(), interactionCacheData);
        }
    }

    private void applyCacheData(Interaction interaction) {
        if (interaction != null && interaction.getId() != null) {
            Map<String, Object> interactionCacheData = this.cacheDataMap.get(interaction.getId());
            interaction.setCacheData(interactionCacheData);
        }
    }

    private void setBackEnabled(Interaction interaction) {
        this.backEnabled = interaction == null || interaction.isLast() ? false : interaction.isBackEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractivitySnapshot getSnapshot() throws EngineProxyException {
        GetSnapshotBehaviour b;
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "Begin getSnapshot() for sessionId=" + this.sessionId);
        }
        if (this.interactionTerminated) {
            throw new EngineProxyException(this.interactionTerminatedMessage);
        }
        WorkflowController workflowController = this;
        synchronized (workflowController) {
            if (this.getSnapshotBehaviour != null) {
                this.getSnapshotBehaviour.abort();
            }
            if (this.gobackBehaviour != null) {
                this.gobackBehaviour.abort();
            }
            this.getSnapshotBehaviour = b = new GetSnapshotBehaviour(this.executor, this.sessionId);
        }
        try {
            this.engineProxy.execute((Object)b);
            if (b.getStatus() != 0) {
                throw new EngineProxyException(b.getError(), b.getNestedException());
            }
            InteractivitySnapshot snapshot = b.getSnapshot();
            this.setBackEnabled(snapshot.getInteraction());
            this.applyCacheData(snapshot.getInteraction());
            if (logger.isLoggable(Logger.FINE)) {
                logger.log(Logger.FINE, "End getSnapshot() for sessionId=" + this.sessionId);
            }
            InteractivitySnapshot interactivitySnapshot = snapshot;
            return interactivitySnapshot;
        }
        catch (Exception e) {
            throw new EngineProxyException("Error executing action getSnapshot", e);
        }
        finally {
            WorkflowController workflowController2 = this;
            synchronized (workflowController2) {
                if (b == this.getSnapshotBehaviour) {
                    this.getSnapshotBehaviour = null;
                }
            }
        }
    }

    public AID getExecutor() {
        return this.executor;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public boolean isBackEnabled() {
        return this.backEnabled && this.gobackBehaviour == null;
    }

    void setInteractionTerminated(String message) {
        this.gobackBehaviour = null;
        this.interactionTerminated = true;
        this.interactionTerminatedMessage = message;
    }

    WorkflowEventListener getNotificationListener(String type) {
        return this.notificationListeners.get(type);
    }

    void setNotificationListener(EventGenerationConfiguration eventCfg) {
        if (eventCfg != null) {
            this.notificationListeners = eventCfg.getListeners();
        }
    }

    WorkflowManagementBehaviour getWMB() {
        return this.wmBehaviour;
    }

    void markAsRecovered() {
        this.recovered = true;
        this.backEnabled = false;
    }

    void setTerminated() {
        this.interactionTerminated = true;
        this.terminated = true;
    }

    boolean isTerminated() {
        return this.terminated;
    }

    void update(WorkflowResultListener resultListener, EventGenerationConfiguration eventCfg, WorkflowContext context, boolean interactiveMode) throws EngineProxyException {
        this.setNotificationListener(eventCfg);
        this.wmBehaviour.update(resultListener, eventCfg, context, interactiveMode);
        List cInfos = this.wmBehaviour.prepareControlInfos();
        List modifiers = this.wmBehaviour.prepareModifiers();
        ResetControlInfosBehaviour rciBehaviour = new ResetControlInfosBehaviour(this.executor, this.executionId, cInfos);
        this.engineProxy.execute((Object)rciBehaviour);
        ResetModifiersBehaviour rmBehaviour = new ResetModifiersBehaviour(this.executor, this.executionId, modifiers);
        this.engineProxy.execute((Object)rmBehaviour);
    }
}

