/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.proxy;

import com.tilab.wade.dispatcher.WorkflowResultListener;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import com.tilab.wade.performer.ontology.ExecuteWorkflow;
import com.tilab.wade.proxy.EngineProxy;
import com.tilab.wade.proxy.EventGenerationConfiguration;
import com.tilab.wade.proxy.WorkflowContext;
import com.tilab.wade.proxy.WorkflowManagementBehaviour;
import com.tilab.wade.utils.GUIDGenerator;
import jade.content.AgentAction;
import jade.util.Logger;
import jade.util.leap.List;

class WorkflowLauncherBehaviour
extends WorkflowManagementBehaviour {
    private static final long serialVersionUID = -503193840117703276L;
    private WorkflowDescriptor wd;

    public WorkflowLauncherBehaviour(EngineProxy ep, WorkflowDescriptor wd, WorkflowResultListener resultListener, EventGenerationConfiguration eventCfg, WorkflowContext context, boolean interactiveMode) {
        super(ep, resultListener, eventCfg, context, interactiveMode);
        this.wd = wd;
        this.sessionId = wd.getSessionId();
        if (this.sessionId == null) {
            this.sessionId = GUIDGenerator.getGUID();
            wd.setSessionId(this.sessionId);
        }
    }

    public void onStart() {
        this.executor = this.engineProxy.nextExecutor(this.myAgent);
        if (this.executor == null) {
            logger.log(Logger.WARNING, "Agent " + this.myAgent.getLocalName() + ": " + ((Object)((Object)this)).getClass().getSimpleName() + ": No workflow executors available, sessionId=" + this.sessionId);
            this.abort("No workflow executors available");
        }
        super.onStart();
    }

    protected AgentAction prepareAgentAction() {
        this.wd.setExecution(0);
        List cInfos = this.prepareControlInfos();
        List modifiers = this.prepareModifiers();
        return new ExecuteWorkflow(this.wd, cInfos, modifiers);
    }
}

