/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.proxy;

import com.tilab.wade.dispatcher.WorkflowResultListener;
import com.tilab.wade.performer.DefaultParameterValues;
import com.tilab.wade.performer.WebServiceSecurityContext;
import com.tilab.wade.performer.ontology.ControlInfo;
import com.tilab.wade.performer.ontology.Modifier;
import com.tilab.wade.performer.ontology.WorkflowManagementOntology;
import com.tilab.wade.proxy.EngineProxy;
import com.tilab.wade.proxy.EventGenerationConfiguration;
import com.tilab.wade.proxy.WorkflowContext;
import com.tilab.wade.proxy.WorkflowController;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.util.Date;

public abstract class WorkflowManagementBehaviour
extends SimpleBehaviour {
    private static final long serialVersionUID = 5512366647972793254L;
    protected static final long BEHAVIOUR_TIMEOUT = 10000L;
    protected static Logger logger = Logger.getMyLogger((String)WorkflowManagementBehaviour.class.getName());
    private static int controllersCnt = 0;
    private Ontology onto = WorkflowManagementOntology.getInstance();
    private WorkflowController controller;
    protected EngineProxy engineProxy;
    protected WorkflowResultListener resultListener;
    protected EventGenerationConfiguration eventCfg;
    protected WorkflowContext context;
    protected String executionId;
    protected String sessionId;
    protected String conversationId;
    protected AID executor;
    protected boolean recovered;
    protected boolean aborted;
    protected String abortMessage;
    protected Exception abortException;
    protected boolean interactiveMode;

    protected abstract AgentAction prepareAgentAction();

    public WorkflowManagementBehaviour(EngineProxy engineProxy, WorkflowResultListener resultListener, EventGenerationConfiguration eventCfg, WorkflowContext context, boolean interactiveMode) {
        this.engineProxy = engineProxy;
        this.resultListener = resultListener;
        this.eventCfg = eventCfg;
        this.context = context;
        this.interactiveMode = interactiveMode;
        this.recovered = false;
        this.aborted = false;
    }

    public void onStart() {
        if (logger.isLoggable(Logger.CONFIG)) {
            logger.log(Logger.CONFIG, "Agent " + this.myAgent.getLocalName() + ": " + ((Object)((Object)this)).getClass().getSimpleName() + " started, sessionId=" + this.sessionId);
        }
        if (!this.aborted) {
            try {
                this.conversationId = this.buildConversationId();
                this.engineProxy.getHandlers().addToResultHandler(this.conversationId, this);
                this.sendRequest();
            }
            catch (Exception e) {
                logger.log(Logger.SEVERE, "Agent " + this.myAgent.getLocalName() + ": " + ((Object)((Object)this)).getClass().getSimpleName() + " Error sending request, sessionId=" + this.sessionId, (Throwable)e);
                this.engineProxy.getHandlers().removeFromResultHandler(this.conversationId);
                this.setAbortMessage(e.getMessage(), e);
            }
        }
    }

    public int onEnd() {
        if (logger.isLoggable(Logger.CONFIG)) {
            logger.log(Logger.CONFIG, "Agent " + this.myAgent.getLocalName() + ": " + ((Object)((Object)this)).getClass().getSimpleName() + " terminated, sessionId=" + this.sessionId);
        }
        return super.onEnd();
    }

    public void action() {
        if (!this.aborted) {
            if (this.executionId == null) {
                this.block();
            } else {
                this.controller = new WorkflowController(this.engineProxy, this.executor, this.executionId, this.sessionId, this.eventCfg, this.recovered, this);
                this.engineProxy.addController(this.sessionId, this.controller);
            }
        }
    }

    public boolean done() {
        return this.aborted || this.controller != null;
    }

    WorkflowController getWorkflowController() {
        return this.controller;
    }

    void abort(String abortMessage) {
        this.setAbortMessage(abortMessage, null);
        this.restart();
    }

    boolean isAborted() {
        return this.aborted;
    }

    protected void setAbortMessage(String abortMessage, Exception abortException) {
        this.abortMessage = abortMessage;
        this.abortException = abortException;
        this.aborted = true;
    }

    String getAbortMessage() {
        return this.abortMessage;
    }

    Exception getAbortException() {
        return this.abortException;
    }

    void setAgreeInfo(String executionId, AID executor) {
        this.executionId = executionId;
        this.executor = executor;
        this.restart();
    }

    String getExecutionId() {
        return this.executionId;
    }

    String getConversationId() {
        return this.conversationId;
    }

    String getSessionId() {
        return this.sessionId;
    }

    WorkflowResultListener getResultListener() {
        return this.resultListener;
    }

    private void sendRequest() throws Codec.CodecException, OntologyException {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(this.executor);
        request.setLanguage("LEAP");
        request.setOntology(this.onto.getName());
        request.setReplyByDate(new Date(System.currentTimeMillis() + 10000L));
        request.setConversationId(this.conversationId);
        AgentAction aa = this.prepareAgentAction();
        Action action = new Action(this.executor, (Concept)aa);
        this.myAgent.getContentManager().fillContent(request, (ContentElement)action);
        this.myAgent.send(request);
        if (logger.isLoggable(Logger.CONFIG)) {
            logger.log(Logger.CONFIG, "Agent " + this.myAgent.getLocalName() + ": " + ((Object)((Object)this)).getClass().getSimpleName() + " send request, action=" + action + ", sessionId=" + this.sessionId);
        }
    }

    private String buildConversationId() {
        return this.myAgent.getLocalName() + "-" + String.valueOf(++controllersCnt) + "-" + System.currentTimeMillis();
    }

    void update(WorkflowResultListener resultListener, EventGenerationConfiguration eventCfg, WorkflowContext context, boolean interactiveMode) {
        this.resultListener = resultListener;
        this.eventCfg = eventCfg;
        this.context = context;
        this.interactiveMode = interactiveMode;
    }

    protected List prepareControlInfos() {
        List cInfos = null;
        if (this.eventCfg != null) {
            cInfos = this.eventCfg.getControlInfos();
            for (ControlInfo cInfo : cInfos) {
                List controllers;
                String type = cInfo.getType();
                if (!type.equals("flow") && !type.equals("tracing") || (controllers = cInfo.getControllers()) != null && controllers.contains((Object)this.myAgent.getAID())) continue;
                cInfo.setController(this.myAgent.getAID());
            }
        }
        return cInfos;
    }

    protected List prepareModifiers() {
        ArrayList modifiers = null;
        if (this.context != null) {
            java.util.List<WebServiceSecurityContext> activitiesWssc;
            WebServiceSecurityContext wssc;
            modifiers = new ArrayList();
            DefaultParameterValues dpv = this.context.getDefaultParameterValues();
            if (dpv != null) {
                dpv.apply((List)modifiers);
            }
            if ((wssc = this.context.getWebServiceDefaultSecurityContext()) != null) {
                wssc.apply((List)modifiers);
            }
            if ((activitiesWssc = this.context.getWebServiceActivitiesSecurityContext()) != null) {
                for (WebServiceSecurityContext activitywssc : activitiesWssc) {
                    activitywssc.apply((List)modifiers);
                }
            }
        }
        if (this.interactiveMode) {
            Modifier proxyMod = new Modifier("INTERACTIVE_MODIFIER");
            proxyMod.setProperty("INTERACTIVE_AID", this.myAgent.getAID());
            if (modifiers == null) {
                modifiers = new ArrayList();
            }
            modifiers.add((Object)proxyMod);
        }
        return modifiers;
    }
}

