/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.core.Location;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.domain.JADEAgentManagement.CreateAgent;
import jade.domain.JADEAgentManagement.QueryPlatformLocationsAction;
import jade.lang.acl.ACLMessage;
import jade.util.leap.ArrayList;
import java.util.List;

public class AMSUtils {
    private static final long DEFAULT_AMS_REQUEST_TIMEOUT = 30000L;

    public static AID createAgent(Agent agent, String name, String className, Object[] args, String containerName) throws Exception {
        CreateAgent createagent = new CreateAgent();
        createagent.setAgentName(name);
        createagent.setClassName(className);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                createagent.addArguments(args[i]);
            }
        }
        if (containerName != null) {
            createagent.setContainer(new ContainerID(containerName, null));
        } else {
            createagent.setContainer((ContainerID)agent.here());
        }
        AMSUtils.requestAMSAction(agent, (AgentAction)createagent, 30000L);
        return new AID(name, false);
    }

    public static Location[] getLocations(Agent a) throws Exception {
        List locationList = ((ArrayList)AMSUtils.requestAMSAction(a, (AgentAction)new QueryPlatformLocationsAction(), 30000L)).toList();
        Location[] result = new Location[locationList.size()];
        return locationList.toArray(result);
    }

    public static Object requestAMSAction(Agent a, AgentAction action, long timeout) throws Exception {
        ACLMessage request = AMSUtils.createRequestMessage(a, a.getAMS(), "JADE-Agent-Management");
        Action act = new Action();
        act.setActor(a.getAMS());
        act.setAction((Concept)action);
        a.getContentManager().fillContent(request, (ContentElement)act);
        ACLMessage reply = FIPAService.doFipaRequestClient((Agent)a, (ACLMessage)request, (long)timeout);
        if (reply != null) {
            ContentElement ce = a.getContentManager().extractContent(reply);
            if (ce instanceof Result) {
                return ((Result)ce).getValue();
            }
            return null;
        }
        throw new FIPAException("Timeout expired");
    }

    public static ACLMessage createRequestMessage(Agent sender, AID receiver, String ontology) {
        ACLMessage request = new ACLMessage(16);
        request.setSender(sender.getAID());
        request.addReceiver(receiver);
        request.setProtocol("fipa-request");
        request.setLanguage("fipa-sl");
        request.setOntology(ontology);
        return request;
    }
}

