/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils;

import com.tilab.wade.commons.AgentRole;
import com.tilab.wade.commons.AgentType;
import com.tilab.wade.commons.WadeAgent;
import com.tilab.wade.utils.UriUtils;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.util.Logger;
import jade.util.leap.Iterator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFUtils {
    private static long DF_TIMEOUT = 5000L;
    private static int DF_RETRY = 10;
    protected static Logger myLogger = Logger.getMyLogger((String)DFUtils.class.getName());

    public static void register(Agent agent, DFAgentDescription dfad) throws FIPAException {
        try {
            DFService.register((Agent)agent, (DFAgentDescription)dfad);
        }
        catch (FIPAException fe) {
            if (DFUtils.isAlreadyRegistered(fe)) {
                if (DFUtils.isRestarting(dfad)) {
                    int i;
                    myLogger.log(Logger.WARNING, "Agent " + agent.getName() + " is restarting. Waiting for previous registration to be cleared", (Throwable)fe);
                    for (i = 0; i < DF_RETRY; ++i) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(DF_TIMEOUT);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        try {
                            DFService.register((Agent)agent, (DFAgentDescription)dfad);
                            return;
                        }
                        catch (FIPAException e) {
                            if (!DFUtils.isAlreadyRegistered(e)) {
                                throw e;
                            }
                            myLogger.log(Logger.WARNING, "Agent " + agent.getName() + ": Attempt " + (i + 1) + " to register with the DF failed. Previous registration still present");
                            continue;
                        }
                    }
                    if (i == DF_RETRY) {
                        myLogger.log(Logger.SEVERE, "Agent " + agent.getName() + ": Maximum number of DF registration attempts reached");
                        throw new FIPAException("already-registered");
                    }
                }
                DFService.modify((Agent)agent, (DFAgentDescription)dfad);
            }
            throw fe;
        }
    }

    private static boolean isAlreadyRegistered(FIPAException e) {
        return e.getMessage().contains("already-registered");
    }

    private static boolean isNotRegistered(FIPAException e) {
        return e.getMessage().contains("not-registered");
    }

    public static DFAgentDescription createDFAgentDescription(Agent agent, Map<String, Object> m) {
        DFAgentDescription dfd = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType(((WadeAgent)agent).getType().getDescription());
        sd.setOwnership(((WadeAgent)agent).getOwner());
        sd.setName(agent.getLocalName());
        if (m == null) {
            m = new HashMap<String, Object>();
        }
        m.put("AGENT-ROLE", ((WadeAgent)agent).getRole().getDescription());
        m.put("AGENT-CLASSNAME", agent.getClass().getName());
        m.put("AGENT-LOCATION", agent.here().getName());
        m.remove("AGENT-TYPE");
        m.remove("AGENT-OWNER");
        try {
            m.put("HOSTNAME", UriUtils.getLocalCanonicalHostname());
            m.put("HOSTADDRESS", InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException uhe) {
            myLogger.log(Logger.SEVERE, "Error retrieving local host information for DF registration of agent " + agent.getName(), (Throwable)uhe);
        }
        Set<Map.Entry<String, Object>> set = m.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            Object value = entry.getValue();
            if (value == null) continue;
            sd.addProperties(new Property(entry.getKey(), value));
        }
        dfd.setName(agent.getAID());
        dfd.addServices(sd);
        return dfd;
    }

    public static DFAgentDescription createDFAgentDescription(Agent agent) {
        return DFUtils.createDFAgentDescription(agent, null);
    }

    public static DFAgentDescription searchByName(Agent a, String localName) throws FIPAException {
        DFAgentDescription template = new DFAgentDescription();
        template.setName(new AID(localName, false));
        DFAgentDescription[] result = DFService.search((Agent)a, (DFAgentDescription)template);
        if (result.length > 0) {
            return result[0];
        }
        return null;
    }

    public static DFAgentDescription[] searchAllByType(Agent a, AgentType type, Property p) throws FIPAException {
        String typeDescription = null;
        if (type != null && !type.equals(AgentType.ANY)) {
            typeDescription = type.getDescription();
        }
        return DFUtils.searchAllByType(a, typeDescription, p);
    }

    public static DFAgentDescription[] searchAllByType(Agent a, String typeDescription, Property p) throws FIPAException {
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        if (typeDescription != null) {
            sd.setType(typeDescription);
        }
        if (p != null) {
            sd.addProperties(p);
        }
        template.addServices(sd);
        return DFService.search((Agent)a, (DFAgentDescription)template);
    }

    public static DFAgentDescription searchAnyByType(Agent a, AgentType type, Property p) throws FIPAException {
        String typeDescription = null;
        if (type != null && !type.equals(AgentType.ANY)) {
            typeDescription = type.getDescription();
        }
        return DFUtils.searchAnyByType(a, typeDescription, p);
    }

    public static DFAgentDescription searchAnyByType(Agent a, String typeDescription, Property p) throws FIPAException {
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        if (typeDescription != null) {
            sd.setType(typeDescription);
        }
        if (p != null) {
            sd.addProperties(p);
        }
        template.addServices(sd);
        SearchConstraints c = new SearchConstraints();
        c.setMaxResults(new Long(1L));
        DFAgentDescription[] result = DFService.search((Agent)a, (DFAgentDescription)template, (SearchConstraints)c);
        if (result.length > 0) {
            return result[0];
        }
        return null;
    }

    public static DFAgentDescription[] searchAllByRole(Agent a, AgentRole role, Property p) throws FIPAException {
        String roleDescription = null;
        if (role != null && !role.equals(AgentRole.ANY)) {
            roleDescription = role.getDescription();
        }
        return DFUtils.searchAllByRole(a, roleDescription, p);
    }

    public static DFAgentDescription[] searchAllByRole(Agent a, String roleDescription, Property p) throws FIPAException {
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        if (roleDescription != null) {
            sd.addProperties(new Property("AGENT-ROLE", (Object)roleDescription));
        }
        if (p != null) {
            sd.addProperties(p);
        }
        template.addServices(sd);
        return DFService.search((Agent)a, (DFAgentDescription)template);
    }

    public static DFAgentDescription searchAnyByRole(Agent a, AgentRole role, Property p) throws FIPAException {
        String roleDescription = null;
        if (role != null && !role.equals(AgentRole.ANY)) {
            roleDescription = role.getDescription();
        }
        return DFUtils.searchAnyByRole(a, roleDescription, p);
    }

    public static DFAgentDescription searchAnyByRole(Agent a, String roleDescription, Property p) throws FIPAException {
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        if (roleDescription != null) {
            sd.addProperties(new Property("AGENT-ROLE", (Object)roleDescription));
        }
        if (p != null) {
            sd.addProperties(p);
        }
        template.addServices(sd);
        SearchConstraints c = new SearchConstraints();
        c.setMaxResults(new Long(1L));
        DFAgentDescription[] result = DFService.search((Agent)a, (DFAgentDescription)template, (SearchConstraints)c);
        if (result.length > 0) {
            return result[0];
        }
        return null;
    }

    public static AID getAID(DFAgentDescription dfad) {
        if (dfad != null) {
            return dfad.getName();
        }
        return null;
    }

    public static AID[] getAIDs(DFAgentDescription[] dfad) {
        AID[] result = new AID[dfad.length];
        for (int i = 0; i < dfad.length; ++i) {
            result[i] = dfad[i].getName();
        }
        return result;
    }

    public static ServiceDescription getServiceDescription(DFAgentDescription dfad) {
        if (dfad != null) {
            return (ServiceDescription)dfad.getAllServices().next();
        }
        return null;
    }

    public static Object getPropertyValue(ServiceDescription s, String propertyKey) {
        Object result = null;
        Iterator it = s.getAllProperties();
        while (it.hasNext()) {
            Property p = (Property)it.next();
            if (!p.getName().equals(propertyKey)) continue;
            result = p.getValue();
            break;
        }
        return result;
    }

    private static boolean isRestarting(DFAgentDescription dfad) {
        boolean isRestarting = false;
        Object result = DFUtils.getPropertyValue(DFUtils.getServiceDescription(dfad), "_RESTARTING");
        if (result != null) {
            isRestarting = Boolean.parseBoolean((String)result);
        }
        return isRestarting;
    }
}

